/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.ResourceRichFacesImpl;
import com.liferay.faces.util.application.FilteredResourceBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.FacesContext;
import java.util.HashMap;

public class ResourceRichFacesCSSImpl
extends FilteredResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRichFacesCSSImpl.class);
    private Resource wrappedResource;

    public ResourceRichFacesCSSImpl(Resource wrappedResource) {
        this.wrappedResource = new ResourceRichFacesImpl(wrappedResource);
    }

    public Resource getWrapped() {
        return this.wrappedResource;
    }

    protected String filter(String cssText) {
        HashMap<String, String> resourceURLCache = new HashMap<String, String>();
        ResourceHandler resourceHandler = FacesContext.getCurrentInstance().getApplication().getResourceHandler();
        for (RichFacesImageResource richFacesImageResource : RichFacesImageResource.values()) {
            boolean doneProcessingURLs = false;
            while (!doneProcessingURLs) {
                String pathPrefix = richFacesImageResource.getPathPrefix();
                int urlStartPos = cssText.indexOf(pathPrefix);
                if (urlStartPos > 0) {
                    int fileNameStartPos = urlStartPos + pathPrefix.length();
                    int dotPos = cssText.indexOf(".", fileNameStartPos);
                    if (dotPos > 0) {
                        int extensionStartPos;
                        boolean doneFindingExtension = false;
                        int extensionFinishPos = extensionStartPos = dotPos + 1;
                        while (!doneFindingExtension) {
                            if (extensionFinishPos < cssText.length() && Character.isLetterOrDigit(cssText.charAt(extensionFinishPos))) {
                                ++extensionFinishPos;
                                continue;
                            }
                            doneFindingExtension = true;
                        }
                        String relativePathKey = cssText.substring(urlStartPos, extensionFinishPos);
                        String imageResourceURL = (String)resourceURLCache.get(relativePathKey);
                        if (imageResourceURL == null) {
                            String resourceName = cssText.substring(fileNameStartPos, extensionFinishPos);
                            String libraryName = richFacesImageResource.getLibraryName();
                            String substitutionToken = richFacesImageResource.getSubstitutionToken();
                            Resource imageResource = resourceHandler.createResource(resourceName, libraryName);
                            imageResourceURL = imageResource.getRequestPath();
                            imageResourceURL = imageResourceURL.replaceAll(libraryName, substitutionToken);
                            resourceURLCache.put(relativePathKey, imageResourceURL);
                        }
                        StringBuilder buf = new StringBuilder();
                        buf.append(cssText.substring(0, urlStartPos));
                        buf.append(imageResourceURL);
                        buf.append(cssText.substring(extensionFinishPos));
                        cssText = buf.toString();
                        continue;
                    }
                    logger.error("Unable to find image filename in URL");
                    continue;
                }
                doneProcessingURLs = true;
            }
        }
        for (RichFacesImageResource richFacesImageResource : RichFacesImageResource.values()) {
            cssText = cssText.replace(richFacesImageResource.getSubstitutionToken(), richFacesImageResource.getLibraryName());
        }
        return cssText;
    }

    private static enum RichFacesImageResource {
        TYPE1("org.richfaces", "../../org.richfaces.images/", "richfaces-type1"),
        TYPE2("org.richfaces", "../../", "richfaces-type2"),
        TYPE3("org.richfaces.images", "../org.richfaces.images/", "richfaces-type3"),
        TYPE4("org.richfaces.images", "org.richfaces.images/", "richfaces-type4");

        private String libraryName;
        private String pathPrefix;
        private String substitutionToken;

        private RichFacesImageResource(String libraryName, String pathPrefix, String substitutionToken) {
            this.libraryName = libraryName;
            this.pathPrefix = pathPrefix;
            this.substitutionToken = substitutionToken;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String getSubstitutionToken() {
            return this.substitutionToken;
        }
    }
}

