/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.ResourceHandlerBridgeImpl;
import com.liferay.faces.util.application.ResourceValidator;
import com.liferay.faces.util.application.ResourceValidatorFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.Map;

public class ResourceHandlerInnerImpl
extends ResourceHandlerBridgeImpl {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHandlerInnerImpl.class);

    public ResourceHandlerInnerImpl(ResourceHandler resourceHandler) {
        super(resourceHandler);
    }

    @Override
    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        String libraryName;
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String resourceName = (String)requestParameterMap.get("jakarta.faces.resource");
        if (resourceName == null) {
            resourceName = "";
        }
        if ((libraryName = (String)requestParameterMap.get("ln")) == null) {
            libraryName = "";
        }
        String resourceId = libraryName + "/" + resourceName;
        ResourceValidator resourceValidator = ResourceValidatorFactory.getResourceValidatorInstance((ExternalContext)externalContext);
        if (resourceValidator.containsBannedPath(resourceId)) {
            logger.warn("Invalid path for resourceId=[{0}]", new Object[]{resourceId});
            externalContext.setResponseStatus(404);
        } else if (resourceValidator.isBannedSequence(resourceId)) {
            logger.warn("Invalid sequence for resourceId=[{0}]", new Object[]{resourceId});
            externalContext.setResponseStatus(404);
        } else if (resourceValidator.isFaceletDocument(facesContext, resourceId)) {
            logger.warn("Invalid request for Facelet document resourceId=[{0}]", new Object[]{resourceId});
            externalContext.setResponseStatus(404);
        } else if (!resourceValidator.isValidResourceName(resourceName)) {
            logger.warn("Invalid request due to invalid resourceName=[{0}]", new Object[]{resourceName});
            externalContext.setResponseStatus(404);
        } else if (!resourceValidator.isValidLibraryName(libraryName)) {
            logger.warn("Invalid request due to invalid libraryName=[{0}]", new Object[]{libraryName});
            externalContext.setResponseStatus(404);
        } else {
            super.handleResourceRequest(facesContext);
        }
    }
}

