/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.external.reference.service.impl;

import com.liferay.external.reference.service.base.EROrganizationLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Dylan Rebelak
 */
@Component(
	property = "model.class.name=com.liferay.portal.kernel.model.Organization",
	service = AopService.class
)
public class EROrganizationLocalServiceImpl
	extends EROrganizationLocalServiceBaseImpl {

	@Override
	public Organization addOrUpdateOrganization(
			String externalReferenceCode, long userId,
			long parentOrganizationId, String name, String type, long regionId,
			long countryId, long statusId, String comments, boolean site,
			boolean hasLogo, byte[] logoBytes, ServiceContext serviceContext)
		throws PortalException {

		User user = _userLocalService.getUser(userId);

		Organization organization =
			_organizationLocalService.fetchOrganizationByReferenceCode(
				user.getCompanyId(), externalReferenceCode);

		if (organization == null) {
			organization = _organizationLocalService.addOrganization(
				userId, parentOrganizationId, name, type, regionId, countryId,
				statusId, comments, site, serviceContext);

			organization.setExternalReferenceCode(externalReferenceCode);

			_portal.updateImageId(
				organization, hasLogo, logoBytes, "logoId",
				_userFileUploadsSettings.getImageMaxSize(),
				_userFileUploadsSettings.getImageMaxHeight(),
				_userFileUploadsSettings.getImageMaxWidth());

			organization = _organizationLocalService.updateOrganization(
				organization);
		}
		else {
			_organizationLocalService.updateOrganization(
				user.getCompanyId(), organization.getOrganizationId(),
				parentOrganizationId, name, type, regionId, countryId, statusId,
				comments, hasLogo, logoBytes, site, serviceContext);
		}

		return organization;
	}

	@Reference
	private OrganizationLocalService _organizationLocalService;

	@Reference
	private Portal _portal;

	@Reference
	private UserFileUploadsSettings _userFileUploadsSettings;

	@Reference
	private UserLocalService _userLocalService;

}