/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.external.reference.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.external.reference.service.base.ERAssetCategoryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;

import java.util.Locale;
import java.util.Map;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Dylan Rebelak
 */
@Component(
	property = "model.class.name=com.liferay.asset.kernel.model.AssetCategory",
	service = AopService.class
)
public class ERAssetCategoryLocalServiceImpl
	extends ERAssetCategoryLocalServiceBaseImpl {

	@Override
	public AssetCategory addOrUpdateCategory(
			String externalReferenceCode, long userId, long groupId,
			long parentCategoryId, Map<Locale, String> titleMap,
			Map<Locale, String> descriptionMap, long vocabularyId,
			String[] categoryProperties, ServiceContext serviceContext)
		throws PortalException {

		User user = _userLocalService.getUser(userId);

		AssetCategory assetCategory =
			_assetCategoryLocalService.fetchAssetCategoryByReferenceCode(
				user.getCompanyId(), externalReferenceCode);

		if (assetCategory == null) {
			assetCategory = _assetCategoryLocalService.addCategory(
				userId, groupId, parentCategoryId, titleMap, descriptionMap,
				vocabularyId, categoryProperties, serviceContext);

			assetCategory.setExternalReferenceCode(externalReferenceCode);

			assetCategory = _assetCategoryLocalService.updateAssetCategory(
				assetCategory);
		}
		else {
			assetCategory = _assetCategoryLocalService.updateCategory(
				userId, assetCategory.getCategoryId(), parentCategoryId,
				titleMap, descriptionMap, vocabularyId, categoryProperties,
				serviceContext);
		}

		return assetCategory;
	}

	@Reference
	private AssetCategoryLocalService _assetCategoryLocalService;

	@Reference
	private UserLocalService _userLocalService;

}