/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.xstream;

import com.liferay.exportimport.kernel.xstream.XStreamConverter;
import com.liferay.exportimport.kernel.xstream.XStreamMarshallingContext;

import com.thoughtworks.xstream.converters.MarshallingContext;

import java.util.Iterator;

/**
 * @author Daniel Kocsis
 */
public class XStreamMarshallingContextAdapter
	implements XStreamMarshallingContext {

	public XStreamMarshallingContextAdapter(
		MarshallingContext marshallingContext) {

		_marshallingContext = marshallingContext;
	}

	@Override
	public void convertAnother(Object object) {
		_marshallingContext.convertAnother(object);
	}

	@Override
	public void convertAnother(
		Object object, XStreamConverter xStreamConverter) {

		_marshallingContext.convertAnother(
			object, new ConverterAdapter(xStreamConverter));
	}

	@Override
	public Object get(Object key) {
		return _marshallingContext.get(key);
	}

	@Override
	public Iterator<String> keys() {
		return _marshallingContext.keys();
	}

	@Override
	public void put(Object key, Object value) {
		_marshallingContext.put(key, value);
	}

	private final MarshallingContext _marshallingContext;

}