/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.upgrade.v1_0_2;

import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.staging.configuration.StagingConfiguration;

import java.util.Dictionary;

import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

/**
 * @author Tamas Molnar
 */
public class UpgradeExportImportServiceConfiguration extends UpgradeProcess {

	public UpgradeExportImportServiceConfiguration(
		ConfigurationAdmin configurationAdmin,
		ConfigurationProvider configurationProvider) {

		_configurationAdmin = configurationAdmin;
		_configurationProvider = configurationProvider;
	}

	@Override
	protected void doUpgrade() throws Exception {
		_upgradeExportImportServiceConfiguration();
	}

	private void _upgradeExportImportServiceConfiguration() throws Exception {
		Configuration[] exportImportServiceConfigurations =
			_configurationAdmin.listConfigurations(
				"(service.pid=" +
					ExportImportServiceConfiguration.class.getName() + "*)");

		if (exportImportServiceConfigurations == null) {
			return;
		}

		for (Configuration exportImportServiceConfiguration :
				exportImportServiceConfigurations) {

			Dictionary<String, Object> exportImportProperties =
				exportImportServiceConfiguration.getProperties();

			if (exportImportProperties == null) {
				continue;
			}

			Dictionary<String, Object> stagingProperties =
				HashMapDictionaryBuilder.<String, Object>put(
					"publishParentLayoutsByDefault",
					GetterUtil.getBoolean(
						exportImportProperties.remove(
							"publishParentLayoutsByDefault"),
						true)
				).put(
					"stagingDeleteTempLAROnFailure",
					GetterUtil.getBoolean(
						exportImportProperties.remove(
							"stagingDeleteTempLAROnFailure"),
						true)
				).put(
					"stagingDeleteTempLAROnSuccess",
					GetterUtil.getBoolean(
						exportImportProperties.remove(
							"stagingDeleteTempLarOnSuccess"),
						true)
				).put(
					"stagingUseVirtualHostForRemoteSite",
					GetterUtil.getBoolean(
						exportImportProperties.remove(
							"stagingUseVirtualHostForRemoteSite"))
				).build();

			exportImportServiceConfiguration.update(exportImportProperties);

			long companyId = GetterUtil.getLong(
				exportImportProperties.get("companyId"));

			if (companyId != 0) {
				stagingProperties.put("companyId", companyId);

				_configurationProvider.saveCompanyConfiguration(
					StagingConfiguration.class, companyId, stagingProperties);
			}
			else {
				_configurationProvider.saveSystemConfiguration(
					StagingConfiguration.class, stagingProperties);
			}
		}
	}

	private final ConfigurationAdmin _configurationAdmin;
	private final ConfigurationProvider _configurationProvider;

}