/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.lifecycle;

import com.liferay.exportimport.constants.ExportImportPortletKeys;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ProcessAwareExportImportLifecycleListener;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.backgroundtask.constants.BackgroundTaskConstants;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationDeliveryConstants;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.GetterUtil;

import java.io.Serializable;

import java.util.Map;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Akos Thurzo
 */
@Component(service = ExportImportLifecycleListener.class)
public class NotificationExportImportLifecycleListener
	implements ProcessAwareExportImportLifecycleListener {

	@Override
	public boolean isParallel() {
		return false;
	}

	@Override
	public void onProcessFailed(
			ExportImportLifecycleEvent exportImportLifecycleEvent)
		throws Exception {

		_sendNotification(BackgroundTaskConstants.STATUS_FAILED);
	}

	@Override
	public void onProcessStarted(
			ExportImportLifecycleEvent exportImportLifecycleEvent)
		throws Exception {
	}

	@Override
	public void onProcessSucceeded(
			ExportImportLifecycleEvent exportImportLifecycleEvent)
		throws Exception {

		_sendNotification(BackgroundTaskConstants.STATUS_SUCCESSFUL);
	}

	private JSONObject _getPayloadJSONObject(
		long backgroundTaskId, long exportImportConfigurationId, int status) {

		JSONObject jsonObject = _jsonFactory.createJSONObject();

		jsonObject.put(
			"backgroundTaskId", backgroundTaskId
		).put(
			"exportImportConfigurationId", exportImportConfigurationId
		).put(
			"status", status
		);

		return jsonObject;
	}

	private void _sendNotification(int status) throws Exception {
		long backgroundTaskId = BackgroundTaskThreadLocal.getBackgroundTaskId();

		BackgroundTask backgroundTask =
			_backgroundTaskLocalService.getBackgroundTask(backgroundTaskId);

		Map<String, Serializable> taskContextMap =
			backgroundTask.getTaskContextMap();

		long exportImportConfigurationId = GetterUtil.getLong(
			taskContextMap.get("exportImportConfigurationId"));

		_userNotificationEventLocalService.sendUserNotificationEvents(
			backgroundTask.getUserId(), ExportImportPortletKeys.EXPORT_IMPORT,
			UserNotificationDeliveryConstants.TYPE_WEBSITE,
			_getPayloadJSONObject(
				backgroundTaskId, exportImportConfigurationId, status));
	}

	@Reference
	private BackgroundTaskLocalService _backgroundTaskLocalService;

	@Reference
	private JSONFactory _jsonFactory;

	@Reference
	private UserNotificationEventLocalService
		_userNotificationEventLocalService;

}