/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.change.tracking.spi.reference;

import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.change.tracking.spi.reference.builder.ChildTableReferenceInfoBuilder;
import com.liferay.change.tracking.spi.reference.builder.ParentTableReferenceInfoBuilder;
import com.liferay.portal.kernel.model.SystemEventTable;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.SystemEventPersistence;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Preston Crary
 */
@Component(service = TableReferenceDefinition.class)
public class SystemEventTableReferenceDefinition
	implements TableReferenceDefinition<SystemEventTable> {

	@Override
	public void defineChildTableReferences(
		ChildTableReferenceInfoBuilder<SystemEventTable>
			childTableReferenceInfoBuilder) {
	}

	@Override
	public void defineParentTableReferences(
		ParentTableReferenceInfoBuilder<SystemEventTable>
			parentTableReferenceInfoBuilder) {

		parentTableReferenceInfoBuilder.groupedModel(
			SystemEventTable.INSTANCE
		).parentColumnReference(
			SystemEventTable.INSTANCE.systemEventId,
			SystemEventTable.INSTANCE.parentSystemEventId
		);
	}

	@Override
	public BasePersistence<?> getBasePersistence() {
		return _systemEventPersistence;
	}

	@Override
	public SystemEventTable getTable() {
		return SystemEventTable.INSTANCE;
	}

	@Reference
	private SystemEventPersistence _systemEventPersistence;

}