/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.background.task.display;

import com.liferay.exportimport.kernel.configuration.constants.ExportImportConfigurationConstants;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Akos Thurzo
 */
public class LayoutStagingBackgroundTaskDisplay
	extends ExportImportBackgroundTaskDisplay {

	public LayoutStagingBackgroundTaskDisplay(BackgroundTask backgroundTask) {
		super(backgroundTask);

		Map<String, Serializable> contextMap =
			backgroundTask.getTaskContextMap();

		ExportImportConfiguration exportImportConfiguration =
			ExportImportConfigurationLocalServiceUtil.
				fetchExportImportConfiguration(
					MapUtil.getLong(contextMap, "exportImportConfigurationId"));

		if (exportImportConfiguration != null) {
			if ((exportImportConfiguration.getType() !=
					ExportImportConfigurationConstants.
						TYPE_PUBLISH_LAYOUT_LOCAL) &&
				(exportImportConfiguration.getType() !=
					ExportImportConfigurationConstants.
						TYPE_SCHEDULED_PUBLISH_LAYOUT_LOCAL)) {

				return;
			}

			contextMap = exportImportConfiguration.getSettingsMap();
		}

		long sourceGroupId = MapUtil.getLong(contextMap, "sourceGroupId");

		sourceGroup = GroupLocalServiceUtil.fetchGroup(sourceGroupId);
	}

	@Override
	public String getDisplayName(HttpServletRequest httpServletRequest) {
		if ((sourceGroup != null) && !sourceGroup.isStagingGroup() &&
			(backgroundTask.getGroupId() == sourceGroup.getGroupId())) {

			return LanguageUtil.get(
				httpServletRequest, "initial-publish-process");
		}

		if (Validator.isNull(backgroundTask.getName())) {
			return LanguageUtil.get(httpServletRequest, "untitled");
		}

		return backgroundTask.getName();
	}

	protected Group sourceGroup;

}