/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.lar.ThemeImporter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThemeImporter.class})
public class ThemeImporterImpl
implements ThemeImporter {
    private static final Log _log = LogFactoryUtil.getLog(ThemeImporterImpl.class);
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;

    public void importTheme(PortletDataContext portletDataContext, LayoutSet layoutSet) throws Exception {
        Attribute colorSchemeIdAttribute;
        boolean importThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import theme settings " + importThemeSettings));
        }
        if (!importThemeSettings) {
            return;
        }
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long importGroupId = (Long)groupIds.get(layoutSet.getGroupId());
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        Element headerElement = importDataRootElement.element("header");
        String themeId = layoutSet.getThemeId();
        String colorSchemeId = layoutSet.getColorSchemeId();
        Attribute themeIdAttribute = headerElement.attribute("theme-id");
        if (themeIdAttribute != null) {
            themeId = themeIdAttribute.getValue();
        }
        if ((colorSchemeIdAttribute = headerElement.attribute("color-scheme-id")) != null) {
            colorSchemeId = colorSchemeIdAttribute.getValue();
        }
        this._layoutSetLocalService.updateLookAndFeel(importGroupId, layoutSet.isPrivateLayout(), themeId, colorSchemeId, layoutSet.getCss());
    }
}

