/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.internal.util.ExportImportPermissionUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionExporter {
    private static final Log _log = LogFactoryUtil.getLog(PermissionExporter.class);
    private static final PermissionExporter _permissionExporter = new PermissionExporter();

    public static PermissionExporter getInstance() {
        return _permissionExporter;
    }

    public void exportPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("portlet-data-permissions");
        Map permissionsMap = portletDataContext.getPermissions();
        for (Map.Entry entry : permissionsMap.entrySet()) {
            String[] permissionParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String resourceName = permissionParts[0];
            long resourcePK = GetterUtil.getLong((String)permissionParts[1]);
            Element portletDataElement = rootElement.addElement("portlet-data");
            portletDataElement.addAttribute("resource-name", resourceName);
            portletDataElement.addAttribute("resource-pk", String.valueOf(resourcePK));
            List permissionKeyValuePairs = (List)entry.getValue();
            for (KeyValuePair permissionKeyValuePair : permissionKeyValuePairs) {
                String roleName = permissionKeyValuePair.getKey();
                String actions = permissionKeyValuePair.getValue();
                Element permissionsElement = portletDataElement.addElement("permissions");
                permissionsElement.addAttribute("role-name", roleName);
                permissionsElement.addAttribute("actions", actions);
            }
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/portlet-data-permissions.xml", document.formattedString());
    }

    public void exportPortletPermissions(PortletDataContext portletDataContext, String portletId, Layout layout, Element portletElement) throws Exception {
        String resourceName = PortletIdCodec.decodePortletName((String)portletId);
        String resourcePrimKey = "";
        resourcePrimKey = layout != null ? PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId) : PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId);
        Element permissionsElement = portletElement.addElement("permissions");
        this._exportPermissions(portletDataContext, resourceName, resourcePrimKey, permissionsElement);
    }

    private PermissionExporter() {
    }

    private void _exportPermissions(PortletDataContext portletDataContext, String resourceName, String resourcePrimKey, Element permissionsElement) throws Exception {
        List actionIds = ResourceActionsUtil.getPortletResourceActions((String)resourceName);
        Map<Long, Set<String>> roleToActionIds = ExportImportPermissionUtil.getRoleIdsToActionIds(portletDataContext.getCompanyId(), resourceName, resourcePrimKey, actionIds);
        for (Map.Entry<Long, Set<String>> entry : roleToActionIds.entrySet()) {
            String roleName;
            Role role;
            Set<String> availableActionIds;
            block5: {
                availableActionIds = entry.getValue();
                long roleId = entry.getKey();
                role = RoleLocalServiceUtil.fetchRole((long)roleId);
                if (availableActionIds.isEmpty() && !role.isSystem()) continue;
                roleName = role.getName();
                if (role.isTeam()) {
                    try {
                        roleName = ExportImportPermissionUtil.getTeamRoleName(role.getDescriptiveName());
                    }
                    catch (PortalException portalException) {
                        if (!_log.isDebugEnabled()) break block5;
                        _log.debug((Throwable)portalException);
                    }
                }
            }
            Element roleElement = permissionsElement.addElement("role");
            roleElement.addAttribute("uuid", role.getUuid());
            roleElement.addAttribute("name", roleName);
            roleElement.addAttribute("title", role.getTitle());
            roleElement.addAttribute("description", role.getDescription());
            roleElement.addAttribute("type", String.valueOf(role.getType()));
            roleElement.addAttribute("subtype", role.getSubtype());
            for (String actionId : availableActionIds) {
                Element actionKeyElement = roleElement.addElement("action-key");
                actionKeyElement.addText(actionId);
            }
        }
    }
}

