/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseExportImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.LayoutExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportLocalService;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.sites.kernel.util.Sites;
import java.io.File;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.exportimport.internal.background.task.LayoutSetPrototypeMergeBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class LayoutSetPrototypeMergeBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    private static final String _TEMP_DIR = SystemProperties.get((String)"java.io.tmpdir") + "/liferay/layout_set_prototype/";
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeMergeBackgroundTaskExecutor.class);
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportLocalService _exportImportLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private Sites _sites;
    @Reference
    private UserLocalService _userLocalService;

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        boolean anyFailedLayoutModifiedSinceLastMerge = MapUtil.getBoolean((Map)parameterMap, (String)"anyFailedLayoutModifiedSinceLastMerge");
        long layoutSetId = MapUtil.getLong((Map)parameterMap, (String)"layoutSetId");
        long layoutSetPrototypeId = MapUtil.getLong((Map)parameterMap, (String)"layoutSetPrototypeId");
        try {
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(layoutSetId);
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
            UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
            long lastMergeTime = GetterUtil.getLong((String)settingsUnicodeProperties.getProperty("last-merge-time"));
            long lastMergeVersion = GetterUtil.getLong((String)settingsUnicodeProperties.getProperty("last-merge-version"));
            Date layoutSetPrototypeModifiedDate = layoutSetPrototype.getModifiedDate();
            if (lastMergeVersion == layoutSetPrototype.getMvccVersion() && lastMergeTime >= layoutSetPrototypeModifiedDate.getTime() && !anyFailedLayoutModifiedSinceLastMerge) {
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("Skipping background task ");
                    sb.append(backgroundTask.getBackgroundTaskId());
                    sb.append(", layoutSet ");
                    sb.append(layoutSetId);
                    sb.append(" is already up to date");
                    _log.debug((Object)sb.toString());
                }
                return new BackgroundTaskResult(3);
            }
            boolean importData = MapUtil.getBoolean((Map)parameterMap, (String)"importData");
            String cacheFileName = StringBundler.concat((Object[])new Object[]{_TEMP_DIR, layoutSetPrototype.getUuid(), importData, ".v", layoutSetPrototype.getMvccVersion(), ".lar"});
            File cacheFile = new File(cacheFileName);
            if (cacheFile.exists()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Using cached layout set prototype LAR file " + cacheFile.getAbsolutePath()));
                }
            } else {
                File larFile = this._exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
                try {
                    FileUtil.copyFile((File)larFile, (File)cacheFile);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)StringBundler.concat((String[])new String[]{"Copied ", larFile.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()}));
                    }
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to copy file ", larFile.getAbsolutePath(), " to ", cacheFile.getAbsolutePath()}), (Throwable)exception);
                    cacheFile = larFile;
                }
            }
            User user = this._userLocalService.getDefaultUser(layoutSet.getCompanyId());
            parameterMap.put("lastMergeVersion", new String[]{String.valueOf(layoutSetPrototype.getMvccVersion())});
            Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap((long)user.getUserId(), (long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), null, (Map)parameterMap, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
            TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new LayoutImportCallable(this._exportImportConfigurationLocalService.addExportImportConfiguration(user.getUserId(), layoutSet.getGroupId(), "", "", 6, importLayoutSettingsMap, 2, new ServiceContext()), cacheFile, layoutSet));
            return BackgroundTaskResult.SUCCESS;
        }
        catch (Throwable throwable) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
            LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
            UnicodeProperties layoutSetPrototypeSettingsUnicodeProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
            int mergeFailCount = GetterUtil.getInteger((String)layoutSetPrototypeSettingsUnicodeProperties.getProperty("merge-fail-count"));
            layoutSetPrototypeSettingsUnicodeProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
            this._layoutSetLocalService.updateLayoutSet(layoutSetPrototypeLayoutSet);
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Merge fail count increased to ", mergeFailCount, " for layout set prototype ", layoutSetPrototype.getLayoutSetPrototypeId()}), throwable);
            throw new SystemException(throwable);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutExportImportBackgroundTaskStatusMessageTranslator());
        this.setIsolationLevel(2);
    }

    private class LayoutImportCallable
    implements Callable<Void> {
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;
        private final LayoutSet _layoutSet;

        public LayoutImportCallable(ExportImportConfiguration exportImportConfiguration, File file, LayoutSet layoutSet) {
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
            this._layoutSet = layoutSet;
        }

        @Override
        public Void call() throws PortalException {
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                LayoutSetPrototypeMergeBackgroundTaskExecutor.this._sites.removeMergeFailFriendlyURLLayouts(this._layoutSet);
                LayoutSetPrototypeMergeBackgroundTaskExecutor.this._exportImportLocalService.importLayoutsDataDeletions(this._exportImportConfiguration, this._file);
                LayoutSetPrototypeMergeBackgroundTaskExecutor.this._exportImportLocalService.importLayouts(this._exportImportConfiguration, this._file);
                Void void_ = null;
                return void_;
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
            }
        }
    }
}

