/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.scheduler;

import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SchedulerJobConfiguration.class})
public class DeleteObsoleteBackgroundTasksSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final int[] _STATUSES = new int[]{5, 2, 3};
    private static final String[] _TASK_EXECUTOR_CLASS_NAMES = new String[]{"com.liferay.exportimport.internal.background.task.LayoutExportBackgroundTaskExecutor", "com.liferay.exportimport.internal.background.task.LayoutImportBackgroundTaskExecutor", "com.liferay.exportimport.internal.background.task.PortletExportBackgroundTaskExecutor", "com.liferay.exportimport.internal.background.task.PortletImportBackgroundTaskExecutor"};
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> this._companyLocalService.forEachCompanyId(companyId -> this._deleteObsoleteBackGroundTasks((long)companyId));
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)1, (TimeUnit)TimeUnit.DAY);
    }

    private void _deleteObsoleteBackGroundTasks(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._backgroundTaskLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId));
            Property modifiedDateProperty = PropertyFactoryUtil.forName((String)"modifiedDate");
            dynamicQuery.add(modifiedDateProperty.lt((Object)new Date(System.currentTimeMillis() - 2592000000L)));
            Property taskExecutorClassNameProperty = PropertyFactoryUtil.forName((String)"taskExecutorClassName");
            dynamicQuery.add(taskExecutorClassNameProperty.in((Object[])_TASK_EXECUTOR_CLASS_NAMES));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.in(_STATUSES));
        });
        actionableDynamicQuery.setPerformActionMethod(backgroundTask -> this._backgroundTaskLocalService.deleteBackgroundTask(backgroundTask));
        actionableDynamicQuery.performActions();
    }
}

