/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.upgrade.v1_0_2;

import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.staging.configuration.StagingConfiguration;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ExportImportServiceConfigurationUpgradeProcess
extends UpgradeProcess {
    private final ConfigurationAdmin _configurationAdmin;
    private final ConfigurationProvider _configurationProvider;

    public ExportImportServiceConfigurationUpgradeProcess(ConfigurationAdmin configurationAdmin, ConfigurationProvider configurationProvider) {
        this._configurationAdmin = configurationAdmin;
        this._configurationProvider = configurationProvider;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeExportImportServiceConfiguration();
    }

    private void _upgradeExportImportServiceConfiguration() throws Exception {
        Configuration[] exportImportServiceConfigurations = this._configurationAdmin.listConfigurations("(service.pid=" + ExportImportServiceConfiguration.class.getName() + "*)");
        if (exportImportServiceConfigurations == null) {
            return;
        }
        for (Configuration exportImportServiceConfiguration : exportImportServiceConfigurations) {
            Dictionary exportImportProperties = exportImportServiceConfiguration.getProperties();
            if (exportImportProperties == null) continue;
            HashMapDictionary stagingProperties = HashMapDictionaryBuilder.put((Object)"publishParentLayoutsByDefault", (Object)GetterUtil.getBoolean(exportImportProperties.remove("publishParentLayoutsByDefault"), (boolean)true)).put((Object)"stagingDeleteTempLAROnFailure", (Object)GetterUtil.getBoolean(exportImportProperties.remove("stagingDeleteTempLAROnFailure"), (boolean)true)).put((Object)"stagingDeleteTempLAROnSuccess", (Object)GetterUtil.getBoolean(exportImportProperties.remove("stagingDeleteTempLarOnSuccess"), (boolean)true)).put((Object)"stagingUseVirtualHostForRemoteSite", (Object)GetterUtil.getBoolean(exportImportProperties.remove("stagingUseVirtualHostForRemoteSite"))).build();
            exportImportServiceConfiguration.update(exportImportProperties);
            long companyId = GetterUtil.getLong(exportImportProperties.get("companyId"));
            if (companyId != 0L) {
                stagingProperties.put("companyId", companyId);
                this._configurationProvider.saveCompanyConfiguration(StagingConfiguration.class, companyId, (Dictionary)stagingProperties);
                continue;
            }
            this._configurationProvider.saveSystemConfiguration(StagingConfiguration.class, (Dictionary)stagingProperties);
        }
    }
}

