/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.exportimport.content.processor;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.repository.friendly.url.resolver.FileEntryFriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=DLReferences"}, service={ExportImportContentProcessor.class})
public class DLReferencesExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String[] _DL_REFERENCE_LEGACY_STOP_STRINGS = new String[]{"'", "&apos;", "\\'", "\\\"", "]", "}", ")", ">", "<", "|", "#", "\"", "&quot;", " "};
    private static final String[] _DL_REFERENCE_STOP_STRINGS = new String[]{"'", "&apos;", "\\'", "\\\"", "]", "}", ")", ">", "<", "\n", "|", "#", "?", "\"", "&quot;", " "};
    private static final int _OFFSET_COLON_PORT = 6;
    private static final Log _log = LogFactoryUtil.getLog(DLReferencesExportImportContentProcessor.class);
    private static final Pattern _jsonAttributePattern = Pattern.compile("\\\"[^\"\\\\\\\\]*\\\"\\s*:\\s*\\\"");
    private static final Pattern _jsonLocalizedPattern = Pattern.compile("\\\"[^\"\\\\]*\\\"\\s*:\\s*\\{\\\"[a-zA-Z_]+\\\"\\s*:\\s*\\\"[^\"\\\\]*");
    private static final Pattern _uuidPattern = Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}(?=[&,?]|$)");
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private FileEntryFriendlyURLResolver _fileEntryFriendlyURLResolver;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private VirtualHostLocalService _virtualHostLocalService;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        return this._replaceExportDLReferences(portletDataContext, stagedModel, content, exportReferencedContent);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        return this._replaceImportDLReferences(portletDataContext, stagedModel, content);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        if (this._isValidateDLReferences()) {
            this._validateDLReferences(groupId, content);
        }
    }

    private ObjectValuePair<String, Integer> _getDLReferenceEndPosObjectValuePair(String content, int beginPos, int endPos) {
        int urlPatternPos;
        String[] stopStrings = _DL_REFERENCE_LEGACY_STOP_STRINGS;
        if (!this._isLegacyURL(content, beginPos)) {
            stopStrings = _DL_REFERENCE_STOP_STRINGS;
        }
        if ((urlPatternPos = StringUtil.indexOfAny((String)content, (String[])stopStrings, (int)beginPos, (int)endPos)) == -1) {
            if (endPos != content.length()) {
                return null;
            }
            urlPatternPos = endPos;
        }
        return new ObjectValuePair((Object)content.substring(beginPos, urlPatternPos), (Object)urlPatternPos);
    }

    private Map<String, String[]> _getDLReferenceParameters(long groupId, String content, int beginPos, int endPos) {
        ObjectValuePair<String, Integer> dlReferenceEndPosObjectValuePair = this._getDLReferenceEndPosObjectValuePair(content, beginPos, endPos);
        if (dlReferenceEndPosObjectValuePair == null) {
            return null;
        }
        boolean legacyURL = this._isLegacyURL(content, beginPos);
        Map<String, Object> map = new HashMap<String, String[]>();
        String dlReference = (String)dlReferenceEndPosObjectValuePair.getKey();
        endPos = (Integer)dlReferenceEndPosObjectValuePair.getValue();
        while (dlReference.contains("&amp;")) {
            dlReference = StringUtil.replace((String)dlReference, (String)"&amp;", (String)"&");
        }
        if (!legacyURL) {
            String uuid;
            String[] pathArray = dlReference.split("/");
            if (pathArray.length < 3) {
                return map;
            }
            if (Objects.equals(pathArray[2], "d")) {
                if (pathArray.length >= 5) {
                    map.put("friendlyURL", new String[]{StringUtils.substringBefore((String)HttpComponentsUtil.decodeURL((String)pathArray[4]), (String)"#")});
                }
                if (pathArray.length >= 4) {
                    map.put("groupName", new String[]{pathArray[3]});
                }
            } else if (Objects.equals(pathArray[2], "portlet_file_entry")) {
                if (pathArray.length >= 4) {
                    map.put("groupId", new String[]{pathArray[3]});
                }
                if (pathArray.length >= 5) {
                    map.put("title", new String[]{StringUtils.substringBefore((String)HttpComponentsUtil.decodeURL((String)pathArray[4]), (String)"#")});
                }
            } else {
                map.put("groupId", new String[]{pathArray[2]});
                if (pathArray.length == 5) {
                    map.put("folderId", new String[]{pathArray[3]});
                    map.put("title", new String[]{StringUtils.substringBefore((String)HttpComponentsUtil.decodeURL((String)pathArray[4]), (String)"#")});
                }
            }
            if (Validator.isNotNull((String)(uuid = this._getUuid(dlReference)))) {
                map.put("uuid", new String[]{uuid});
            }
        } else {
            dlReference = dlReference.substring(dlReference.indexOf(63) + 1);
            map = HttpComponentsUtil.parameterMapFromString((String)dlReference);
            Object[] imageIds = null;
            if (map.containsKey("img_id")) {
                imageIds = (String[])map.get("img_id");
            } else if (map.containsKey("i_id")) {
                imageIds = (String[])map.get("i_id");
            }
            imageIds = (String[])ArrayUtil.filter((Object[])imageIds, Validator::isNotNull);
            if (ArrayUtil.isNotEmpty((Object[])imageIds)) {
                map.put("image_id", imageIds);
            }
        }
        map.put("endPos", new String[]{String.valueOf(endPos)});
        String groupIdString = MapUtil.getString(map, (Object)"groupId");
        if (groupIdString.equals("@group_id@")) {
            groupIdString = String.valueOf(groupId);
            map.put("groupId", new String[]{groupIdString});
        }
        return map;
    }

    private FileEntry _getFileEntry(Map<String, String[]> map) {
        FileEntry fileEntry;
        block17: {
            if (MapUtil.isEmpty(map)) {
                return null;
            }
            fileEntry = null;
            try {
                DLFileEntry dlFileEntry;
                String uuid = MapUtil.getString(map, (Object)"uuid");
                long groupId = MapUtil.getLong(map, (String)"groupId");
                if (Validator.isNotNull((String)uuid)) {
                    fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
                } else if (map.containsKey("friendlyURL")) {
                    String friendlyURL = MapUtil.getString(map, (Object)"friendlyURL");
                    fileEntry = this._resolveFileEntry(MapUtil.getString(map, (Object)"groupName"), friendlyURL);
                    if (fileEntry == null) {
                        throw new NoSuchFileEntryException("No file entry found for friendly URL " + friendlyURL);
                    }
                } else if (map.containsKey("folderId")) {
                    long folderId = MapUtil.getLong(map, (String)"folderId");
                    String name = MapUtil.getString(map, (Object)"name");
                    String title = MapUtil.getString(map, (Object)"title");
                    if (Validator.isNotNull((String)title)) {
                        try {
                            fileEntry = this._dlAppLocalService.getFileEntryByFileName(groupId, folderId, title);
                        }
                        catch (NoSuchFileEntryException noSuchFileEntryException) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Throwable)noSuchFileEntryException);
                            }
                            fileEntry = this._dlAppLocalService.getFileEntry(groupId, folderId, title);
                        }
                    } else {
                        DLFileEntry dlFileEntry2 = this._dlFileEntryLocalService.fetchFileEntryByName(groupId, folderId, name);
                        if (dlFileEntry2 != null) {
                            fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry2.getFileEntryId());
                        }
                    }
                } else if (map.containsKey("image_id") && (dlFileEntry = this._dlFileEntryLocalService.fetchFileEntryByAnyImageId(MapUtil.getLong(map, (String)"image_id"))) != null) {
                    fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block17;
                _log.warn((Throwable)exception);
            }
        }
        return fileEntry;
    }

    private Group _getGroup(String name) throws Exception {
        Group group = this._groupLocalService.fetchFriendlyURLGroup(CompanyThreadLocal.getCompanyId().longValue(), "/" + name);
        if (group != null) {
            return group;
        }
        User user = this._userLocalService.getUserByScreenName(CompanyThreadLocal.getCompanyId().longValue(), name);
        return user.getGroup();
    }

    private String _getUuid(String s) {
        Matcher matcher = _uuidPattern.matcher(s);
        String uuid = "";
        while (matcher.find()) {
            uuid = matcher.group(0);
        }
        return uuid;
    }

    private boolean _isCreoleReference(String content, int beginPos) {
        return content.regionMatches(true, beginPos - 2, "[[", 0, 2) || content.regionMatches(true, beginPos - 2, "{{", 0, 2);
    }

    private boolean _isExternalURL(long groupId, String content, int beginPos, int endPos) throws PortalException {
        ServiceContext serviceContext;
        if (beginPos == 0 && endPos == content.length() || this._isCreoleReference(content, beginPos) || this._isHTMLReference(content, beginPos) || this._isJSONReference(content, beginPos) || this._isStyleReference(content, beginPos)) {
            return false;
        }
        String portalURL = this._portal.getPathContext();
        if (Validator.isNull((String)portalURL) && (serviceContext = ServiceContextThreadLocal.getServiceContext()) != null && serviceContext.getThemeDisplay() != null) {
            portalURL = this._portal.getPortalURL(serviceContext.getThemeDisplay());
        }
        HashSet<Object> hostNames = new HashSet<Object>();
        hostNames.add(portalURL);
        Group group = this._groupLocalService.getGroup(groupId);
        for (VirtualHost virtualHost : this._virtualHostLocalService.getVirtualHosts(group.getCompanyId())) {
            String hostname = virtualHost.getHostname();
            hostNames.add(hostname);
            hostNames.add("http://" + hostname);
            hostNames.add("https://" + hostname);
        }
        int colonPos = 0;
        for (int i = 1; i <= 6 && i <= beginPos; ++i) {
            if (content.charAt(beginPos - i) != ':') continue;
            colonPos = i;
            break;
        }
        long urlPort = 0L;
        if (colonPos > 0) {
            urlPort = GetterUtil.getLong((String)content.substring(beginPos - colonPos + 1, beginPos));
        }
        for (String string : hostNames) {
            String substring;
            int curBeginPos;
            int serverPort;
            if (urlPort > 0L && urlPort != (long)(serverPort = this._portal.getPortalServerPort(string.startsWith("https://"))) || (curBeginPos = beginPos - string.length() - colonPos) < 0 || !(substring = content.substring(curBeginPos, endPos)).startsWith(string) || (curBeginPos != 0 || endPos != content.length()) && !this._isCreoleReference(content, curBeginPos) && !this._isHTMLReference(content, curBeginPos) && !this._isJSONReference(content, curBeginPos) && !this._isStyleReference(content, curBeginPos)) continue;
            return false;
        }
        return true;
    }

    private boolean _isHTMLReference(String content, int beginPos) {
        String[] attributes;
        if (content.regionMatches(beginPos - 1, "'", 0, 1) || content.regionMatches(beginPos - 1, "\"", 0, 1)) {
            --beginPos;
        }
        if (content.regionMatches(true, beginPos - 1, "\\", 0, 1)) {
            --beginPos;
        }
        for (String attribute : attributes = new String[]{"href=", "src="}) {
            if (!content.regionMatches(true, beginPos - attribute.length(), attribute, 0, attribute.length())) continue;
            return true;
        }
        return false;
    }

    private boolean _isJSONReference(String content, int beginPos) {
        String[] jsonAttributes = new String[]{"\"href\"", "\"url\""};
        int position = StringUtil.lastIndexOfAny((String)content, (String[])jsonAttributes, (int)beginPos);
        if (position == -1) {
            return false;
        }
        return _jsonAttributePattern.matcher(content.substring(position, beginPos)).matches() || _jsonLocalizedPattern.matcher(content.substring(position, beginPos)).matches();
    }

    private boolean _isLegacyURL(String content, int beginPos) {
        return !content.startsWith("/documents/", beginPos);
    }

    private boolean _isStyleReference(String content, int beginPos) {
        if (content.regionMatches((beginPos = this._skipWhiteSpacePos(content, beginPos)) - 1, "'", 0, 1) || content.regionMatches(beginPos - 1, "\"", 0, 1)) {
            --beginPos;
        }
        beginPos = this._skipWhiteSpacePos(content, beginPos);
        String url = "url(";
        return content.regionMatches(true, beginPos - url.length(), url, 0, 2);
    }

    private boolean _isValidateDLReferences() {
        try {
            ExportImportServiceConfiguration exportImportServiceConfiguration = (ExportImportServiceConfiguration)this._configurationProvider.getCompanyConfiguration(ExportImportServiceConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            return exportImportServiceConfiguration.validateFileEntryReferences();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return true;
        }
    }

    private String _replaceExportDLReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet") && ExportImportThreadLocal.isStagingInProcess()) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String contextPath = this._portal.getPathContext();
        String[] patterns = new String[]{contextPath.concat("/c/document_library/get_file?"), contextPath.concat("/documents/"), contextPath.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            block15: {
                Map<String, String[]> dlReferenceParameters = this._getDLReferenceParameters(portletDataContext.getScopeGroupId(), content, beginPos + contextPath.length(), endPos);
                FileEntry fileEntry = this._getFileEntry(dlReferenceParameters);
                if (fileEntry == null || this._isExternalURL(portletDataContext.getScopeGroupId(), content, beginPos, endPos)) {
                    endPos = beginPos - 1;
                    continue;
                }
                endPos = MapUtil.getInteger(dlReferenceParameters, (String)"endPos");
                try {
                    if (exportReferencedContent && !fileEntry.isInTrash()) {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)fileEntry, (String)"dependency");
                    } else {
                        Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                        String referenceType = "dependency";
                        if (fileEntry.isInTrash()) {
                            referenceType = "disposable_dependency";
                        }
                        portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)fileEntry, referenceType, true);
                    }
                    String path = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
                    StringBundler exportedReferenceSB = new StringBundler(10);
                    exportedReferenceSB.append("[$dl-reference=");
                    exportedReferenceSB.append(path);
                    if (dlReferenceParameters.containsKey("friendlyURL")) {
                        exportedReferenceSB.append("$,$include-friendly-url=true");
                    } else {
                        exportedReferenceSB.append("$,$include-uuid=");
                        exportedReferenceSB.append(dlReferenceParameters.containsKey("uuid"));
                    }
                    exportedReferenceSB.append("$]");
                    if (fileEntry.isInTrash()) {
                        String originalReference = sb.substring(beginPos, endPos);
                        exportedReferenceSB.append("[#dl-reference=");
                        exportedReferenceSB.append(originalReference);
                        if (dlReferenceParameters.containsKey("friendlyURL")) {
                            exportedReferenceSB.append("#,#include-friendly-url=true");
                        } else {
                            exportedReferenceSB.append("#,#include-uuid=");
                            exportedReferenceSB.append(dlReferenceParameters.containsKey("uuid"));
                        }
                        exportedReferenceSB.append("#]");
                    }
                    sb.replace(beginPos, endPos, exportedReferenceSB.toString());
                }
                catch (Exception exception) {
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process file entry ");
                    exceptionSB.append(fileEntry.getFileEntryId());
                    exceptionSB.append(" for staged model ");
                    exceptionSB.append(stagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                    ExportImportContentProcessorException exportImportContentProcessorException = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)exception);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)exceptionSB.toString(), (Throwable)exportImportContentProcessorException);
                    }
                    if (!_log.isWarnEnabled()) break block15;
                    _log.warn((Object)exceptionSB.toString());
                }
            }
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    private String _replaceImportDLReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, DLFileEntry.class);
        for (Element referenceElement : referenceElements) {
            Long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Element referenceDataElement = portletDataContext.getReferenceDataElement(stagedModel, DLFileEntry.class, classPK.longValue());
            String path = null;
            if (referenceDataElement != null) {
                path = referenceDataElement.attributeValue("path");
            }
            if (Validator.isNull(path)) {
                long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
                String className = referenceElement.attributeValue("class-name");
                path = ExportImportPathUtil.getModelPath((long)groupId, (String)className, (Serializable)classPK);
            }
            while (content.contains("[$dl-reference=" + path + "$,$include-friendly-url=true$]") || content.contains("[$dl-reference=" + path + "$,$include-uuid=false$]") || content.contains("[$dl-reference=" + path + "$,$include-uuid=true$]")) {
                String url;
                block14: {
                    try {
                        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, DLFileEntry.class, (Serializable)classPK);
                    }
                    catch (Exception exception) {
                        StringBundler exceptionSB = new StringBundler(6);
                        exceptionSB.append("Unable to process file entry ");
                        exceptionSB.append((Object)classPK);
                        exceptionSB.append(" for ");
                        exceptionSB.append(stagedModel.getModelClassName());
                        exceptionSB.append(" with primary key ");
                        exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                        ExportImportContentProcessorException exportImportContentProcessorException = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)exception);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)exceptionSB.toString(), (Throwable)exportImportContentProcessorException);
                        }
                        if (!_log.isWarnEnabled()) break block14;
                        _log.warn((Object)exceptionSB.toString());
                    }
                }
                Map dlFileEntryIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntry.class);
                long fileEntryId = MapUtil.getLong((Map)dlFileEntryIds, (long)classPK, (long)classPK);
                int beginPos = content.indexOf("[$dl-reference=" + path);
                int endPos = content.indexOf("$]", beginPos) + 2;
                FileEntry importedFileEntry = null;
                try {
                    importedFileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)portalException);
                    }
                    if (content.startsWith("[#dl-reference=", endPos)) {
                        int prefixPos = endPos + "[#dl-reference=".length();
                        int postfixPos = content.indexOf("#]", prefixPos);
                        String originalReference = content.substring(prefixPos, postfixPos);
                        String exportedReference = content.substring(beginPos, postfixPos + 2);
                        content = StringUtil.replace((String)content, (String)exportedReference, (String)originalReference);
                        continue;
                    }
                    throw portalException;
                }
                boolean appendVersion = false;
                if (!content.contains("$include-friendly-url=true$")) {
                    appendVersion = true;
                }
                if ((url = this._dlURLHelper.getPreviewURL(importedFileEntry, importedFileEntry.getFileVersion(), null, "", appendVersion, false)).contains("?")) {
                    url = url.substring(0, url.lastIndexOf("?"));
                }
                String urlWithoutUUID = url.substring(0, url.lastIndexOf("/"));
                String exportedReferenceFriendlyURL = "[$dl-reference=" + path + "$,$include-friendly-url=true$]";
                String exportedReferenceWithoutUUID = "[$dl-reference=" + path + "$,$include-uuid=false$]";
                String exportedReferenceWithUUID = "[$dl-reference=" + path + "$,$include-uuid=true$]";
                if (content.startsWith("[#dl-reference=", endPos)) {
                    int friendlyURLPosition = content.indexOf("#,#include-friendly-url=true", beginPos);
                    endPos = friendlyURLPosition != -1 ? friendlyURLPosition + 2 : content.indexOf("#,#include-uuid=", beginPos) + 2;
                    exportedReferenceFriendlyURL = content.substring(beginPos, endPos) + "#include-friendly-url=true#]";
                    exportedReferenceWithoutUUID = content.substring(beginPos, endPos) + "#include-uuid=false#]";
                    exportedReferenceWithUUID = content.substring(beginPos, endPos) + "#include-uuid=true#]";
                }
                content = StringUtil.replace((String)content, (String)exportedReferenceFriendlyURL, (String)url);
                content = StringUtil.replace((String)content, (String)exportedReferenceWithUUID, (String)url);
                content = StringUtil.replace((String)content, (String)exportedReferenceWithoutUUID, (String)urlWithoutUUID);
            }
        }
        return content;
    }

    private FileEntry _resolveFileEntry(String groupName, String friendlyURL) throws Exception {
        if (this._fileEntryFriendlyURLResolver == null) {
            return null;
        }
        Group group = this._getGroup(groupName);
        return this._fileEntryFriendlyURLResolver.resolveFriendlyURL(group.getGroupId(), friendlyURL);
    }

    private int _skipWhiteSpacePos(String content, int beginPos) {
        while (content.regionMatches(beginPos - 1, "\n", 0, 1) || content.regionMatches(beginPos - 1, "\r", 0, 1) || content.regionMatches(beginPos - 1, " ", 0, 1) || content.regionMatches(beginPos - 1, "\t", 0, 1)) {
            --beginPos;
        }
        return beginPos;
    }

    private void _validateDLReferences(long groupId, String content) throws PortalException {
        String pathContext = this._portal.getPathContext();
        String[] patterns = new String[]{pathContext.concat("/c/document_library/get_file?"), pathContext.concat("/documents/"), pathContext.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            Map<String, String[]> dlReferenceParameters = this._getDLReferenceParameters(groupId, content, beginPos + pathContext.length(), endPos);
            if (dlReferenceParameters == null) {
                endPos = beginPos - 1;
                continue;
            }
            FileEntry fileEntry = this._getFileEntry(dlReferenceParameters);
            if (fileEntry == null && !this._isExternalURL(groupId, content, beginPos, endPos)) {
                ExportImportContentValidationException exportImportContentValidationException = new ExportImportContentValidationException(DLReferencesExportImportContentProcessor.class.getName(), (Throwable)new NoSuchFileEntryException());
                exportImportContentValidationException.setDLReferenceParameters(dlReferenceParameters);
                ObjectValuePair<String, Integer> dlReferenceEndPosObjectValuePair = this._getDLReferenceEndPosObjectValuePair(content, beginPos, endPos);
                exportImportContentValidationException.setDLReference((String)dlReferenceEndPosObjectValuePair.getKey());
                exportImportContentValidationException.setType(5);
                throw exportImportContentValidationException;
            }
            endPos = beginPos - 1;
        }
    }
}

