/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseExportImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.LayoutExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class LayoutSetPrototypeImportBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeImportBackgroundTaskExecutor.class);

    public LayoutSetPrototypeImportBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutExportImportBackgroundTaskStatusMessageTranslator());
        this.setIsolationLevel(3);
    }

    public BackgroundTaskExecutor clone() {
        LayoutSetPrototypeImportBackgroundTaskExecutor layoutSetPrototypeImportBackgroundTaskExecutor = new LayoutSetPrototypeImportBackgroundTaskExecutor();
        layoutSetPrototypeImportBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        layoutSetPrototypeImportBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return layoutSetPrototypeImportBackgroundTaskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        List attachmentsFileEntries = backgroundTask.getAttachmentsFileEntries();
        File file = null;
        for (FileEntry attachmentsFileEntry : attachmentsFileEntries) {
            try {
                file = FileUtil.createTempFile((String)"lar");
                FileUtil.write((File)file, (InputStream)attachmentsFileEntry.getContentStream());
                TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new LayoutImportCallable(exportImportConfiguration, file));
            }
            catch (Throwable throwable) {
                Map settingsMap = exportImportConfiguration.getSettingsMap();
                Map parameterMap = (Map)settingsMap.get("parameterMap");
                long layoutSetPrototypeId = MapUtil.getLong((Map)parameterMap, (String)"layoutSetPrototypeId");
                LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)layoutSetPrototypeId);
                LayoutSet layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
                UnicodeProperties layoutSetPrototypeSettingsUnicodeProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
                int mergeFailCount = GetterUtil.getInteger((String)layoutSetPrototypeSettingsUnicodeProperties.getProperty("merge-fail-count"));
                layoutSetPrototypeSettingsUnicodeProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
                LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSetPrototypeLayoutSet);
                StringBundler sb = new StringBundler(4);
                sb.append("Merge fail count increased to ");
                sb.append(mergeFailCount);
                sb.append(" for layout set prototype ");
                sb.append(layoutSetPrototype.getLayoutSetPrototypeId());
                _log.error((Object)sb.toString(), throwable);
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
                FileUtil.delete((File)file);
            }
        }
        return BackgroundTaskResult.SUCCESS;
    }

    private static class LayoutImportCallable
    implements Callable<Void> {
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;

        public LayoutImportCallable(ExportImportConfiguration exportImportConfiguration, File file) {
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
        }

        @Override
        public Void call() throws PortalException {
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                ExportImportLocalServiceUtil.importLayoutsDataDeletions((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
                ExportImportLocalServiceUtil.importLayouts((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
                Void void_ = null;
                return void_;
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
            }
        }
    }
}

