/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseStagingBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.LayoutStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.exception.MissingReferenceException;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portlet.exportimport.service.http.StagingServiceHttp;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayoutRemoteStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(LayoutRemoteStagingBackgroundTaskExecutor.class);

    public LayoutRemoteStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        LayoutRemoteStagingBackgroundTaskExecutor layoutRemoteStagingBackgroundTaskExecutor = new LayoutRemoteStagingBackgroundTaskExecutor();
        layoutRemoteStagingBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        layoutRemoteStagingBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return layoutRemoteStagingBackgroundTaskExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) {
        MissingReferences missingReferences;
        File file;
        block9: {
            ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
            this.clearBackgroundTaskStatus(backgroundTask);
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            file = null;
            HttpPrincipal httpPrincipal = null;
            missingReferences = null;
            long stagingRequestId = 0L;
            try {
                currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
                ExportImportThreadLocal.setLayoutStagingInProcess((boolean)true);
                ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)18, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
                Map settingsMap = exportImportConfiguration.getSettingsMap();
                long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
                boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
                this.initThreadLocals(sourceGroupId, privateLayout);
                Map layoutIdMap = (Map)settingsMap.get("layoutIdMap");
                long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
                Map taskContextMap = backgroundTask.getTaskContextMap();
                httpPrincipal = (HttpPrincipal)taskContextMap.get("httpPrincipal");
                file = this.exportLayoutsAsFile(exportImportConfiguration, layoutIdMap, targetGroupId, httpPrincipal);
                String checksum = FileUtil.getMD5Checksum((File)file);
                stagingRequestId = StagingServiceHttp.createStagingRequest((HttpPrincipal)httpPrincipal, (long)targetGroupId, (String)checksum);
                StagingUtil.transferFileToRemoteLive((File)file, (long)stagingRequestId, (HttpPrincipal)httpPrincipal);
                this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
                missingReferences = StagingServiceHttp.publishStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (ExportImportConfiguration)exportImportConfiguration);
                Map dependencyMissingReferences = missingReferences.getDependencyMissingReferences();
                if (!dependencyMissingReferences.isEmpty()) {
                    throw new MissingReferenceException(missingReferences);
                }
                this.deleteExportedChangesetEntries();
                ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
                ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)17, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
                ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
                ExportImportHelperUtil.processBackgroundTaskManifestSummary((long)serviceContext.getUserId(), (long)sourceGroupId, (BackgroundTask)backgroundTask, (File)file);
                currentThread.setContextClassLoader(contextClassLoader);
                if (stagingRequestId <= 0L || httpPrincipal == null) break block9;
            }
            catch (Throwable t) {
                try {
                    ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
                    ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)16, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
                    this.deleteTempLarOnFailure(file);
                    throw new SystemException(t);
                }
                catch (Throwable throwable) {
                    currentThread.setContextClassLoader(contextClassLoader);
                    if (stagingRequestId <= 0L) throw throwable;
                    if (httpPrincipal == null) throw throwable;
                    try {
                        StagingServiceHttp.cleanUpStagingRequest(httpPrincipal, (long)stagingRequestId);
                        throw throwable;
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) throw throwable;
                        _log.warn((Object)"Unable to clean up the remote live site", (Throwable)portalException);
                    }
                    throw throwable;
                }
            }
            try {
                StagingServiceHttp.cleanUpStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)"Unable to clean up the remote live site", (Throwable)portalException);
            }
        }
        this.deleteTempLarOnSuccess(file);
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    protected File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration, Map<Long, Boolean> layoutIdMap, long remoteGroupId, HttpPrincipal httpPrincipal) throws PortalException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        if (layoutIdMap != null) {
            Set<Map.Entry<Long, Boolean>> entrySet = layoutIdMap.entrySet();
            for (Map.Entry<Long, Boolean> entry : entrySet) {
                long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
                Layout layout = null;
                try {
                    layout = ExportImportHelperUtil.getLayoutOrCreateDummyRootLayout((long)plid);
                }
                catch (NoSuchLayoutException noSuchLayoutException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)noSuchLayoutException, (Throwable)noSuchLayoutException);
                    }
                    entrySet.remove(plid);
                    continue;
                }
                if (!layouts.contains(layout)) {
                    layouts.add(layout);
                }
                if (layout.getPlid() == 0L) continue;
                List<Layout> parentLayouts = this.getMissingRemoteParentLayouts(httpPrincipal, layout, remoteGroupId);
                for (Layout parentLayout : parentLayouts) {
                    if (layouts.contains(parentLayout)) continue;
                    layouts.add(parentLayout);
                }
                boolean includeChildren = entry.getValue();
                if (!includeChildren) continue;
                for (Layout childLayout : layout.getAllChildren()) {
                    if (layouts.contains(childLayout)) continue;
                    layouts.add(childLayout);
                }
            }
        }
        long[] layoutIds = ExportImportHelperUtil.getLayoutIds(layouts);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        settingsMap.remove("layoutIdMap");
        settingsMap.put("layoutIds", layoutIds);
        return ExportImportLocalServiceUtil.exportLayoutsAsFile((ExportImportConfiguration)exportImportConfiguration);
    }

    protected List<Layout> getMissingRemoteParentLayouts(HttpPrincipal httpPrincipal, Layout layout, long remoteGroupId) throws PortalException {
        Layout parentLayout;
        ArrayList<Layout> missingRemoteParentLayouts = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        while (parentLayoutId > 0L && !StagingServiceHttp.hasRemoteLayout((HttpPrincipal)httpPrincipal, (String)(parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId)).getUuid(), (long)remoteGroupId, (boolean)parentLayout.isPrivateLayout())) {
            missingRemoteParentLayouts.add(parentLayout);
            parentLayoutId = parentLayout.getParentLayoutId();
        }
        return missingRemoteParentLayouts;
    }
}

