/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.lifecycle;

import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Daniel Kocsis
 */
public class ExportImportLifecycleEventImpl
	implements ExportImportLifecycleEvent {

	@Override
	public List<Serializable> getAttributes() {
		return _attributes;
	}

	@Override
	public int getCode() {
		return _code;
	}

	@Override
	public int getProcessFlag() {
		return _processFlag;
	}

	@Override
	public String getProcessId() {
		return _processId;
	}

	@Override
	public void setAttributes(Serializable... attributes) {
		Collections.addAll(_attributes, attributes);
	}

	@Override
	public void setCode(int code) {
		_code = code;
	}

	@Override
	public void setProcessFlag(int processFlag) {
		_processFlag = processFlag;
	}

	@Override
	public void setProcessId(String processId) {
		_processId = processId;
	}

	private final List<Serializable> _attributes = new ArrayList<>();
	private int _code;
	private int _processFlag;
	private String _processId;

}