/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;

/**
 * @author Jonathan McCann
 */
public abstract class BaseUpgradeBackgroundTaskExecutorClassNames
	extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		String[][] renameTaskExecutorClassNamesArray =
			getRenameTaskExecutorClassNames();

		for (String[] renameTaskExecutorClassName :
				renameTaskExecutorClassNamesArray) {

			try (LoggingTimer loggingTimer = new LoggingTimer(
					renameTaskExecutorClassName[0])) {

				StringBundler sb = new StringBundler(5);

				sb.append(
					"update BackgroundTask set taskExecutorClassName = '");
				sb.append(renameTaskExecutorClassName[1]);
				sb.append("' where taskExecutorClassName = '");
				sb.append(renameTaskExecutorClassName[0]);
				sb.append("'");

				runSQL(sb.toString());
			}
		}
	}

	protected abstract String[][] getRenameTaskExecutorClassNames();

}