/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.background.task.display;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationConstants;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Akos Thurzo
 */
public class PortletExportImportBackgroundTaskDisplay
	extends ExportImportBackgroundTaskDisplay {

	public PortletExportImportBackgroundTaskDisplay(
		BackgroundTask backgroundTask) {

		super(backgroundTask);

		try {
			ExportImportConfiguration exportImportConfiguration =
				ExportImportConfigurationLocalServiceUtil.
					getExportImportConfiguration(
						MapUtil.getLong(
							backgroundTask.getTaskContextMap(),
							"exportImportConfigurationId"));

			if ((exportImportConfiguration.getType() !=
					ExportImportConfigurationConstants.TYPE_EXPORT_PORTLET) &&
				(exportImportConfiguration.getType() !=
					ExportImportConfigurationConstants.TYPE_IMPORT_PORTLET) &&
				(exportImportConfiguration.getType() !=
					ExportImportConfigurationConstants.
						TYPE_PUBLISH_PORTLET_LOCAL) &&
				(exportImportConfiguration.getType() !=
					ExportImportConfigurationConstants.
						TYPE_PUBLISH_PORTLET_REMOTE)) {

				throw new PortalException(
					"Invalid export import configuration type: " +
						exportImportConfiguration.getType());
			}

			portlet = PortletLocalServiceUtil.getPortletById(
				backgroundTask.getName());
		}
		catch (Exception exception) {
			throw new RuntimeException(exception);
		}
	}

	@Override
	public String getDisplayName(HttpServletRequest httpServletRequest) {
		if (Validator.isNull(backgroundTask.getName())) {
			return LanguageUtil.get(httpServletRequest, "untitled");
		}

		return portlet.getDisplayName();
	}

	protected Portlet portlet;

}