/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.notifications;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationConstants;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplayFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ExportImportPortlet"}, service={UserNotificationHandler.class})
public class ExportImportUserNotificationHandler
extends BaseUserNotificationHandler {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportUserNotificationHandler.class);
    @Reference
    private BackgroundTaskDisplayFactory _backgroundTaskDisplayFactory;
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;

    public ExportImportUserNotificationHandler() {
        this.setOpenDialog(true);
        this.setPortletId("com_liferay_exportimport_web_portlet_ExportImportPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        Locale locale = this._portal.getLocale(serviceContext.getRequest());
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)"com.liferay.staging.lang");
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        ExportImportConfiguration exportImportConfiguration = null;
        try {
            exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(jsonObject.getLong("exportImportConfigurationId"));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-process-referenced-by-this-notification-does-not-exist");
        }
        String typeLabel = ExportImportConfigurationConstants.getTypeLabel((int)exportImportConfiguration.getType());
        String message = "x-" + typeLabel;
        int status = jsonObject.getInt("status");
        if (status == 3) {
            message = message + "-process-finished-successfully";
        } else if (status == 2) {
            message = message + "-process-failed";
        } else {
            return "Unable to process notification: " + HtmlUtil.escape((String)jsonObject.toString());
        }
        long backgroundTaskId = jsonObject.getLong("backgroundTaskId");
        BackgroundTaskDisplay backgroundTaskDisplay = this._backgroundTaskDisplayFactory.getBackgroundTaskDisplay(backgroundTaskId);
        String processName = backgroundTaskDisplay.getDisplayName(serviceContext.getRequest());
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)message, (Object)processName);
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        LiferayPortletURL renderURL = PortletURLFactoryUtil.create((HttpServletRequest)serviceContext.getRequest(), (String)"com_liferay_exportimport_web_portlet_ExportImportPortlet", (String)"RENDER_PHASE");
        renderURL.setParameter("mvcPath", "/view_export_import.jsp");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        long backgroundTaskId = jsonObject.getLong("backgroundTaskId");
        BackgroundTask backgroundTask = this._backgroundTaskLocalService.fetchBackgroundTask(backgroundTaskId);
        if (backgroundTask == null) {
            return "";
        }
        renderURL.setParameter("backgroundTaskId", String.valueOf(backgroundTaskId));
        renderURL.setParameter("backURL", serviceContext.getCurrentURL());
        return renderURL.toString();
    }
}

