/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lifecycle;

import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.kernel.staging.StagingURLHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.service.http.StagingServiceHttp;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExportImportLifecycleListener.class})
public class EventRemotePropagatorExportImportLifecycleListener
implements ExportImportLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(EventRemotePropagatorExportImportLifecycleListener.class);
    @Reference
    private GroupLocalService _groupLocalService;
    private final Set<Integer> _propagatedEventTypes = new HashSet<Integer>();
    @Reference
    private Staging _staging;
    @Reference
    private StagingURLHelper _stagingURLHelper;
    @Reference
    private UserLocalService _userLocalService;

    public boolean isParallel() {
        return false;
    }

    public void onExportImportLifecycleEvent(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        if (this._eventNeedsToBePropagated(exportImportLifecycleEvent)) {
            this._propagateEvent(exportImportLifecycleEvent);
        }
    }

    @Activate
    protected void activate() {
        this._propagatedEventTypes.add(16);
        this._propagatedEventTypes.add(18);
        this._propagatedEventTypes.add(17);
    }

    private boolean _eventNeedsToBePropagated(ExportImportLifecycleEvent exportImportLifecycleEvent) {
        if (!this._propagatedEventTypes.contains(exportImportLifecycleEvent.getCode())) {
            return false;
        }
        Optional<ExportImportConfiguration> exportImportConfigurationOptional = this._getExportImportConfiguration(exportImportLifecycleEvent);
        Optional<Map> settingsMapOptional = exportImportConfigurationOptional.map(exportImportConfiguration -> exportImportConfiguration.getSettingsMap());
        Serializable sourceGroupIdSerializable = settingsMapOptional.map(settingsMap -> (Serializable)settingsMap.get("sourceGroupId")).orElse(Integer.valueOf(-1));
        long sourceGroupId = GetterUtil.getLong((Object)sourceGroupIdSerializable);
        Group sourceGroup = this._groupLocalService.fetchGroup(sourceGroupId);
        if (sourceGroup == null || !sourceGroup.isStagedRemotely()) {
            return false;
        }
        Serializable targetGroupIdSerializable = settingsMapOptional.map(settingsMap -> (Serializable)settingsMap.get("targetGroupId")).orElse(Integer.valueOf(-1));
        long targetGroupId = GetterUtil.getLong((Object)targetGroupIdSerializable);
        Group targetGroup = this._groupLocalService.fetchGroup(targetGroupId);
        UnicodeProperties typeSettings = sourceGroup.getTypeSettingsProperties();
        String remoteGroupUUID = typeSettings.getProperty("remoteGroupUUID");
        return !Validator.isNotNull((String)remoteGroupUUID) || targetGroup == null || !StringUtil.equals((String)remoteGroupUUID, (String)targetGroup.getUuid());
    }

    private Optional<ExportImportConfiguration> _getExportImportConfiguration(ExportImportLifecycleEvent exportImportLifecycleEvent) {
        List attributes = exportImportLifecycleEvent.getAttributes();
        return Optional.ofNullable((ExportImportConfiguration)attributes.get(0));
    }

    private Optional<HttpPrincipal> _getHttpPrincipal(ExportImportLifecycleEvent exportImportLifecycleEvent) {
        Optional<ExportImportConfiguration> exportImportConfigurationOptional = this._getExportImportConfiguration(exportImportLifecycleEvent);
        return exportImportConfigurationOptional.map(exportImportConfiguration -> exportImportConfiguration.getSettingsMap()).map(settingsMap -> MapUtil.getLong((Map)settingsMap, (String)"userId")).map(userId -> this._userLocalService.fetchUser(userId.longValue())).flatMap(user -> this._getHttpPrincipal((User)user, this._getRemoteURL(exportImportLifecycleEvent)));
    }

    private Optional<HttpPrincipal> _getHttpPrincipal(User user, String remoteURL) {
        HttpPrincipal httpPrincipal;
        block2: {
            httpPrincipal = null;
            try {
                httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to generate HttpPrincipal for user " + user.getFullName()), (Throwable)portalException);
            }
        }
        return Optional.ofNullable(httpPrincipal);
    }

    private String _getRemoteURL(ExportImportLifecycleEvent exportImportLifecycleEvent) {
        List attributes = exportImportLifecycleEvent.getAttributes();
        ExportImportConfiguration exportImportConfiguration = (ExportImportConfiguration)attributes.get(0);
        return this._stagingURLHelper.buildRemoteURL(exportImportConfiguration);
    }

    private void _propagateEvent(ExportImportLifecycleEvent exportImportLifecycleEvent) {
        this._getHttpPrincipal(exportImportLifecycleEvent).ifPresent(httpPrincipal -> {
            try {
                StagingServiceHttp.propagateExportImportLifecycleEvent((HttpPrincipal)httpPrincipal, (int)exportImportLifecycleEvent.getCode(), (int)exportImportLifecycleEvent.getProcessFlag(), (String)exportImportLifecycleEvent.getProcessId(), (List)exportImportLifecycleEvent.getAttributes());
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to propagate staging lifecycle event to the remote live site", (Throwable)portalException);
            }
        });
    }
}

