/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseExportImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.LayoutImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.PortletExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.internal.background.task.display.PortletExportImportBackgroundTaskDisplay;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;

public class PortletImportBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    public PortletImportBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new PortletExportImportBackgroundTaskStatusMessageTranslator());
        this.setIsolationLevel(3);
    }

    public BackgroundTaskExecutor clone() {
        PortletImportBackgroundTaskExecutor portletImportBackgroundTaskExecutor = new PortletImportBackgroundTaskExecutor();
        portletImportBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        portletImportBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return portletImportBackgroundTaskExecutor;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        List attachmentsFileEntries = backgroundTask.getAttachmentsFileEntries();
        File file = null;
        for (FileEntry attachmentsFileEntry : attachmentsFileEntries) {
            try {
                file = FileUtil.createTempFile((String)"lar");
                FileUtil.write((File)file, (InputStream)attachmentsFileEntry.getContentStream());
                TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new PortletImportCallable(exportImportConfiguration, file));
            }
            catch (IOException ioException) {
                ExportImportIOException exportImportIOException = new ExportImportIOException(LayoutImportBackgroundTaskExecutor.class.getName(), (Throwable)ioException);
                if (Validator.isNotNull((String)attachmentsFileEntry.getFileName())) {
                    exportImportIOException.setFileName(attachmentsFileEntry.getFileName());
                    exportImportIOException.setType(11);
                } else {
                    exportImportIOException.setType(10);
                }
                throw exportImportIOException;
            }
            catch (Throwable t) {
                throw new SystemException(t);
            }
            finally {
                FileUtil.delete((File)file);
            }
        }
        return BackgroundTaskResult.SUCCESS;
    }

    @Override
    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new PortletExportImportBackgroundTaskDisplay(backgroundTask);
    }

    private static class PortletImportCallable
    implements Callable<Void> {
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;

        public PortletImportCallable(ExportImportConfiguration exportImportConfiguration, File file) {
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
        }

        @Override
        public Void call() throws PortalException {
            ExportImportLocalServiceUtil.importPortletDataDeletions((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            ExportImportLocalServiceUtil.importPortletInfo((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            return null;
        }
    }
}

