/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.staging;

import com.liferay.changeset.model.ChangesetCollection;
import com.liferay.changeset.model.ChangesetEntry;
import com.liferay.changeset.service.ChangesetCollectionLocalService;
import com.liferay.changeset.service.ChangesetEntryLocalService;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactory;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.exception.ExportImportDocumentException;
import com.liferay.exportimport.kernel.exception.ExportImportIOException;
import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARFileSizeException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.exception.MissingReferenceException;
import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.MissingReference;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.StagingLocalService;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.kernel.staging.StagingConstants;
import com.liferay.exportimport.kernel.staging.StagingURLHelper;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryRegistryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.LayoutPrototypeException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutBranchException;
import com.liferay.portal.kernel.exception.NoSuchLayoutRevisionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.exception.RemoteOptionsException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.RecentLayoutBranch;
import com.liferay.portal.kernel.model.RecentLayoutRevision;
import com.liferay.portal.kernel.model.RecentLayoutSetBranch;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TypedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.model.adapter.StagedTheme;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutBranchLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.RecentLayoutBranchLocalService;
import com.liferay.portal.kernel.service.RecentLayoutRevisionLocalService;
import com.liferay.portal.kernel.service.RecentLayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.upload.UploadServletRequestConfigurationHelperUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.exportimport.service.http.StagingServiceHttp;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.staging.StagingGroupHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Staging.class})
public class StagingImpl
implements Staging {
    private static final Log _log = LogFactoryUtil.getLog(StagingImpl.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private ChangesetCollectionLocalService _changesetCollectionLocalService;
    @Reference
    private ChangesetEntryLocalService _changesetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLValidator _dlValidator;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportConfigurationParameterMapFactory _exportImportConfigurationParameterMapFactory;
    @Reference
    private ExportImportConfigurationSettingsMapFactory _exportImportConfigurationSettingsMapFactory;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutBranchLocalService _layoutBranchLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private LockManager _lockManager;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private RecentLayoutBranchLocalService _recentLayoutBranchLocalService;
    @Reference
    private RecentLayoutRevisionLocalService _recentLayoutRevisionLocalService;
    @Reference
    private RecentLayoutSetBranchLocalService _recentLayoutSetBranchLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private StagingLocalService _stagingLocalService;
    @Reference
    private StagingURLHelper _stagingURLHelper;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public <T extends BaseModel> void addModelToChangesetCollection(T model) throws PortalException {
        long groupId;
        if (!(model instanceof StagedGroupedModel) || ExportImportThreadLocal.isInitialLayoutStagingInProcess()) {
            return;
        }
        StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)model;
        if (this._stagedModelRepositoryHelper.isStagedModelInTrash((StagedModel)stagedGroupedModel)) {
            this.removeModelFromChangesetCollection(model);
            return;
        }
        if (stagedGroupedModel instanceof WorkflowedModel) {
            WorkflowedModel workflowedModel = (WorkflowedModel)stagedGroupedModel;
            StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)ExportImportClassedModelUtil.getClassName((ClassedModel)stagedGroupedModel));
            if (!ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)workflowedModel.getStatus())) {
                this.removeModelFromChangesetCollection(model);
                return;
            }
        }
        if ((groupId = stagedGroupedModel.getGroupId()) <= 0L) {
            return;
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return;
        }
        if (!this._stagingGroupHelper.isStagingGroup(group)) {
            return;
        }
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchOrAddChangesetCollection(groupId, "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        long classNameId = this._classNameLocalService.getClassNameId(stagedGroupedModel.getModelClassName());
        long classPK = (Long)stagedGroupedModel.getPrimaryKeyObj();
        this._changesetEntryLocalService.fetchOrAddChangesetEntry(changesetCollection.getChangesetCollectionId(), classNameId, classPK);
    }

    @Deprecated
    public String buildRemoteURL(ExportImportConfiguration exportImportConfiguration) {
        return this._stagingURLHelper.buildRemoteURL(exportImportConfiguration);
    }

    @Deprecated
    public String buildRemoteURL(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection) {
        return this._stagingURLHelper.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
    }

    @Deprecated
    public String buildRemoteURL(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean privateLayout) {
        return this.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
    }

    @Deprecated
    public String buildRemoteURL(UnicodeProperties typeSettingsProperties) {
        return this._stagingURLHelper.buildRemoteURL(typeSettingsProperties);
    }

    @Deprecated
    public void checkDefaultLayoutSetBranches(long userId, Group liveGroup, boolean branchingPublic, boolean branchingPrivate, boolean remote, ServiceContext serviceContext) throws PortalException {
        this._stagingLocalService.checkDefaultLayoutSetBranches(userId, liveGroup, branchingPublic, branchingPrivate, remote, serviceContext);
    }

    public long copyFromLive(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        long targetGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = this._groupLocalService.getGroup(targetGroupId);
        long sourceGroupId = stagingGroup.getLiveGroupId();
        boolean privateLayout = this.getPrivateLayout(portletRequest);
        long[] layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        Map publishLayoutLocalSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutLocalSettingsMap(user, sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = null;
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 1, publishLayoutLocalSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 1, publishLayoutLocalSettingsMap);
        return this.publishLayouts(user.getUserId(), exportImportConfiguration);
    }

    public long copyFromLive(PortletRequest portletRequest, Portlet portlet) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = this._portal.getScopeGroupId(this._portal.getHttpServletRequest(portletRequest), portlet.getPortletId());
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        return this.publishPortlet(themeDisplay.getUserId(), scopeGroupId, plid, portlet.getPortletId(), parameterMap, true);
    }

    @Deprecated
    public long copyPortlet(PortletRequest portletRequest, long sourceGroupId, long targetGroupId, long sourcePlid, long targetPlid, String portletId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        return this.publishPortlet(themeDisplay.getUserId(), sourceGroupId, targetGroupId, sourcePlid, targetPlid, portletId, parameterMap);
    }

    public long copyRemoteLayouts(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        String remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
        int remotePort = MapUtil.getInteger((Map)settingsMap, (String)"remotePort");
        String remotePathContext = MapUtil.getString((Map)settingsMap, (String)"remotePathContext");
        boolean secureConnection = MapUtil.getBoolean((Map)settingsMap, (String)"secureConnection");
        boolean remotePrivateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"remotePrivateLayout");
        return this.doCopyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public long copyRemoteLayouts(long exportImportConfigurationId) throws PortalException {
        return this.copyRemoteLayouts(this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public long copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout) throws PortalException {
        return this.copyRemoteLayouts(sourceGroupId, privateLayout, layoutIdMap, null, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout);
    }

    @Deprecated
    public long copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate) throws PortalException {
        return this.copyRemoteLayouts(sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout);
    }

    public long copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, String name, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        Map publishLayoutRemoteSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutRemoteSettingsMap(user.getUserId(), sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, user.getLocale(), user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 2, publishLayoutRemoteSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 2, publishLayoutRemoteSettingsMap);
        return this.doCopyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public void deleteLastImportSettings(Group liveGroup, boolean privateLayout) throws PortalException {
        List layouts = this._layoutLocalService.getLayouts(liveGroup.getGroupId(), privateLayout);
        for (Layout layout : layouts) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            HashSet<String> keys = new HashSet<String>();
            for (String key : typeSettingsProperties.keySet()) {
                if (!key.startsWith("last-import-")) continue;
                keys.add(key);
            }
            if (keys.isEmpty()) continue;
            for (String key : keys) {
                typeSettingsProperties.remove((Object)key);
            }
            this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), typeSettingsProperties.toString());
        }
    }

    public void deleteRecentLayoutRevisionId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid) {
        this.deleteRecentLayoutRevisionId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid);
    }

    public void deleteRecentLayoutRevisionId(long userId, long layoutSetBranchId, long plid) {
        RecentLayoutRevision recentLayoutRevision = this._recentLayoutRevisionLocalService.fetchRecentLayoutRevision(userId, layoutSetBranchId, plid);
        if (recentLayoutRevision != null) {
            this._recentLayoutRevisionLocalService.deleteRecentLayoutRevision(recentLayoutRevision);
        }
    }

    @Deprecated
    public void deleteRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid) {
        this.deleteRecentLayoutRevisionId(user.getUserId(), layoutSetBranchId, plid);
    }

    public JSONArray getErrorMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences) {
        JSONArray errorMessagesJSONArray = JSONFactoryUtil.createJSONArray();
        for (Map.Entry<String, MissingReference> missingReferenceEntry : missingReferences.entrySet()) {
            MissingReference missingReference = missingReferenceEntry.getValue();
            JSONObject errorMessageJSONObject = JSONFactoryUtil.createJSONObject();
            String className = missingReference.getClassName();
            Map referrers = missingReference.getReferrers();
            if (className.equals(StagedTheme.class.getName())) {
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"the-referenced-theme-x-is-not-deployed-in-the-current-environment", (Object)missingReference.getClassPK(), (boolean)false));
            } else if (referrers.size() == 1) {
                Set referrerDisplayNames = referrers.entrySet();
                Iterator iterator = referrerDisplayNames.iterator();
                Map.Entry entry = iterator.next();
                String referrerDisplayName = (String)entry.getKey();
                String referrerClassName = (String)entry.getValue();
                if (referrerClassName.equals(Portlet.class.getName())) {
                    referrerDisplayName = this._portal.getPortletTitle(referrerDisplayName, locale);
                }
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"referenced-by-a-x-x", (Object[])new String[]{ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName), referrerDisplayName}, (boolean)false));
            } else {
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"referenced-by-x-elements", (Object)referrers.size(), (boolean)true));
            }
            errorMessageJSONObject.put("name", missingReferenceEntry.getKey());
            Group group = this._groupLocalService.fetchGroup(missingReference.getGroupId());
            if (group != null) {
                errorMessageJSONObject.put("site", LanguageUtil.format((Locale)locale, (String)"in-site-x", (Object)missingReference.getGroupId(), (boolean)false));
            }
            errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)missingReference.getClassName()));
            errorMessagesJSONArray.put(errorMessageJSONObject);
        }
        return errorMessagesJSONArray;
    }

    @Deprecated
    public JSONArray getErrorMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences, Map<String, Serializable> contextMap) {
        return this.getErrorMessagesJSONArray(locale, missingReferences);
    }

    public JSONObject getExceptionMessagesJSONObject(Locale locale, Exception e, ExportImportConfiguration exportImportConfiguration) {
        String errorMessage = "";
        JSONArray errorMessagesJSONArray = null;
        int errorType = 0;
        JSONArray warningMessagesJSONArray = null;
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        Throwable cause = e.getCause();
        if (e.getCause() instanceof ConnectException) {
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            String remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
            String remotePort = MapUtil.getString((Map)settingsMap, (String)"remotePort");
            String argument = remoteAddress + ":" + remotePort;
            errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"could-not-connect-to-address-x.-please-verify-that-the-specified-port-is-correct-and-that-the-remote-server-is-configured-to-accept-requests-from-this-server", (Object)argument);
            errorType = 499;
        } else if (e instanceof DuplicateFileEntryException) {
            errorMessage = LanguageUtil.get((Locale)locale, (String)"please-enter-a-unique-document-name");
            errorType = 490;
        } else if (e instanceof ExportImportContentProcessorException) {
            ExportImportContentProcessorException eicpe = (ExportImportContentProcessorException)e;
            if (eicpe.getType() == 2) {
                errorMessage = Validator.isNotNull((String)eicpe.getStagedModelClassName()) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-referenced-article-because-it-cannot-be-found-with-key-x", (Object)String.valueOf(eicpe.getStagedModelClassPK())) : LanguageUtil.get((ResourceBundle)resourceBundle, (String)"unable-to-process-referenced-article-because-it-cannot-be-found");
            }
            errorType = 499;
        } else if (e instanceof ExportImportContentValidationException) {
            ExportImportContentValidationException eicve = (ExportImportContentValidationException)e;
            errorMessage = eicve.getType() == 6 ? (cause != null && cause.getLocalizedMessage() != null ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-journal-article-x", (Object)cause.getLocalizedMessage()) : LanguageUtil.get((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-journal-article")) : (eicve.getType() == 5 ? (Validator.isNotNull((String)eicve.getStagedModelClassName()) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-file-entry-because-it-cannot-be-found-with-the-following-parameters-x-within-the-content-of-x-with-primary-key-x", (Object[])new String[]{MapUtil.toString((Map)eicve.getDlReferenceParameters()), eicve.getStagedModelClassName(), String.valueOf(eicve.getStagedModelPrimaryKeyObj())}) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-file-entry-because-it-cannot-be-found-with-the-following-parameters-x", (Object)eicve.getDlReferenceParameters())) : (eicve.getType() == 2 ? (Validator.isNotNull((String)eicve.getStagedModelClassName()) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)StringBundler.concat((String[])new String[]{"unable-to-validate-referenced-page-with-url-x-", "because-the-page-group-with-url-x-cannot-be-", "found-within-the-content-of-x-with-primary-key-x"}), (Object[])new String[]{eicve.getLayoutURL(), eicve.getGroupFriendlyURL(), eicve.getStagedModelClassName(), String.valueOf(eicve.getStagedModelPrimaryKeyObj())}) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-page-with-url-x-because-the-page-group-with-url-x-cannot-be-found", (Object[])new String[]{eicve.getLayoutURL(), eicve.getGroupFriendlyURL()})) : (eicve.getType() == 3 ? (Validator.isNotNull((String)eicve.getStagedModelClassName()) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-page-because-it-cannot-be-found-with-the-following-parameters-x-within-the-content-of-x-with-primary-key-x", (Object[])new String[]{MapUtil.toString((Map)eicve.getLayoutReferenceParameters()), eicve.getStagedModelClassName(), String.valueOf(eicve.getStagedModelPrimaryKeyObj())}) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-page-because-it-cannot-be-found-with-the-following-parameters-x", (Object)eicve.getLayoutReferenceParameters())) : (eicve.getType() == 4 ? (Validator.isNotNull((String)eicve.getStagedModelClassName()) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-page-because-it-cannot-be-found-with-url-x-within-the-content-of-x-with-primary-key-x", (Object[])new String[]{eicve.getLayoutURL(), eicve.getStagedModelClassName(), String.valueOf(eicve.getStagedModelPrimaryKeyObj())}) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-referenced-page-because-it-cannot-be-found-with-url-x", (Object)eicve.getLayoutURL())) : (Validator.isNotNull((String)eicve.getStagedModelClassName()) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-content-of-x-with-primary-key-x-in-x", (Object[])new String[]{eicve.getClassName(), eicve.getStagedModelClassName(), String.valueOf(eicve.getStagedModelPrimaryKeyObj())}) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-validate-content-in-x", (Object)eicve.getClassName()))))));
            errorType = 499;
        } else if (e instanceof ExportImportDocumentException) {
            ExportImportDocumentException eide = (ExportImportDocumentException)e;
            errorMessage = eide.getType() == 2 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-parse-xml-document-for-portlet-x-during-import", (Object)eide.getPortletId()) : (eide.getType() == 3 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-parse-xml-portlet-preferences-for-portlet-x-while-importing-portlet-preferences", (Object)eide.getPortletId()) : LanguageUtil.get((ResourceBundle)resourceBundle, (String)"unable-to-parse-xml-document"));
            errorType = 499;
        } else if (e instanceof ExportImportIOException || cause instanceof SystemException && cause.getCause() instanceof ExportImportIOException) {
            ExportImportIOException eiioe = null;
            eiioe = e instanceof ExportImportIOException ? (ExportImportIOException)e : (ExportImportIOException)cause.getCause();
            errorMessage = eiioe.getType() == 2 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-add-data-bytes-to-the-lar-file-with-path-x", (Object)eiioe.getFileName()) : (eiioe.getType() == 3 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-add-data-stream-to-the-lar-file-with-path-x", (Object)eiioe.getFileName()) : (eiioe.getType() == 4 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-add-data-string-to-the-lar-file-with-path-x", (Object)eiioe.getFileName()) : (eiioe.getType() == 5 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-for-layout-import-while-executing-x-due-to-a-file-system-error", (Object)eiioe.getClassName()) : (eiioe.getType() == 6 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-x-for-layout-import-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{eiioe.getFileName(), eiioe.getClassName()}) : (eiioe.getType() == 7 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-for-layout-import-validation-while-executing-x-due-to-a-file-system-error", (Object)eiioe.getClassName()) : (eiioe.getType() == 8 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-x-for-layout-import-validation-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{eiioe.getFileName(), eiioe.getClassName()}) : (eiioe.getType() == 9 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-create-the-export-lar-manifest-file-for-portlet-x", (Object)eiioe.getPortletId()) : (eiioe.getType() == 10 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-for-portlet-import-while-executing-x-due-to-a-file-system-error", (Object)eiioe.getClassName()) : (eiioe.getType() == 11 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-x-for-portlet-import-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{eiioe.getFileName(), eiioe.getClassName()}) : (eiioe.getType() == 12 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-for-portlet-import-validation-while-executing-x-due-to-a-file-system-error", (Object)eiioe.getClassName()) : (eiioe.getType() == 13 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-x-for-portlet-import-validation-while-executing-x-due-to-a-file-system-error", (Object[])new String[]{eiioe.getFileName(), eiioe.getClassName()}) : (eiioe.getType() == 14 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-complete-remote-staging-publication-request-x-due-to-a-file-system-error", (Object)eiioe.getStagingRequestId()) : (eiioe.getType() == 15 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-process-lar-file-pieces-for-remote-staging-publication-because-lar-file-checksum-is-not-x", (Object)eiioe.getChecksum()) : (eiioe.getType() == 16 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-reassemble-lar-file-for-remote-staging-publication-request-x", (Object)eiioe.getStagingRequestId()) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"x-failed-due-to-a-file-system-error", (Object)eiioe.getClassName())))))))))))))));
            errorType = 499;
        } else if (e instanceof ExportImportRuntimeException) {
            _log.error((Object)e, (Throwable)e);
            ExportImportRuntimeException eire = (ExportImportRuntimeException)e;
            errorMessage = Validator.isNull((String)eire.getMessage()) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"an-unexpected-error-occurred-within-x", (Object)eire.getClassName()) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"the-following-error-occurred-within-x-x", (Object[])new String[]{eire.getClassName(), eire.getMessage()});
            errorType = 499;
        } else if (e instanceof FileExtensionException) {
            errorMessage = LanguageUtil.format((Locale)locale, (String)"document-names-must-end-with-one-of-the-following-extensions", (Object)".lar", (boolean)false);
            errorType = 491;
        } else if (e instanceof FileNameException) {
            errorMessage = LanguageUtil.get((Locale)locale, (String)"please-enter-a-file-with-a-valid-file-name");
            errorType = 492;
        } else if (e instanceof FileSizeException || e instanceof LARFileSizeException) {
            errorMessage = exportImportConfiguration != null && (exportImportConfiguration.getType() == 1 || exportImportConfiguration.getType() == 2 || exportImportConfiguration.getType() == 8 || exportImportConfiguration.getType() != 9) ? LanguageUtil.get((Locale)locale, (String)"file-size-limit-exceeded.-please-ensure-that-the-file-does-not-exceed-the-file-size-limit-in-both-the-live-environment-and-the-staging-environment") : LanguageUtil.format((Locale)locale, (String)"please-enter-a-file-with-a-valid-file-size-no-larger-than-x", (Object)TextFormatter.formatStorageSize((double)this._dlValidator.getMaxAllowableSize(), (Locale)locale), (boolean)false);
            errorType = 493;
        } else if (e instanceof LARTypeException) {
            LARTypeException lte = (LARTypeException)e;
            errorMessage = lte.getType() == 5 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"a-x-can-only-be-imported-to-a-x", (Object)"global-site") : (lte.getType() == 1 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"a-x-can-only-be-imported-to-a-x", (Object)LanguageUtil.get((Locale)locale, (String)"page-template")) : (lte.getType() == 2 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"a-x-can-only-be-imported-to-a-x", (Object)"site") : (lte.getType() == 3 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"a-x-can-only-be-imported-to-a-x", (Object)LanguageUtil.get((Locale)locale, (String)"site-template")) : LanguageUtil.format((ResourceBundle)resourceBundle, (String)"uploaded-lar-file-type-x-does-not-match-x", (Object[])new Object[]{lte.getActualLARType(), StringUtil.merge((Object[])lte.getExpectedLARTypes(), (String)", ")}))));
            errorType = 499;
        } else if (e instanceof LARFileException) {
            LARFileException lfe = (LARFileException)e;
            errorMessage = lfe.getType() == 2 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"invalid-manifest.xml-x", (Object)lfe.getMessage()) : (lfe.getType() == 1 ? LanguageUtil.get((ResourceBundle)resourceBundle, (String)"missing-manifest.xml") : LanguageUtil.get((Locale)locale, (String)"please-specify-a-lar-file-to-import"));
            errorType = 499;
        } else if (e instanceof LayoutImportException || cause instanceof LayoutImportException) {
            LayoutImportException lie = null;
            lie = e instanceof LayoutImportException ? (LayoutImportException)e : (LayoutImportException)cause;
            if (lie.getType() == 1) {
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"lar-build-number-x-does-not-match-portal-build-number-x", (Object[])lie.getArguments());
            } else if (lie.getType() == 2) {
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"lar-schema-version-x-does-not-match-deployed-export-import-schema-version-x", (Object[])lie.getArguments());
            } else if (lie.getType() == 3) {
                Object[] arguments = lie.getArguments();
                Portlet portlet = this._portletLocalService.getPortletById((String)arguments[1]);
                arguments[1] = portlet.getDisplayName();
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"applications's-schema-version-x-in-the-lar-is-not-valid-for-the-deployed-application-x-with-schema-version-x", (Object[])lie.getArguments());
            } else {
                errorMessage = e.getLocalizedMessage();
            }
            errorType = 499;
        } else if (e instanceof LayoutPrototypeException) {
            LayoutPrototypeException lpe = (LayoutPrototypeException)e;
            StringBundler sb = new StringBundler(4);
            sb.append("the-lar-file-could-not-be-imported-because-it-");
            sb.append("requires-page-templates-or-site-templates-that-could-");
            sb.append("not-be-found.-please-import-the-following-templates-");
            sb.append("manually");
            errorMessage = LanguageUtil.get((ResourceBundle)resourceBundle, (String)sb.toString());
            errorMessagesJSONArray = JSONFactoryUtil.createJSONArray();
            List missingLayoutPrototypes = lpe.getMissingLayoutPrototypes();
            for (Tuple missingLayoutPrototype : missingLayoutPrototypes) {
                String layoutPrototypeUuid = (String)missingLayoutPrototype.getObject(1);
                JSONObject errorMessageJSONObject = JSONUtil.put((String)"info", (Object)layoutPrototypeUuid);
                String layoutPrototypeName = (String)missingLayoutPrototype.getObject(2);
                errorMessageJSONObject.put("name", layoutPrototypeName);
                String layoutPrototypeClassName = (String)missingLayoutPrototype.getObject(0);
                errorMessageJSONObject.put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)layoutPrototypeClassName));
                errorMessagesJSONArray.put(errorMessageJSONObject);
            }
            errorType = 499;
        } else if (e instanceof LocaleException) {
            LocaleException le = (LocaleException)e;
            errorMessage = LanguageUtil.format((Locale)locale, (String)"the-available-languages-in-the-lar-file-x-do-not-match-the-site's-available-languages-x", (Object[])new String[]{StringUtil.merge((Collection)le.getSourceAvailableLocales(), (String)", "), StringUtil.merge((Collection)le.getTargetAvailableLocales(), (String)", ")}, (boolean)false);
            errorType = 499;
        } else if (e instanceof MissingReferenceException) {
            MissingReferenceException mre = (MissingReferenceException)e;
            errorMessage = exportImportConfiguration != null && (exportImportConfiguration.getType() == 1 || exportImportConfiguration.getType() == 2 || exportImportConfiguration.getType() == 8 || exportImportConfiguration.getType() != 9) ? LanguageUtil.get((Locale)locale, (String)"there-are-missing-references-that-could-not-be-found-in-the-live-environment-the-following-elements-are-published-from-their-own-site") : LanguageUtil.get((Locale)locale, (String)"there-are-missing-references-that-could-not-be-found-in-the-current-site");
            MissingReferences missingReferences = mre.getMissingReferences();
            errorMessagesJSONArray = this.getErrorMessagesJSONArray(locale, missingReferences.getDependencyMissingReferences());
            errorType = 499;
            warningMessagesJSONArray = this.getWarningMessagesJSONArray(locale, missingReferences.getWeakMissingReferences());
        } else if (e instanceof PortletDataException) {
            PortletDataException pde = (PortletDataException)e;
            String referrerClassName = pde.getStagedModelClassName();
            String referrerDisplayName = pde.getStagedModelDisplayName();
            String modelResource = ResourceActionsUtil.getModelResource((Locale)locale, (String)referrerClassName);
            if (pde.getType() == 25) {
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-create-a-portlet-data-context-for-company-x-because-it-is-being-deleted", (Object)String.valueOf(pde.getCompanyId()));
            } else if (pde.getType() == 10) {
                errorMessage = Validator.isNotNull((String)pde.getLocalizedMessage()) ? LanguageUtil.format((Locale)locale, (String)"the-following-error-in-x-while-deleting-its-data-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale), pde.getLocalizedMessage()}, (boolean)false) : LanguageUtil.format((Locale)locale, (String)"an-unexpected-error-in-x-while-deleting-its-data-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale)}, (boolean)false);
            } else if (pde.getType() == 15) {
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-return-the-export-data-group-element-for-group-x-because-the-root-data-element-is-not-initialized", (Object)pde.getStagedModelClassName());
            } else if (pde.getType() == 11) {
                errorMessage = Validator.isNotNull((String)pde.getLocalizedMessage()) ? LanguageUtil.format((Locale)locale, (String)"the-following-error-in-x-while-exporting-its-data-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale), pde.getLocalizedMessage()}, (boolean)false) : LanguageUtil.format((Locale)locale, (String)"an-unexpected-error-in-x-while-exporting-its-data-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale)}, (boolean)false);
            } else if (pde.getType() == 18) {
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-export-portlet-permissions-for-x-while-processing-portlet-preferences-during-export", (Object)pde.getPortletId());
            } else if (pde.getType() == 19) {
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-export-referenced-article-template-for-x-while-processing-portlet-preferences-during-export", (Object)pde.getPortletId());
            } else if (pde.getType() == 23) {
                String localizedMessage = pde.getLocalizedMessage();
                if (pde.getCause() instanceof ExportImportRuntimeException && Validator.isNull((String)pde.getMessage())) {
                    ExportImportRuntimeException eire = (ExportImportRuntimeException)pde.getCause();
                    localizedMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)eire.getMessageKey(), (Object[])eire.getData());
                }
                errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"the-x-x-could-not-be-exported-because-of-the-following-error-x", (Object[])new String[]{modelResource, referrerDisplayName, localizedMessage}, (boolean)false);
            } else {
                errorMessage = pde.getType() == 16 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-return-the-import-data-group-element-for-group-x-because-the-root-data-element-is-not-initialized", (Object)pde.getStagedModelClassName()) : (pde.getType() == 12 ? (Validator.isNotNull((String)pde.getLocalizedMessage()) ? LanguageUtil.format((Locale)locale, (String)"the-following-error-in-x-while-importing-its-data-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale), pde.getLocalizedMessage()}, (boolean)false) : LanguageUtil.format((Locale)locale, (String)"an-unexpected-error-in-x-while-importing-its-data-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale)}, (boolean)false)) : (pde.getType() == 20 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-import-portlet-permissions-for-x-while-processing-portlet-preferences-during-import", (Object)pde.getPortletId()) : (pde.getType() == 24 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"the-x-x-could-not-be-imported-because-of-the-following-error-x", (Object[])new String[]{modelResource, referrerDisplayName, pde.getLocalizedMessage()}, (boolean)false) : (pde.getType() == 4 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-could-not-be-exported-because-it-is-not-in-the-currently-exported-group", (Object[])new String[]{modelResource, referrerDisplayName}, (boolean)false) : (pde.getType() == 5 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-has-missing-references-that-could-not-be-found-during-the-process", (Object[])new String[]{modelResource, referrerDisplayName}, (boolean)false) : (pde.getType() == 14 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-missing-reference-could-not-be-found-during-the-process", (Object[])new String[]{modelResource, referrerDisplayName}, (boolean)false) : (pde.getType() == 13 ? (Validator.isNotNull((String)pde.getLocalizedMessage()) ? LanguageUtil.format((Locale)locale, (String)"the-following-error-in-x-while-preparing-its-manifest-has-stopped-the-process-x", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale), pde.getLocalizedMessage()}, (boolean)false) : LanguageUtil.format((Locale)locale, (String)"an-unexpected-error-in-x-while-preparing-its-manifest-has-stopped-the-process", (Object[])new String[]{this._portal.getPortletTitle(pde.getPortletId(), locale)}, (boolean)false)) : (pde.getType() == 8 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-could-not-be-exported-because-it-is-in-the-recycle-bin", (Object[])new String[]{modelResource, referrerDisplayName}, (boolean)false) : (pde.getType() == 9 ? LanguageUtil.format((Locale)locale, (String)"the-x-x-could-not-be-exported-because-its-workflow-status-is-not-exportable", (Object[])new String[]{modelResource, referrerDisplayName}, (boolean)false) : (pde.getType() == 21 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-update-journal-content-search-data-for-x-while-processing-portlet-preferences-during-import", (Object)pde.getPortletId()) : (pde.getType() == 22 ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"unable-to-update-portlet-preferences-for-x-during-import", (Object)pde.getPortletId()) : (Validator.isNotNull((String)referrerDisplayName) ? LanguageUtil.format((ResourceBundle)resourceBundle, (String)"the-following-error-occurred-while-processing-the-x-x-x", (Object[])new String[]{modelResource, referrerDisplayName, e.getLocalizedMessage()}) : e.getLocalizedMessage()))))))))))));
            }
            errorType = 499;
        } else if (e instanceof PortletIdException) {
            PortletIdException pie = (PortletIdException)e;
            Portlet portlet = this._portletLocalService.getPortletById(pie.getMessage());
            errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"a-x-can-only-be-imported-to-a-x", (Object)(portlet.getDisplayName() + " Portlet"));
            errorType = 499;
        } else if (e instanceof UploadRequestSizeException) {
            errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"upload-request-reached-the-maximum-permitted-size-of-x-bytes", (Object)String.valueOf(UploadServletRequestConfigurationHelperUtil.getMaxSize()));
            errorType = 493;
        } else {
            errorMessage = e.getLocalizedMessage();
            errorType = 499;
        }
        JSONObject exceptionMessagesJSONObject = JSONUtil.put((String)"message", (Object)errorMessage);
        if (errorMessagesJSONArray != null && errorMessagesJSONArray.length() > 0) {
            exceptionMessagesJSONObject.put("messageListItems", errorMessagesJSONArray);
        }
        exceptionMessagesJSONObject.put("status", errorType);
        if (warningMessagesJSONArray != null && warningMessagesJSONArray.length() > 0) {
            exceptionMessagesJSONObject.put("warningMessages", warningMessagesJSONArray);
        }
        return exceptionMessagesJSONObject;
    }

    @Deprecated
    public JSONObject getExceptionMessagesJSONObject(Locale locale, Exception e, Map<String, Serializable> contextMap) {
        throw new UnsupportedOperationException();
    }

    public Group getLiveGroup(Group group) {
        if (group == null) {
            return null;
        }
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            return group.getLiveGroup();
        }
        return group;
    }

    public Group getLiveGroup(long groupId) {
        if (groupId <= 0L) {
            return null;
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            return group.getLiveGroup();
        }
        return group;
    }

    public long getLiveGroupId(long groupId) {
        Group group = this.getLiveGroup(groupId);
        if (group == null) {
            return groupId;
        }
        return group.getGroupId();
    }

    @Deprecated
    public List<Layout> getMissingParentLayouts(Layout layout, long liveGroupId) throws PortalException {
        return this._exportImportHelper.getMissingParentLayouts(layout, liveGroupId);
    }

    public Group getPermissionStagingGroup(Group group) {
        if (group == null) {
            return null;
        }
        Group stagingGroup = group;
        if (!group.isStagedRemotely() && group.hasStagingGroup()) {
            try {
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                long scopeGroupId = stagingGroup.getGroupId();
                boolean hasManageStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"MANAGE_STAGING");
                boolean hasPublishStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"PUBLISH_STAGING");
                boolean hasViewStagingPermission = GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"VIEW_STAGING");
                if (hasManageStagingPermission || hasPublishStagingPermission || hasViewStagingPermission) {
                    stagingGroup = group.getStagingGroup();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stagingGroup;
    }

    public long getRecentLayoutRevisionId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid) throws PortalException {
        return this.getRecentLayoutRevisionId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid);
    }

    public long getRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid) throws PortalException {
        return this.getRecentLayoutRevisionId(user.getUserId(), layoutSetBranchId, plid);
    }

    public long getRecentLayoutSetBranchId(HttpServletRequest httpServletRequest, long layoutSetId) {
        RecentLayoutSetBranch recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.fetchRecentLayoutSetBranch(this._portal.getUserId(httpServletRequest), layoutSetId);
        if (recentLayoutSetBranch != null) {
            return recentLayoutSetBranch.getLayoutSetBranchId();
        }
        return 0L;
    }

    public long getRecentLayoutSetBranchId(User user, long layoutSetId) {
        RecentLayoutSetBranch recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.fetchRecentLayoutSetBranch(user.getUserId(), layoutSetId);
        if (recentLayoutSetBranch != null) {
            return recentLayoutSetBranch.getLayoutSetBranchId();
        }
        return 0L;
    }

    public long getRemoteLayoutPlid(long userId, long stagingGroupId, long plid) throws PortalException {
        Group stagingGroup = this._groupLocalService.fetchGroup(stagingGroupId);
        User user = this._userLocalService.fetchUser(userId);
        HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        return LayoutServiceHttp.getLayoutPlid((HttpPrincipal)httpPrincipal, (String)layout.getUuid(), (long)stagingGroup.getRemoteLiveGroupId(), (boolean)layout.isPrivateLayout());
    }

    public String getRemoteSiteURL(Group stagingGroup, boolean privateLayout) throws PortalException {
        if (!stagingGroup.isStagedRemotely()) {
            return "";
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        if (stagingGroup.isLayout()) {
            stagingGroup = stagingGroup.getParentGroup();
        }
        UnicodeProperties typeSettingsProperties = stagingGroup.getTypeSettingsProperties();
        HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(typeSettingsProperties), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        long remoteGroupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("remoteGroupId"));
        boolean secureConnection = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("secureConnection"));
        String groupDisplayURL = GroupServiceHttp.getGroupDisplayURL((HttpPrincipal)httpPrincipal, (long)remoteGroupId, (boolean)privateLayout, (boolean)secureConnection);
        try {
            URL remoteSiteURL = new URL(groupDisplayURL);
            String remoteAddress = typeSettingsProperties.getProperty("remoteAddress");
            remoteSiteURL = new URL(remoteSiteURL.getProtocol(), remoteAddress, remoteSiteURL.getPort(), remoteSiteURL.getFile());
            return remoteSiteURL.toString();
        }
        catch (MalformedURLException murle) {
            throw new PortalException((Throwable)murle);
        }
    }

    public String getSchedulerGroupName(String destinationName, long groupId) {
        return destinationName.concat("/").concat(String.valueOf(groupId));
    }

    public String getStagedPortletId(String portletId) {
        String key = portletId;
        if (key.startsWith("staged-portlet_")) {
            return key;
        }
        return "staged-portlet_".concat(portletId);
    }

    public long[] getStagingAndLiveGroupIds(long groupId) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return new long[]{groupId, 0L};
        }
        Group stagingGroup = group.getStagingGroup();
        if (stagingGroup != null) {
            return new long[]{stagingGroup.getGroupId(), groupId};
        }
        Group liveGroup = group.getLiveGroup();
        if (liveGroup != null) {
            return new long[]{groupId, liveGroup.getGroupId()};
        }
        return new long[]{groupId, 0L};
    }

    public Group getStagingGroup(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        Group stagingGroup = group;
        if (!group.isStagedRemotely() && group.hasStagingGroup()) {
            stagingGroup = group.getStagingGroup();
        }
        return stagingGroup;
    }

    @Deprecated
    public Map<String, String[]> getStagingParameters() {
        return this._exportImportConfigurationParameterMapFactory.buildParameterMap();
    }

    @Deprecated
    public Map<String, String[]> getStagingParameters(PortletRequest portletRequest) {
        return this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
    }

    public JSONArray getWarningMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences) {
        JSONArray warningMessagesJSONArray = JSONFactoryUtil.createJSONArray();
        for (Map.Entry<String, MissingReference> entry : missingReferences.entrySet()) {
            MissingReference missingReference = entry.getValue();
            Map referrers = missingReference.getReferrers();
            JSONObject errorMessageJSONObject = JSONFactoryUtil.createJSONObject();
            if (Validator.isNotNull((String)missingReference.getClassName())) {
                errorMessageJSONObject.put("info", LanguageUtil.format((Locale)locale, (String)"the-original-x-does-not-exist-in-the-current-environment", (Object)ResourceActionsUtil.getModelResource((Locale)locale, (String)missingReference.getClassName()), (boolean)false));
            }
            errorMessageJSONObject.put("size", referrers.size()).put("type", ResourceActionsUtil.getModelResource((Locale)locale, (String)entry.getKey()));
            warningMessagesJSONArray.put(errorMessageJSONObject);
        }
        return warningMessagesJSONArray;
    }

    @Deprecated
    public JSONArray getWarningMessagesJSONArray(Locale locale, Map<String, MissingReference> missingReferences, Map<String, Serializable> contextMap) {
        return this.getWarningMessagesJSONArray(locale, missingReferences);
    }

    public WorkflowTask getWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException {
        WorkflowInstanceLink workflowInstanceLink = this._workflowInstanceLinkLocalService.fetchWorkflowInstanceLink(layoutRevision.getCompanyId(), layoutRevision.getGroupId(), LayoutRevision.class.getName(), layoutRevision.getLayoutRevisionId());
        if (workflowInstanceLink == null) {
            return null;
        }
        List workflowTasks = WorkflowTaskManagerUtil.getWorkflowTasksByWorkflowInstance((long)layoutRevision.getCompanyId(), (Long)userId, (long)workflowInstanceLink.getWorkflowInstanceId(), (Boolean)false, (int)0, (int)1, null);
        if (!workflowTasks.isEmpty()) {
            return (WorkflowTask)workflowTasks.get(0);
        }
        return null;
    }

    public boolean hasWorkflowTask(long userId, LayoutRevision layoutRevision) throws PortalException {
        WorkflowTask workflowTask = this.getWorkflowTask(userId, layoutRevision);
        return workflowTask != null;
    }

    public boolean isChangeTrackingEnabled(long companyId) {
        return false;
    }

    public boolean isGroupAccessible(Group group, Group fromGroup) {
        if (fromGroup == null) {
            block6: {
                long companyId = group.getCompanyId();
                try {
                    Company company = this._companyLocalService.getCompany(companyId);
                    Group companyGroup = company.getGroup();
                    if (group.equals(companyGroup)) {
                        return true;
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Company group does not exist", (Throwable)pe);
                }
            }
            return false;
        }
        if (group.equals(fromGroup)) {
            return true;
        }
        if (group.isStaged() && !group.isStagedRemotely() && group.isStagingGroup()) {
            return false;
        }
        return !group.hasStagingGroup() || !fromGroup.equals(group.getStagingGroup());
    }

    public boolean isGroupAccessible(long groupId, long fromGroupId) throws PortalException {
        return this.isGroupAccessible(this._groupLocalService.getGroup(groupId), this._groupLocalService.getGroup(fromGroupId));
    }

    public boolean isIncomplete(Layout layout) {
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        return layoutRevision != null && this.isLayoutRevisionIncomplete(layout.getPlid(), layoutRevision, layoutRevision.getLayoutSetBranchId());
    }

    public boolean isIncomplete(Layout layout, long layoutSetBranchId) {
        return this.isLayoutRevisionIncomplete(layout.getPlid(), LayoutStagingUtil.getLayoutRevision((Layout)layout), layoutSetBranchId);
    }

    public boolean isRemoteLayoutHasPortletId(long userId, long stagingGroupId, long plid, String portletId) {
        Group stagingGroup = this._groupLocalService.fetchGroup(stagingGroupId);
        User user = this._userLocalService.fetchUser(userId);
        try {
            HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            return LayoutServiceHttp.hasPortletId((HttpPrincipal)httpPrincipal, (long)plid, (String)portletId);
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to determine if remote layout ", plid, " contains portlet ", portletId}), (Throwable)pe);
            }
            return false;
        }
    }

    @Deprecated
    public void lockGroup(long userId, long groupId) throws PortalException {
        if (this._lockManager.isLocked(Staging.class.getName(), groupId)) {
            Lock lock = this._lockManager.getLock(Staging.class.getName(), groupId);
            throw new DuplicateLockException(lock);
        }
        this._lockManager.lock(userId, Staging.class.getName(), String.valueOf(groupId), StagingImpl.class.getName(), false, StagingConstants.LOCK_EXPIRATION_TIME);
    }

    public void populateLastPublishDateCounts(PortletDataContext portletDataContext, StagedModelType[] stagedModelTypes) throws PortalException {
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(portletDataContext.getScopeGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        for (StagedModelType stagedModelType : stagedModelTypes) {
            long modelAdditionCount = manifestSummary.getModelAdditionCount(stagedModelType);
            if (modelAdditionCount > -1L) continue;
            if (changesetCollection != null) {
                if (stagedModelType.getReferrerClassName() == null) {
                    modelAdditionCount = this._changesetEntryLocalService.getChangesetEntriesCount(changesetCollection.getChangesetCollectionId(), stagedModelType.getClassNameId());
                } else {
                    StagedModelRepository stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)stagedModelType.getClassName());
                    if (stagedModelRepository != null) {
                        List changesetEntries = this._changesetEntryLocalService.getChangesetEntries(changesetCollection.getChangesetCollectionId(), stagedModelType.getClassNameId());
                        modelAdditionCount = 0L;
                        for (ChangesetEntry changesetEntry : changesetEntries) {
                            TypedModel typedModel;
                            StagedModel stagedModel = stagedModelRepository.getStagedModel(changesetEntry.getClassPK());
                            if (!(stagedModel instanceof TypedModel) || !Objects.equals((typedModel = (TypedModel)stagedModel).getClassName(), stagedModelType.getReferrerClassName())) continue;
                            ++modelAdditionCount;
                        }
                    }
                }
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
            }
            long modelDeletionCount = this._exportImportHelper.getModelDeletionCount(portletDataContext, stagedModelType);
            manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
        }
    }

    public void populateLastPublishDateCounts(PortletDataContext portletDataContext, String[] classNames) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])classNames)) {
            return;
        }
        StagedModelType[] stagedModelTypes = new StagedModelType[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            stagedModelTypes[i] = new StagedModelType(classNames[i]);
        }
        this.populateLastPublishDateCounts(portletDataContext, stagedModelTypes);
    }

    public long publishLayout(long userId, long plid, long liveGroupId, boolean includeChildren) throws PortalException {
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Layout layout = this._layoutLocalService.getLayout(plid);
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        layouts.add(layout);
        List parentLayouts = this._exportImportHelper.getMissingParentLayouts(layout, liveGroupId);
        layouts.addAll(parentLayouts);
        if (includeChildren) {
            layouts.addAll(layout.getAllChildren());
        }
        return this.publishLayouts(userId, layout.getGroupId(), liveGroupId, layout.isPrivateLayout(), this._exportImportHelper.getLayoutIds(layouts), parameterMap);
    }

    public long publishLayouts(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        String backgroundTaskName = MapUtil.getString((Map)parameterMap, (String)"name", (String)exportImportConfiguration.getName());
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        HashMap taskContextMap = HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).put((Object)"privateLayout", (Object)privateLayout).build();
        BackgroundTask backgroundTask = this._backgroundTaskManager.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), backgroundTaskName, "com.liferay.exportimport.internal.background.task.LayoutStagingBackgroundTaskExecutor", (Map)taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long publishLayouts(long userId, long exportImportConfigurationId) throws PortalException {
        return this.publishLayouts(userId, this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap) throws PortalException {
        return this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, layoutIds, null, parameterMap);
    }

    @Deprecated
    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        return this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
    }

    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, String name, Map<String, String[]> parameterMap) throws PortalException {
        parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
        Map publishLayoutLocalSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutLocalSettingsMap(this._userLocalService.getUser(userId), sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, name, 1, publishLayoutLocalSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, 1, publishLayoutLocalSettingsMap);
        return this.publishLayouts(userId, exportImportConfiguration);
    }

    @Deprecated
    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        return this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, this._exportImportHelper.getLayoutIds(layoutIdMap, targetGroupId), parameterMap, startDate, endDate);
    }

    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException {
        List sourceGroupLayouts = this._layoutLocalService.getLayouts(sourceGroupId, privateLayout);
        return this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, this._exportImportHelper.getLayoutIds(sourceGroupLayouts), parameterMap);
    }

    @Deprecated
    public long publishLayouts(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        return this.publishLayouts(userId, sourceGroupId, targetGroupId, privateLayout, parameterMap);
    }

    public long publishPortlet(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        HashMap taskContextMap = HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).build();
        String backgroundTaskExecutor = "com.liferay.exportimport.internal.background.task.PortletStagingBackgroundTaskExecutor";
        if (exportImportConfiguration.getType() == 9) {
            backgroundTaskExecutor = "com.liferay.exportimport.internal.background.task.PortletRemoteStagingBackgroundTaskExecutor";
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            HashMap parameterMap = (HashMap)settingsMap.get("parameterMap");
            long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
            Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
            UnicodeProperties typeSettingsProperties = sourceGroup.getTypeSettingsProperties();
            String remoteAddress = MapUtil.getString((Map)parameterMap, (String)"remoteAddress", (String)typeSettingsProperties.getProperty("remoteAddress"));
            int remotePort = MapUtil.getInteger((Map)parameterMap, (String)"remotePort", (int)GetterUtil.getInteger((String)typeSettingsProperties.getProperty("remotePort")));
            String remotePathContext = MapUtil.getString((Map)parameterMap, (String)"remotePathContext", (String)typeSettingsProperties.getProperty("remotePathContext"));
            boolean secureConnection = MapUtil.getBoolean((Map)parameterMap, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("secureConnection")));
            this._groupLocalService.validateRemote(sourceGroupId, remoteAddress, remotePort, remotePathContext, secureConnection, sourceGroup.getRemoteLiveGroupId());
            String remoteURL = this._stagingURLHelper.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            User user = permissionChecker.getUser();
            HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
            taskContextMap.put("httpPrincipal", httpPrincipal);
        }
        BackgroundTask backgroundTask = this._backgroundTaskManager.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), exportImportConfiguration.getName(), backgroundTaskExecutor, (Map)taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long publishPortlet(long userId, long exportImportConfigurationId) throws PortalException {
        return this.publishPortlet(userId, this._exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId));
    }

    public long publishPortlet(long userId, long sourceGroupId, long targetGroupId, long sourcePlid, long targetPlid, String portletId, Map<String, String[]> parameterMap) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Map publishPortletSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishPortletSettingsMap(userId, sourceGroupId, sourcePlid, targetGroupId, targetPlid, portletId, parameterMap, user.getLocale(), user.getTimeZone());
        Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
        int type = 8;
        if (sourceGroup.isStagedRemotely()) {
            type = 9;
        }
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, type, publishPortletSettingsMap);
        return this.publishPortlet(userId, exportImportConfiguration);
    }

    public long publishToLive(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group targetGroup = this.getLiveGroup(groupId);
        if (!targetGroup.isStaged()) {
            return 0L;
        }
        if (targetGroup.isStagedRemotely()) {
            return this.publishToRemote(portletRequest);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        Map publishLayoutLocalSettingsMap = null;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            publishLayoutLocalSettingsMap = exportImportConfiguration.getSettingsMap();
            Map parameterMap = (Map)publishLayoutLocalSettingsMap.get("parameterMap");
            parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
            if (!Validator.isBlank((String)name)) {
                parameterMap.put("name", new String[]{name});
            }
        }
        if (publishLayoutLocalSettingsMap == null) {
            Group sourceGroup = targetGroup.getStagingGroup();
            long sourceGroupId = sourceGroup.getGroupId();
            long targetGroupId = targetGroup.getGroupId();
            boolean privateLayout = this.getPrivateLayout(portletRequest);
            long[] layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
            Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
            parameterMap.put("PERFORM_DIRECT_BINARY_IMPORT", new String[]{Boolean.TRUE.toString()});
            publishLayoutLocalSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutLocalSettingsMap(user, sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap);
        }
        exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 1, publishLayoutLocalSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 1, publishLayoutLocalSettingsMap);
        return this.publishLayouts(user.getUserId(), exportImportConfiguration);
    }

    public long publishToLive(PortletRequest portletRequest, Portlet portlet) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = this._portal.getScopeGroupId(this._portal.getHttpServletRequest(portletRequest), portlet.getPortletId());
        long plid = ParamUtil.getLong((PortletRequest)portletRequest, (String)"plid");
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        return this.publishPortlet(themeDisplay.getUserId(), scopeGroupId, plid, portlet.getPortletId(), parameterMap, false);
    }

    public long publishToRemote(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group group = this._groupLocalService.getGroup(groupId);
        UnicodeProperties groupTypeSettingsProperties = group.getTypeSettingsProperties();
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsProperties.getProperty("remoteGroupId")));
        Map publishLayoutRemoteSettingsMap = null;
        String remoteAddress = null;
        int remotePort = 0;
        String remotePathContext = null;
        boolean secureConnection = false;
        boolean remotePrivateLayout = false;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            publishLayoutRemoteSettingsMap = exportImportConfiguration.getSettingsMap();
            remoteAddress = MapUtil.getString((Map)publishLayoutRemoteSettingsMap, (String)"remoteAddress");
            remotePort = MapUtil.getInteger((Map)publishLayoutRemoteSettingsMap, (String)"remotePort");
            remotePathContext = MapUtil.getString((Map)publishLayoutRemoteSettingsMap, (String)"remotePathContext");
            secureConnection = MapUtil.getBoolean((Map)publishLayoutRemoteSettingsMap, (String)"secureConnection");
            remoteGroupId = MapUtil.getLong((Map)publishLayoutRemoteSettingsMap, (String)"targetGroupId");
            remotePrivateLayout = MapUtil.getBoolean((Map)publishLayoutRemoteSettingsMap, (String)"remotePrivateLayout");
            if (!Validator.isBlank((String)name)) {
                Map parameterMap = (Map)publishLayoutRemoteSettingsMap.get("parameterMap");
                parameterMap.put("name", new String[]{name});
            }
        }
        if (publishLayoutRemoteSettingsMap == null) {
            Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
            remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsProperties.getProperty("remoteAddress"));
            remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsProperties.getProperty("remotePort")));
            remotePathContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"remotePathContext", (String)groupTypeSettingsProperties.getProperty("remotePathContext"));
            secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsProperties.getProperty("secureConnection")));
            remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
            publishLayoutRemoteSettingsMap = this._exportImportConfigurationSettingsMapFactory.buildPublishLayoutRemoteSettingsMap(user.getUserId(), groupId, this.getPrivateLayout(portletRequest), this._exportImportHelper.getLayoutIdMap(portletRequest), parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, user.getLocale(), user.getTimeZone());
        }
        remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
        this._groupLocalService.validateRemote(groupId, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        exportImportConfiguration = null;
        exportImportConfiguration = Validator.isNotNull((String)name) ? this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), name, 2, publishLayoutRemoteSettingsMap) : this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 2, publishLayoutRemoteSettingsMap);
        return this.doCopyRemoteLayouts(exportImportConfiguration, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout);
    }

    public <T extends BaseModel> void removeModelFromChangesetCollection(T model) throws PortalException {
        if (!(model instanceof StagedGroupedModel)) {
            return;
        }
        StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)model;
        ChangesetCollection changesetCollection = this._changesetCollectionLocalService.fetchChangesetCollection(stagedGroupedModel.getGroupId(), "RANGE_FROM_LAST_PUBLISH_DATE_CHANGESET_NAME");
        if (changesetCollection == null) {
            return;
        }
        long classNameId = this._classNameLocalService.getClassNameId(stagedGroupedModel.getModelClassName());
        long classPK = (Long)stagedGroupedModel.getPrimaryKeyObj();
        ChangesetEntry changesetEntry = this._changesetEntryLocalService.fetchChangesetEntry(changesetCollection.getChangesetCollectionId(), classNameId, classPK);
        if (changesetEntry == null) {
            return;
        }
        this._changesetEntryLocalService.deleteChangesetEntry(changesetEntry.getChangesetEntryId());
    }

    public void scheduleCopyFromLive(PortletRequest portletRequest) throws PortalException {
        long targetGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group targetGroup = this._groupLocalService.getGroup(targetGroupId);
        long sourceGroupId = targetGroup.getLiveGroupId();
        long[] layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
        Map parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        ScheduleInformation scheduleInformation = this.getScheduleInformation(portletRequest, targetGroupId, false);
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        this._layoutService.schedulePublishToLive(sourceGroupId, targetGroupId, this.getPrivateLayout(portletRequest), layoutIds, parameterMap, scheduleInformation.getGroupName(), scheduleInformation.getCronText(), scheduleInformation.getStartDate(), scheduleInformation.getSchedulerEndDate(), name);
    }

    public void schedulePublishToLive(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        long sourceGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group sourceGroup = this._groupLocalService.getGroup(sourceGroupId);
        long targetGroupId = sourceGroup.getLiveGroupId();
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        Map parameterMap = null;
        boolean privateLayout = false;
        long[] layoutIds = null;
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            parameterMap = (Map)settingsMap.get("parameterMap");
            privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
            parameterMap.put("timeZoneId", ParamUtil.getParameterValues((PortletRequest)portletRequest, (String)"timeZoneId"));
        }
        if (parameterMap == null) {
            privateLayout = this.getPrivateLayout(portletRequest);
            layoutIds = this._exportImportHelper.getLayoutIds(portletRequest, targetGroupId);
            parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
        }
        ScheduleInformation scheduleInformation = this.getScheduleInformation(portletRequest, targetGroupId, false);
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (!Validator.isBlank((String)name)) {
            parameterMap.put("name", new String[]{name});
        }
        this._layoutService.schedulePublishToLive(sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, scheduleInformation.getGroupName(), scheduleInformation.getCronText(), scheduleInformation.getStartDate(), scheduleInformation.getSchedulerEndDate(), name);
    }

    public void schedulePublishToRemote(PortletRequest portletRequest) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        Group group = this._groupLocalService.getGroup(groupId);
        UnicodeProperties groupTypeSettingsProperties = group.getTypeSettingsProperties();
        boolean privateLayout = false;
        Map layoutIdMap = null;
        Map parameterMap = null;
        String remoteAddress = null;
        int remotePort = 0;
        String remotePathContext = null;
        boolean secureConnection = false;
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsProperties.getProperty("remoteGroupId")));
        boolean remotePrivateLayout = false;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"exportImportConfigurationId");
        if (exportImportConfigurationId > 0L && (exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId)) != null) {
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            layoutIdMap = (Map)settingsMap.get("layoutIdMap");
            parameterMap = (Map)settingsMap.get("parameterMap");
            remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
            remotePort = MapUtil.getInteger((Map)settingsMap, (String)"remotePort");
            remotePathContext = MapUtil.getString((Map)settingsMap, (String)"remotePathContext");
            secureConnection = MapUtil.getBoolean((Map)settingsMap, (String)"secureConnection");
            remoteGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
            remotePrivateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"remotePrivateLayout");
            parameterMap.put("timeZoneId", ParamUtil.getParameterValues((PortletRequest)portletRequest, (String)"timeZoneId"));
        }
        if (parameterMap == null) {
            privateLayout = this.getPrivateLayout(portletRequest);
            layoutIdMap = this._exportImportHelper.getLayoutIdMap(portletRequest);
            parameterMap = this._exportImportConfigurationParameterMapFactory.buildParameterMap(portletRequest);
            remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsProperties.getProperty("remoteAddress"));
            remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsProperties.getProperty("remotePort")));
            remotePathContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"remotePathContext", (String)groupTypeSettingsProperties.getProperty("remotePathContext"));
            secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsProperties.getProperty("secureConnection")));
            remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
        }
        remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
        this._groupLocalService.validateRemote(groupId, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        ScheduleInformation scheduleInformation = this.getScheduleInformation(portletRequest, groupId, true);
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        if (!Validator.isBlank((String)name)) {
            parameterMap.put("name", new String[]{name});
        }
        this._layoutService.schedulePublishToRemote(groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, null, null, scheduleInformation.getGroupName(), scheduleInformation.getCronText(), scheduleInformation.getStartDate(), scheduleInformation.getSchedulerEndDate(), name);
    }

    public void setRecentLayoutBranchId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid, long layoutBranchId) throws PortalException {
        this.setRecentLayoutBranchId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutBranchId(User user, long layoutSetBranchId, long plid, long layoutBranchId) throws PortalException {
        this.setRecentLayoutBranchId(user.getUserId(), layoutSetBranchId, plid, layoutBranchId);
    }

    public void setRecentLayoutRevisionId(HttpServletRequest httpServletRequest, long layoutSetBranchId, long plid, long layoutRevisionId) throws PortalException {
        this.setRecentLayoutRevisionId(this._portal.getUserId(httpServletRequest), layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutRevisionId(User user, long layoutSetBranchId, long plid, long layoutRevisionId) throws PortalException {
        this.setRecentLayoutRevisionId(user.getUserId(), layoutSetBranchId, plid, layoutRevisionId);
    }

    public void setRecentLayoutSetBranchId(HttpServletRequest httpServletRequest, long layoutSetId, long layoutSetBranchId) throws PortalException {
        this.setRecentLayoutSetBranchId(this._portal.getUserId(httpServletRequest), layoutSetId, layoutSetBranchId);
    }

    public void setRecentLayoutSetBranchId(User user, long layoutSetId, long layoutSetBranchId) throws PortalException {
        this.setRecentLayoutSetBranchId(user.getUserId(), layoutSetId, layoutSetBranchId);
    }

    public String stripProtocolFromRemoteAddress(String remoteAddress) {
        if (remoteAddress.startsWith("http://")) {
            remoteAddress = remoteAddress.substring("http://".length());
        } else if (remoteAddress.startsWith("https://")) {
            remoteAddress = remoteAddress.substring("https://".length());
        }
        return remoteAddress;
    }

    public void transferFileToRemoteLive(File file, long stagingRequestId, HttpPrincipal httpPrincipal) throws Exception {
        byte[] bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
        int i = 0;
        int j = 0;
        String numberString = String.valueOf((int)(file.length() / (long)bytes.length));
        String numberFormat = String.format("%%0%dd", numberString.length() + 1);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            while ((i = fileInputStream.read(bytes)) >= 0) {
                String fileName = file.getName() + String.format(numberFormat, j++);
                if (i < PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE) {
                    byte[] tempBytes = new byte[i];
                    System.arraycopy(bytes, 0, tempBytes, 0, i);
                    StagingServiceHttp.updateStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (String)fileName, (byte[])tempBytes);
                } else {
                    StagingServiceHttp.updateStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (String)fileName, (byte[])bytes);
                }
                bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
            }
        }
    }

    @Deprecated
    public void unlockGroup(long groupId) {
        this._lockManager.unlock(Staging.class.getName(), groupId);
    }

    public void unscheduleCopyFromLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", stagingGroupId);
        this._layoutService.unschedulePublishToLive(stagingGroupId, jobName, groupName);
    }

    public void unschedulePublishToLive(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        Group stagingGroup = this._groupLocalService.getGroup(stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_local_publisher", liveGroupId);
        this._layoutService.unschedulePublishToLive(liveGroupId, jobName, groupName);
    }

    public void unschedulePublishToRemote(PortletRequest portletRequest) throws PortalException {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)portletRequest, (String)"jobName");
        String groupName = this.getSchedulerGroupName("liferay/layouts_remote_publisher", stagingGroupId);
        this._layoutService.unschedulePublishToRemote(stagingGroupId, jobName, groupName);
    }

    public void updateLastImportSettings(Element layoutElement, Layout layout, PortletDataContext portletDataContext) {
        Map parameterMap = portletDataContext.getParameterMap();
        String cmd = MapUtil.getString((Map)parameterMap, (String)"cmd");
        if (!cmd.equals("publish_to_live") && !cmd.equals("schedule_publish_to_live")) {
            return;
        }
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("last-import-date", String.valueOf(System.currentTimeMillis()));
        String layoutRevisionId = GetterUtil.getString((String)layoutElement.attributeValue("layout-revision-id"));
        typeSettingsProperties.setProperty("last-import-layout-revision-id", layoutRevisionId);
        String layoutSetBranchId = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchId");
        typeSettingsProperties.setProperty("last-import-layout-set-branch-id", layoutSetBranchId);
        String layoutSetBranchName = MapUtil.getString((Map)parameterMap, (String)"layoutSetBranchName");
        typeSettingsProperties.setProperty("last-import-layout-set-branch-name", layoutSetBranchName);
        String lastImportUserName = MapUtil.getString((Map)parameterMap, (String)"lastImportUserName");
        typeSettingsProperties.setProperty("last-import-user-name", lastImportUserName);
        String lastImportUserUuid = MapUtil.getString((Map)parameterMap, (String)"lastImportUserUuid");
        typeSettingsProperties.setProperty("last-import-user-uuid", lastImportUserUuid);
        String layoutBranchId = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-id"));
        typeSettingsProperties.setProperty("last-import-layout-branch-id", layoutBranchId);
        String layoutBranchName = GetterUtil.getString((String)layoutElement.attributeValue("layout-branch-name"));
        typeSettingsProperties.setProperty("last-import-layout-branch-name", layoutBranchName);
        layout.setTypeSettingsProperties(typeSettingsProperties);
    }

    @Deprecated
    public void updateLastPublishDate(long groupId, boolean privateLayout, Date lastPublishDate) throws PortalException {
        ExportImportDateUtil.updateLastPublishDate((long)groupId, (boolean)privateLayout, null, (Date)lastPublishDate);
    }

    @Deprecated
    public void updateLastPublishDate(String portletId, PortletPreferences portletPreferences, Date lastPublishDate) {
        ExportImportDateUtil.updateLastPublishDate((String)portletId, (PortletPreferences)portletPreferences, null, (Date)lastPublishDate);
    }

    @Deprecated
    public void updateStaging(PortletRequest portletRequest, Group liveGroup) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long userId = permissionChecker.getUserId();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)liveGroup, (String)"MANAGE_STAGING")) {
            return;
        }
        int stagingType = this.getStagingType(portletRequest, liveGroup);
        boolean branchingPublic = this.getBoolean(portletRequest, liveGroup, "branchingPublic");
        boolean branchingPrivate = this.getBoolean(portletRequest, liveGroup, "branchingPrivate");
        boolean forceDisable = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"forceDisable");
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setAttribute("forceDisable", (Serializable)Boolean.valueOf(forceDisable));
        if (stagingType == 0) {
            if (liveGroup.hasStagingGroup() || liveGroup.isStagedRemotely()) {
                this._stagingLocalService.disableStaging(portletRequest, liveGroup, serviceContext);
            }
        } else if (stagingType == 1) {
            this._stagingLocalService.enableLocalStaging(userId, liveGroup, branchingPublic, branchingPrivate, serviceContext);
        } else if (stagingType == 2) {
            String remoteAddress = this.getString(portletRequest, liveGroup, "remoteAddress");
            remoteAddress = this.stripProtocolFromRemoteAddress(remoteAddress);
            int remotePort = this.getInteger(portletRequest, liveGroup, "remotePort");
            String remotePathContext = this.getString(portletRequest, liveGroup, "remotePathContext");
            boolean secureConnection = this.getBoolean(portletRequest, liveGroup, "secureConnection");
            long remoteGroupId = this.getLong(portletRequest, liveGroup, "remoteGroupId");
            this._stagingLocalService.enableRemoteStaging(userId, liveGroup, branchingPublic, branchingPrivate, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, serviceContext);
        }
    }

    @Deprecated
    public void validateRemote(long groupId, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId) throws PortalException {
        this._groupLocalService.validateRemote(groupId, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
    }

    @Deprecated
    public void validateRemote(String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId) {
    }

    public void validateRemoteGroupIsSame(long groupId, long remoteGroupId, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection) throws PortalException {
        if (remoteGroupId <= 0L) {
            RemoteOptionsException roe = new RemoteOptionsException(3);
            roe.setRemoteGroupId(remoteGroupId);
            throw roe;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        String remoteURL = this._stagingURLHelper.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            GroupServiceHttp.checkRemoteStagingGroup((HttpPrincipal)httpPrincipal, (long)remoteGroupId);
            Group group = this._groupLocalService.getGroup(groupId);
            Group remoteGroup = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)remoteGroupId);
            if (group.getGroupId() == remoteGroup.getGroupId() && Objects.equals(group.getUuid(), remoteGroup.getUuid())) {
                String validationTimestamp = String.valueOf(System.currentTimeMillis());
                this._setGroupTypeSetting(groupId, "validationTimestamp", validationTimestamp);
                remoteGroup = GroupServiceHttp.getGroup((HttpPrincipal)httpPrincipal, (long)remoteGroupId);
                UnicodeProperties remoteTypeSettingsProperties = remoteGroup.getTypeSettingsProperties();
                String remoteValidationTimestamp = GetterUtil.getString((String)remoteTypeSettingsProperties.getProperty("validationTimestamp"));
                if (validationTimestamp.equals(remoteValidationTimestamp)) {
                    RemoteExportException ree = new RemoteExportException(4);
                    ree.setGroupId(remoteGroupId);
                    throw ree;
                }
            }
        }
        catch (NoSuchGroupException nsge) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsge, (Throwable)nsge);
            }
            RemoteExportException ree = new RemoteExportException(3);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            RemoteExportException ree = new RemoteExportException(5);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (RemoteAuthException rae) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)rae, (Throwable)rae);
            }
            rae.setURL(remoteURL);
            throw rae;
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)se, (Throwable)se);
            }
            RemoteExportException ree = new RemoteExportException(1, se.getMessage());
            ree.setURL(remoteURL);
            throw ree;
        }
        finally {
            this._setGroupTypeSetting(groupId, "validationTimestamp", null);
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected long doCopyRemoteLayouts(ExportImportConfiguration exportImportConfiguration, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, boolean remotePrivateLayout) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        String backgroundTaskName = MapUtil.getString((Map)parameterMap, (String)"name", (String)exportImportConfiguration.getName());
        String remoteURL = this._stagingURLHelper.buildRemoteURL(remoteAddress, remotePort, remotePathContext, secureConnection);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        HttpPrincipal httpPrincipal = new HttpPrincipal(remoteURL, user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
        HashMap taskContextMap = HashMapBuilder.put((Object)"exportImportConfigurationId", (Object)exportImportConfiguration.getExportImportConfigurationId()).put((Object)"httpPrincipal", (Object)httpPrincipal).put((Object)"privateLayout", (Object)remotePrivateLayout).build();
        BackgroundTask backgroundTask = this._backgroundTaskManager.addBackgroundTask(user.getUserId(), exportImportConfiguration.getGroupId(), backgroundTaskName, "com.liferay.exportimport.internal.background.task.LayoutRemoteStagingBackgroundTaskExecutor", (Map)taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    protected boolean getBoolean(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getBoolean((PortletRequest)portletRequest, (String)param, (boolean)GetterUtil.getBoolean((String)group.getTypeSettingsProperty(param)));
    }

    protected int getInteger(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getInteger((PortletRequest)portletRequest, (String)param, (int)GetterUtil.getInteger((String)group.getTypeSettingsProperty(param)));
    }

    protected long getLong(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getLong((PortletRequest)portletRequest, (String)param, (long)GetterUtil.getLong((String)group.getTypeSettingsProperty(param)));
    }

    protected boolean getPrivateLayout(PortletRequest portletRequest) {
        String tabs1 = ParamUtil.getString((PortletRequest)portletRequest, (String)"tabs1");
        if (Validator.isNotNull((String)tabs1)) {
            return !tabs1.equals("public-pages");
        }
        return ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"privateLayout", (boolean)true);
    }

    protected long getRecentLayoutBranchId(long userId, long layoutSetBranchId, long plid) throws PortalException {
        RecentLayoutBranch recentLayoutBranch = this._recentLayoutBranchLocalService.fetchRecentLayoutBranch(userId, layoutSetBranchId, plid);
        if (recentLayoutBranch != null) {
            return recentLayoutBranch.getLayoutBranchId();
        }
        try {
            LayoutBranch masterLayoutBranch = this._layoutBranchLocalService.getMasterLayoutBranch(layoutSetBranchId, plid);
            return masterLayoutBranch.getLayoutBranchId();
        }
        catch (NoSuchLayoutBranchException nslbe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nslbe, (Throwable)nslbe);
            }
            return 0L;
        }
    }

    protected long getRecentLayoutRevisionId(long userId, long layoutSetBranchId, long plid) throws PortalException {
        block11: {
            long layoutBranchId;
            block10: {
                if (ExportImportThreadLocal.isLayoutStagingInProcess()) {
                    List layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, plid, true);
                    if (ListUtil.isNotEmpty((List)layoutRevisions)) {
                        LayoutRevision layoutRevision = (LayoutRevision)layoutRevisions.get(0);
                        return layoutRevision.getLayoutRevisionId();
                    }
                    return 0L;
                }
                RecentLayoutRevision recentLayoutRevision = this._recentLayoutRevisionLocalService.fetchRecentLayoutRevision(userId, layoutSetBranchId, plid);
                if (recentLayoutRevision != null) {
                    return recentLayoutRevision.getLayoutRevisionId();
                }
                layoutBranchId = this.getRecentLayoutBranchId(userId, layoutSetBranchId, plid);
                LayoutBranch layoutBranch = this._layoutBranchLocalService.fetchLayoutBranch(layoutBranchId);
                if (layoutBranch == null) {
                    try {
                        layoutBranch = this._layoutBranchLocalService.getMasterLayoutBranch(layoutSetBranchId, plid);
                        layoutBranchId = layoutBranch.getLayoutBranchId();
                    }
                    catch (NoSuchLayoutBranchException nslbe) {
                        if (!_log.isDebugEnabled()) break block10;
                        _log.debug((Object)nslbe, (Throwable)nslbe);
                    }
                }
            }
            if (layoutBranchId > 0L) {
                try {
                    LayoutRevision layoutRevision = this._layoutRevisionLocalService.getLayoutRevision(layoutSetBranchId, layoutBranchId, plid);
                    if (layoutRevision != null) {
                        return layoutRevision.getLayoutRevisionId();
                    }
                }
                catch (NoSuchLayoutRevisionException nslre) {
                    if (!_log.isDebugEnabled()) break block11;
                    _log.debug((Object)nslre, (Throwable)nslre);
                }
            }
        }
        return 0L;
    }

    protected ScheduleInformation getScheduleInformation(PortletRequest portletRequest, long targetGroupId, boolean remote) {
        ScheduleInformation scheduleInformation = new ScheduleInformation();
        int recurrenceType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"recurrenceType");
        Calendar startCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerStartDate", (boolean)true);
        String cronText = SchedulerEngineHelperUtil.getCronText((PortletRequest)portletRequest, (Calendar)startCalendar, (boolean)false, (int)recurrenceType);
        scheduleInformation.setCronText(cronText);
        String destinationName = "liferay/layouts_local_publisher";
        if (remote) {
            destinationName = "liferay/layouts_remote_publisher";
        }
        String groupName = this.getSchedulerGroupName(destinationName, targetGroupId);
        scheduleInformation.setGroupName(groupName);
        Date schedulerEndDate = null;
        int endDateType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"endDateType");
        if (endDateType == 1) {
            Calendar endCalendar = ExportImportDateUtil.getCalendar((PortletRequest)portletRequest, (String)"schedulerEndDate", (boolean)true);
            schedulerEndDate = endCalendar.getTime();
        }
        scheduleInformation.setSchedulerEndDate(schedulerEndDate);
        scheduleInformation.setStartCalendar(startCalendar);
        return scheduleInformation;
    }

    protected int getStagingType(PortletRequest portletRequest, Group liveGroup) {
        String stagingType = portletRequest.getParameter("stagingType");
        if (stagingType != null) {
            return GetterUtil.getInteger((String)stagingType);
        }
        if (liveGroup.isStagedRemotely()) {
            return 2;
        }
        if (liveGroup.hasStagingGroup()) {
            return 1;
        }
        return 0;
    }

    protected String getString(PortletRequest portletRequest, Group group, String param) {
        return ParamUtil.getString((PortletRequest)portletRequest, (String)param, (String)GetterUtil.getString((String)group.getTypeSettingsProperty(param)));
    }

    protected boolean isLayoutRevisionIncomplete(long plid, LayoutRevision layoutRevision, long layoutSetBranchId) {
        List layoutRevisions;
        if (layoutRevision == null && !(layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, plid, true)).isEmpty()) {
            return false;
        }
        layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, plid, false);
        if (!layoutRevisions.isEmpty()) {
            layoutRevision = (LayoutRevision)layoutRevisions.get(0);
        }
        return layoutRevision == null || layoutRevision.getStatus() == 6;
    }

    protected long publishPortlet(long userId, long scopeGroupId, long plid, String portletId, Map<String, String[]> parameterMap, boolean copyFromLive) throws PortalException {
        Layout sourceLayout = this._layoutLocalService.getLayout(plid);
        Group scopeGroup = sourceLayout.getScopeGroup();
        Group liveGroup = null;
        Group stagingGroup = null;
        long targetGroupId = 0L;
        long targetLayoutPlid = 0L;
        if (sourceLayout.isTypeControlPanel()) {
            stagingGroup = this._groupLocalService.fetchGroup(scopeGroupId);
            if (stagingGroup.isStagedRemotely()) {
                targetGroupId = stagingGroup.getRemoteLiveGroupId();
                User user = this._userLocalService.getUser(userId);
                HttpPrincipal httpPrincipal = new HttpPrincipal(this._stagingURLHelper.buildRemoteURL(stagingGroup.getTypeSettingsProperties()), user.getLogin(), user.getPassword(), user.isPasswordEncrypted());
                targetLayoutPlid = LayoutServiceHttp.getControlPanelLayoutPlid((HttpPrincipal)httpPrincipal);
            } else {
                liveGroup = stagingGroup.getLiveGroup();
                targetGroupId = liveGroup.getGroupId();
                targetLayoutPlid = sourceLayout.getPlid();
            }
        } else if (sourceLayout.hasScopeGroup() && scopeGroup.getGroupId() == scopeGroupId) {
            stagingGroup = scopeGroup;
            liveGroup = stagingGroup.getLiveGroup();
            targetGroupId = liveGroup.getGroupId();
            Layout layout = this._layoutLocalService.getLayout(liveGroup.getClassPK());
            targetLayoutPlid = layout.getPlid();
        } else {
            stagingGroup = sourceLayout.getGroup();
            if (stagingGroup.isStagedRemotely()) {
                targetGroupId = stagingGroup.getRemoteLiveGroupId();
                targetLayoutPlid = this.getRemoteLayoutPlid(userId, stagingGroup.getGroupId(), sourceLayout.getPlid());
            } else {
                liveGroup = stagingGroup.getLiveGroup();
                targetGroupId = liveGroup.getGroupId();
                Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(sourceLayout.getUuid(), liveGroup.getGroupId(), sourceLayout.isPrivateLayout());
                targetLayoutPlid = layout.getPlid();
            }
        }
        if (copyFromLive) {
            return this.publishPortlet(userId, liveGroup.getGroupId(), stagingGroup.getGroupId(), targetLayoutPlid, sourceLayout.getPlid(), portletId, parameterMap);
        }
        return this.publishPortlet(userId, stagingGroup.getGroupId(), targetGroupId, sourceLayout.getPlid(), targetLayoutPlid, portletId, parameterMap);
    }

    protected void setRecentLayoutBranchId(long userId, long layoutSetBranchId, long plid, long layoutBranchId) throws PortalException {
        LayoutBranch layoutBranch = this._layoutBranchLocalService.fetchLayoutBranch(layoutBranchId);
        if (layoutBranch == null) {
            return;
        }
        RecentLayoutBranch recentLayoutBranch = this._recentLayoutBranchLocalService.fetchRecentLayoutBranch(userId, layoutSetBranchId, plid);
        if (layoutBranch.isMaster()) {
            if (recentLayoutBranch != null) {
                this._recentLayoutBranchLocalService.deleteRecentLayoutBranch(recentLayoutBranch);
            }
        } else {
            if (recentLayoutBranch == null) {
                recentLayoutBranch = this._recentLayoutBranchLocalService.addRecentLayoutBranch(userId, layoutBranchId, layoutSetBranchId, plid);
            }
            recentLayoutBranch.setLayoutBranchId(layoutBranchId);
            this._recentLayoutBranchLocalService.updateRecentLayoutBranch(recentLayoutBranch);
        }
        ProxiedLayoutsThreadLocal.clearProxiedLayouts();
    }

    protected void setRecentLayoutRevisionId(long userId, long layoutSetBranchId, long plid, long layoutRevisionId) throws PortalException {
        long layoutBranchId;
        block6: {
            if (layoutRevisionId <= 0L) {
                return;
            }
            layoutBranchId = 0L;
            try {
                LayoutRevision layoutRevision = this._layoutRevisionLocalService.getLayoutRevision(layoutRevisionId);
                layoutBranchId = layoutRevision.getLayoutBranchId();
                LayoutRevision lastLayoutRevision = this._layoutRevisionLocalService.getLayoutRevision(layoutSetBranchId, layoutBranchId, plid);
                if (lastLayoutRevision.getLayoutRevisionId() == layoutRevisionId) {
                    this.deleteRecentLayoutRevisionId(userId, layoutSetBranchId, plid);
                } else {
                    RecentLayoutRevision recentLayoutRevision = this._recentLayoutRevisionLocalService.fetchRecentLayoutRevision(userId, layoutSetBranchId, plid);
                    if (recentLayoutRevision == null) {
                        recentLayoutRevision = this._recentLayoutRevisionLocalService.addRecentLayoutRevision(userId, layoutRevisionId, layoutSetBranchId, plid);
                    }
                    recentLayoutRevision.setLayoutRevisionId(layoutRevisionId);
                    this._recentLayoutRevisionLocalService.updateRecentLayoutRevision(recentLayoutRevision);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to set recent layout revision ID", "with layout set branch ", layoutSetBranchId, " and PLID ", plid, " and layout branch ", layoutBranchId}), (Throwable)pe);
            }
        }
        this.setRecentLayoutBranchId(userId, layoutSetBranchId, plid, layoutBranchId);
    }

    protected void setRecentLayoutSetBranchId(long userId, long layoutSetId, long layoutSetBranchId) throws PortalException {
        LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
        if (layoutSetBranch == null) {
            return;
        }
        RecentLayoutSetBranch recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.fetchRecentLayoutSetBranch(userId, layoutSetId);
        if (layoutSetBranch.isMaster()) {
            if (recentLayoutSetBranch != null) {
                this._recentLayoutSetBranchLocalService.deleteRecentLayoutSetBranch(recentLayoutSetBranch);
            }
        } else {
            if (recentLayoutSetBranch == null) {
                recentLayoutSetBranch = this._recentLayoutSetBranchLocalService.addRecentLayoutSetBranch(userId, layoutSetBranchId, layoutSetId);
            }
            recentLayoutSetBranch.setLayoutSetBranchId(layoutSetBranchId);
            this._recentLayoutSetBranchLocalService.updateRecentLayoutSetBranch(recentLayoutSetBranch);
        }
        ProxiedLayoutsThreadLocal.clearProxiedLayouts();
    }

    private void _setGroupTypeSetting(long groupId, String key, String value) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return;
        }
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        if (Validator.isNotNull((String)value)) {
            typeSettingsProperties.setProperty(key, value);
        } else {
            typeSettingsProperties.remove((Object)key);
        }
        group.setTypeSettingsProperties(typeSettingsProperties);
        group.setTypeSettings(typeSettingsProperties.toString());
        this._groupLocalService.updateGroup(group);
    }

    private class ScheduleInformation {
        private String _cronText;
        private String _groupName;
        private Date _schedulerEndDate;
        private Calendar _startCalendar;

        public String getCronText() {
            return this._cronText;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public Date getSchedulerEndDate() {
            return this._schedulerEndDate;
        }

        public Calendar getStartCalendar() {
            return this._startCalendar;
        }

        public Date getStartDate() {
            return this._startCalendar.getTime();
        }

        public void setCronText(String cronText) {
            this._cronText = cronText;
        }

        public void setGroupName(String groupName) {
            this._groupName = groupName;
        }

        public void setSchedulerEndDate(Date schedulerEndDate) {
            this._schedulerEndDate = schedulerEndDate;
        }

        public void setStartCalendar(Calendar startCalendar) {
            this._startCalendar = startCalendar;
        }
    }
}

