/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.staging;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.staging.LayoutStaging;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutStaging.class})
public class LayoutStagingImpl
implements LayoutStaging {
    private static final Log _log = LogFactoryUtil.getLog(LayoutStagingImpl.class);
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;

    public LayoutRevision getLayoutRevision(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = this.getLayoutStagingHandler(layout);
        if (layoutStagingHandler == null) {
            return null;
        }
        return layoutStagingHandler.getLayoutRevision();
    }

    public LayoutSetBranch getLayoutSetBranch(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = this.getLayoutSetStagingHandler(layoutSet);
        if (layoutSetStagingHandler == null) {
            return null;
        }
        return layoutSetStagingHandler.getLayoutSetBranch();
    }

    public LayoutSetStagingHandler getLayoutSetStagingHandler(LayoutSet layoutSet) {
        if (!ProxyUtil.isProxyClass(layoutSet.getClass())) {
            return null;
        }
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)layoutSet);
        if (!(invocationHandler instanceof LayoutSetStagingHandler)) {
            return null;
        }
        return (LayoutSetStagingHandler)invocationHandler;
    }

    public LayoutStagingHandler getLayoutStagingHandler(Layout layout) {
        if (layout == null) {
            return null;
        }
        if (!ProxyUtil.isProxyClass(layout.getClass())) {
            return null;
        }
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)layout);
        if (!(invocationHandler instanceof LayoutStagingHandler)) {
            return null;
        }
        return (LayoutStagingHandler)invocationHandler;
    }

    public boolean isBranchingLayout(Layout layout) {
        if (layout == null || layout.isSystem()) {
            return false;
        }
        return this.isBranchingLayoutSet(layout.getGroup(), layout.isPrivateLayout());
    }

    public boolean isBranchingLayoutSet(Group group, boolean privateLayout) {
        UnicodeProperties typeSettingsProperties;
        boolean isStagingGroup = false;
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            isStagingGroup = true;
            group = group.getLiveGroup();
        }
        if ((typeSettingsProperties = group.getTypeSettingsProperties()).isEmpty()) {
            return false;
        }
        boolean branchingEnabled = false;
        branchingEnabled = privateLayout ? GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate")) : GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        if (!branchingEnabled || !group.isStaged() || !group.isStagedRemotely() && !isStagingGroup) {
            return false;
        }
        Group stagingGroup = group;
        if (isStagingGroup) {
            stagingGroup = group.getStagingGroup();
        }
        try {
            this._layoutSetBranchLocalService.getMasterLayoutSetBranch(stagingGroup.getGroupId(), privateLayout);
            return true;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    public Layout mergeLayoutRevisionIntoLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = this.getLayoutStagingHandler(layout);
        if (layoutStagingHandler == null) {
            return (Layout)layout.clone();
        }
        layout = layoutStagingHandler.getLayout();
        layout = (Layout)layout.clone();
        LayoutRevision layoutRevision = layoutStagingHandler.getLayoutRevision();
        layout.setName(layoutRevision.getName());
        layout.setTitle(layoutRevision.getTitle());
        layout.setDescription(layoutRevision.getDescription());
        layout.setKeywords(layoutRevision.getKeywords());
        layout.setRobots(layoutRevision.getRobots());
        layout.setTypeSettings(layoutRevision.getTypeSettings());
        layout.setIconImageId(layoutRevision.getIconImageId());
        layout.setThemeId(layoutRevision.getThemeId());
        layout.setColorSchemeId(layoutRevision.getColorSchemeId());
        layout.setCss(layoutRevision.getCss());
        return layout;
    }

    public LayoutSet mergeLayoutSetRevisionIntoLayoutSet(LayoutSet layoutSet) {
        LayoutSetStagingHandler layoutSetStagingHandler = this.getLayoutSetStagingHandler(layoutSet);
        if (layoutSetStagingHandler == null) {
            return (LayoutSet)layoutSet.clone();
        }
        layoutSet = layoutSetStagingHandler.getLayoutSet();
        layoutSet = (LayoutSet)layoutSet.clone();
        LayoutSetBranch layoutSetBranch = layoutSetStagingHandler.getLayoutSetBranch();
        layoutSet.setLogoId(layoutSetBranch.getLogoId());
        layoutSet.setThemeId(layoutSetBranch.getThemeId());
        layoutSet.setColorSchemeId(layoutSetBranch.getColorSchemeId());
        layoutSet.setCss(layoutSetBranch.getCss());
        layoutSet.setSettings(layoutSetBranch.getSettings());
        layoutSet.setLayoutSetPrototypeUuid(layoutSetBranch.getLayoutSetPrototypeUuid());
        layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetBranch.isLayoutSetPrototypeLinkEnabled());
        return layoutSet;
    }

    public boolean prepareLayoutStagingHandler(PortletDataContext portletDataContext, Layout layout) {
        boolean exportLAR = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"exportLAR");
        if (exportLAR || !LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return true;
        }
        long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
        if (layoutSetBranchId <= 0L) {
            return false;
        }
        LayoutRevision layoutRevision = null;
        List layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranchId, layout.getPlid(), true);
        if (!layoutRevisions.isEmpty()) {
            if (layoutRevisions.size() > 1) {
                layoutRevision = this.getLayoutRevision(layout);
                long layoutBranchId = 0L;
                if (layoutRevision != null) {
                    layoutBranchId = layoutRevision.getLayoutBranchId();
                }
                layoutRevision = this._layoutRevisionLocalService.fetchLayoutRevision(layoutSetBranchId, layoutBranchId, true, layout.getPlid());
            }
            if (layoutRevision == null && !layoutRevisions.isEmpty()) {
                layoutRevision = (LayoutRevision)layoutRevisions.get(0);
            }
        }
        if (layoutRevision == null) {
            return false;
        }
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        layoutStagingHandler.setLayoutRevision(layoutRevision);
        return true;
    }

    @Reference(unbind="-")
    protected void setLayoutSetBranchLocalService(LayoutSetBranchLocalService layoutSetBranchLocalService) {
        this._layoutSetBranchLocalService = layoutSetBranchLocalService;
    }
}

