/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ElementHandler;
import com.liferay.portal.kernel.xml.ElementProcessor;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DeletionSystemEventImporter {
    private static final Log _log = LogFactoryUtil.getLog(DeletionSystemEventImporter.class);
    private static final DeletionSystemEventImporter _deletionSystemEventImporter = new DeletionSystemEventImporter();

    public static DeletionSystemEventImporter getInstance() {
        return _deletionSystemEventImporter;
    }

    public void importDeletionSystemEvents(final PortletDataContext portletDataContext) throws Exception {
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETIONS")) {
            return;
        }
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/deletion-system-events.xml");
        if (xml == null) {
            return;
        }
        XMLReader xmlReader = SecureXMLFactoryProviderUtil.newXMLReader();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                DeletionSystemEventImporter.this.doImportDeletionSystemEvents(portletDataContext, element);
            }
        }, new String[]{"deletion-system-event"});
        xmlReader.setContentHandler((ContentHandler)elementHandler);
        xmlReader.parse(new InputSource(new StringReader(xml)));
    }

    protected void doImportDeletionSystemEvents(PortletDataContext portletDataContext, Element element) {
        block3: {
            StagedModelType stagedModelType = new StagedModelType(element.attributeValue("class-name"), element.attributeValue("referrer-class-name"));
            if (!this._shouldImportDeletionSystemEvent(portletDataContext, stagedModelType)) {
                return;
            }
            try {
                StagedModelDataHandlerUtil.deleteStagedModel((PortletDataContext)portletDataContext, (Element)element);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to process deletion for ");
                sb.append((Object)stagedModelType);
                sb.append(" with UUID ");
                sb.append(element.attributeValue("uuid"));
                _log.warn((Object)sb.toString());
            }
        }
    }

    private DeletionSystemEventImporter() {
    }

    private boolean _shouldImportDeletionSystemEvent(PortletDataContext portletDataContext, StagedModelType stagedModelType) {
        Predicate<StagedModelType> anyReferrerClassNamePredicate;
        Predicate<StagedModelType> allReferrerClassNamePredicate;
        Predicate<StagedModelType> classNameIdPredicate;
        Set stagedModelTypes = portletDataContext.getDeletionSystemEventStagedModelTypes();
        if (stagedModelTypes.contains(stagedModelType)) {
            return true;
        }
        Stream stream = stagedModelTypes.stream();
        boolean hasSimilar = stream.anyMatch((classNameIdPredicate = smt -> smt.getClassNameId() == stagedModelType.getClassNameId()).and((allReferrerClassNamePredicate = smt -> "referrer-class-name-all".equals(smt.getReferrerClassName())).or(anyReferrerClassNamePredicate = smt -> Validator.isNotNull((String)stagedModelType.getReferrerClassName()) && "referrer-class-name-any".equals(smt.getReferrerClassName()))));
        return hasSimilar;
    }
}

