/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.service.SystemEventLocalServiceUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Map;
import java.util.Set;

public class DeletionSystemEventExporter {
    private static final Log _log = LogFactoryUtil.getLog(DeletionSystemEventExporter.class);
    private static final DeletionSystemEventExporter _deletionSystemEventExporter = new DeletionSystemEventExporter();

    public static DeletionSystemEventExporter getInstance() {
        return _deletionSystemEventExporter;
    }

    public void exportDeletionSystemEvents(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("deletion-system-events");
        Set deletionSystemEventStagedModelTypes = portletDataContext.getDeletionSystemEventStagedModelTypes();
        if (!deletionSystemEventStagedModelTypes.isEmpty() && MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETIONS")) {
            if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETE_LAYOUTS")) {
                deletionSystemEventStagedModelTypes.remove(new StagedModelType(Layout.class));
            }
            this.doExportDeletionSystemEvents(portletDataContext, rootElement, deletionSystemEventStagedModelTypes);
        }
        portletDataContext.addZipEntry(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext) + "/deletion-system-events.xml", document.formattedString());
    }

    protected void addCreateDateProperty(PortletDataContext portletDataContext, DynamicQuery dynamicQuery) {
        if (!portletDataContext.hasDateRange()) {
            return;
        }
        Property createDateProperty = PropertyFactoryUtil.forName((String)"createDate");
        dynamicQuery.add(createDateProperty.ge((Object)portletDataContext.getStartDate()));
        dynamicQuery.add(createDateProperty.le((Object)portletDataContext.getEndDate()));
    }

    protected void doAddCriteria(PortletDataContext portletDataContext, Set<StagedModelType> deletionSystemEventStagedModelTypes, DynamicQuery dynamicQuery) {
        Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        disjunction.add(groupIdProperty.eq((Object)0L));
        disjunction.add(groupIdProperty.eq((Object)portletDataContext.getScopeGroupId()));
        dynamicQuery.add((Criterion)disjunction);
        if (!deletionSystemEventStagedModelTypes.isEmpty()) {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            Property referrerClassNameIdProperty = PropertyFactoryUtil.forName((String)"referrerClassNameId");
            Disjunction referrerClassNameIdDisjunction = RestrictionsFactoryUtil.disjunction();
            for (StagedModelType stagedModelType : deletionSystemEventStagedModelTypes) {
                String className;
                Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                conjunction.add(classNameIdProperty.eq((Object)stagedModelType.getClassNameId()));
                if (stagedModelType.getReferrerClassNameId() >= 0L) {
                    conjunction.add(referrerClassNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                }
                if ((className = stagedModelType.getClassName()).equals(Layout.class.getName())) {
                    Property extraDataProperty = PropertyFactoryUtil.forName((String)"extraData");
                    conjunction.add(extraDataProperty.like((Object)("%\"privateLayout\":\"" + portletDataContext.isPrivateLayout() + "\"%")));
                }
                referrerClassNameIdDisjunction.add((Criterion)conjunction);
            }
            dynamicQuery.add((Criterion)referrerClassNameIdDisjunction);
        }
        Property typeProperty = PropertyFactoryUtil.forName((String)"type");
        dynamicQuery.add(typeProperty.eq((Object)1));
        if (ExportImportDateUtil.isRangeDateRange((PortletDataContext)portletDataContext)) {
            this.addCreateDateProperty(portletDataContext, dynamicQuery);
        }
    }

    protected void doExportDeletionSystemEvents(PortletDataContext portletDataContext, Element rootElement, Set<StagedModelType> deletionSystemEventStagedModelTypes) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = SystemEventLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> this.doAddCriteria(portletDataContext, deletionSystemEventStagedModelTypes, dynamicQuery));
        actionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        actionableDynamicQuery.setPerformActionMethod(systemEvent -> this.exportDeletionSystemEvent(portletDataContext, (SystemEvent)systemEvent, rootElement));
        actionableDynamicQuery.performActions();
    }

    protected void exportDeletionSystemEvent(PortletDataContext portletDataContext, SystemEvent systemEvent, Element deletionSystemEventsElement) {
        block4: {
            Element deletionSystemEventElement = deletionSystemEventsElement.addElement("deletion-system-event");
            deletionSystemEventElement.addAttribute("class-name", PortalUtil.getClassName((long)systemEvent.getClassNameId()));
            deletionSystemEventElement.addAttribute("extra-data", systemEvent.getExtraData());
            deletionSystemEventElement.addAttribute("group-id", String.valueOf(systemEvent.getGroupId()));
            if (systemEvent.getReferrerClassNameId() > 0L) {
                deletionSystemEventElement.addAttribute("referrer-class-name", PortalUtil.getClassName((long)systemEvent.getReferrerClassNameId()));
            }
            deletionSystemEventElement.addAttribute("uuid", systemEvent.getClassUuid());
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            manifestSummary.incrementModelDeletionCount(new StagedModelType(systemEvent.getClassNameId(), systemEvent.getReferrerClassNameId()));
            if (ExportImportThreadLocal.isStagingInProcess()) {
                try {
                    SystemEventLocalServiceUtil.deleteSystemEvent((long)systemEvent.getSystemEventId());
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)"Unable to delete system event. The events are being cleaned up reagularly by a scheduled process.", (Throwable)pe);
                }
            }
        }
    }

    private DeletionSystemEventExporter() {
    }
}

