/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.changeset.service.ChangesetEntryLocalServiceUtil;
import com.liferay.changeset.util.ChangesetThreadLocal;
import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.internal.background.task.BaseExportImportBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.DefaultExportImportBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseStagingBackgroundTaskExecutor
extends BaseExportImportBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BaseStagingBackgroundTaskExecutor.class);

    public BaseStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new DefaultExportImportBackgroundTaskStatusMessageTranslator());
        this.setIsolationLevel(3);
    }

    protected void clearBackgroundTaskStatus(BackgroundTask backgroundTask) {
        BackgroundTaskStatus backgroundTaskStatus = BackgroundTaskStatusRegistryUtil.getBackgroundTaskStatus((long)backgroundTask.getBackgroundTaskId());
        backgroundTaskStatus.clearAttributes();
    }

    protected void deleteExportedChangesetEntries() throws PortalException {
        ChangesetEntryLocalServiceUtil.deleteChangesetEntries((Set)ChangesetThreadLocal.getExportedChangesetEntryIds());
        ChangesetThreadLocal.clearExportedChangesetEntryIds();
    }

    protected void deleteTempLarOnFailure(File file) {
        ExportImportServiceConfiguration exportImportServiceConfiguration = this.getExportImportServiceConfiguration();
        if (exportImportServiceConfiguration == null || exportImportServiceConfiguration.stagingDeleteTempLarOnFailure()) {
            FileUtil.delete((File)file);
        } else if (file != null) {
            _log.error((Object)("Kept temporary LAR file " + file.getAbsolutePath()));
        }
    }

    protected void deleteTempLarOnSuccess(File file) {
        ExportImportServiceConfiguration exportImportServiceConfiguration = this.getExportImportServiceConfiguration();
        if (exportImportServiceConfiguration == null || exportImportServiceConfiguration.stagingDeleteTempLarOnSuccess()) {
            FileUtil.delete((File)file);
        } else if (file != null && _log.isDebugEnabled()) {
            _log.debug((Object)("Kept temporary LAR file " + file.getAbsolutePath()));
        }
    }

    protected ExportImportServiceConfiguration getExportImportServiceConfiguration() {
        try {
            return (ExportImportServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(ExportImportServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to load export import service configuration", (Throwable)ce);
            return null;
        }
    }

    protected void initThreadLocals(long groupId, boolean privateLayout) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.popServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        serviceContext.setCompanyId(layoutSet.getCompanyId());
        serviceContext.setSignedIn(false);
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)layoutSet.getCompanyId());
        serviceContext.setUserId(defaultUserId);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
    }

    protected void markBackgroundTask(long backgroundTaskId, String backgroundTaskState) {
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.fetchBackgroundTask((long)backgroundTaskId);
        if (backgroundTask == null || Validator.isNull((String)backgroundTaskState)) {
            return;
        }
        HashMap<String, Boolean> taskContextMap = backgroundTask.getTaskContextMap();
        if (taskContextMap == null) {
            taskContextMap = new HashMap<String, Boolean>();
        }
        taskContextMap.put(backgroundTaskState, Boolean.TRUE);
        backgroundTask.setTaskContextMap(taskContextMap);
        BackgroundTaskManagerUtil.amendBackgroundTask((long)backgroundTask.getBackgroundTaskId(), taskContextMap, (int)backgroundTask.getStatus(), (ServiceContext)new ServiceContext());
    }

    protected BackgroundTaskResult processMissingReferences(long backgroundTaskId, MissingReferences missingReferences) {
        BackgroundTaskResult backgroundTaskResult = new BackgroundTaskResult(3);
        if (missingReferences == null) {
            return backgroundTaskResult;
        }
        Map weakMissingReferences = missingReferences.getWeakMissingReferences();
        if (MapUtil.isNotEmpty((Map)weakMissingReferences)) {
            BackgroundTask backgroundTask = BackgroundTaskManagerUtil.fetchBackgroundTask((long)backgroundTaskId);
            JSONArray jsonArray = StagingUtil.getWarningMessagesJSONArray((Locale)this.getLocale(backgroundTask), (Map)weakMissingReferences);
            backgroundTaskResult.setStatusMessage(jsonArray.toString());
        }
        return backgroundTaskResult;
    }
}

