/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.background.task;

import com.liferay.exportimport.internal.background.task.BaseStagingBackgroundTaskExecutor;
import com.liferay.exportimport.internal.background.task.PortletStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.internal.background.task.display.PortletExportImportBackgroundTaskDisplay;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portlet.exportimport.service.http.StagingServiceHttp;
import java.io.File;
import java.io.Serializable;
import java.util.Map;

public class PortletRemoteStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(PortletRemoteStagingBackgroundTaskExecutor.class);

    public PortletRemoteStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new PortletStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        PortletRemoteStagingBackgroundTaskExecutor portletRemoteStagingBackgroundTaskExecutor = new PortletRemoteStagingBackgroundTaskExecutor();
        portletRemoteStagingBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        portletRemoteStagingBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return portletRemoteStagingBackgroundTaskExecutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        MissingReferences missingReferences;
        File file;
        block8: {
            ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            file = null;
            HttpPrincipal httpPrincipal = null;
            missingReferences = null;
            long stagingRequestId = 0L;
            try {
                currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
                ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
                ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)38, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
                file = ExportImportLocalServiceUtil.exportPortletInfoAsFile((ExportImportConfiguration)exportImportConfiguration);
                String checksum = FileUtil.getMD5Checksum((File)file);
                Map taskContextMap = backgroundTask.getTaskContextMap();
                httpPrincipal = (HttpPrincipal)taskContextMap.get("httpPrincipal");
                Map settingsMap = exportImportConfiguration.getSettingsMap();
                long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
                stagingRequestId = StagingServiceHttp.createStagingRequest((HttpPrincipal)httpPrincipal, (long)targetGroupId, (String)checksum);
                StagingUtil.transferFileToRemoteLive((File)file, (long)stagingRequestId, (HttpPrincipal)httpPrincipal);
                this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
                missingReferences = StagingServiceHttp.publishStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId, (ExportImportConfiguration)exportImportConfiguration);
                this.deleteExportedChangesetEntries();
                ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
                ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)39, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
                currentThread.setContextClassLoader(contextClassLoader);
                if (stagingRequestId <= 0L || httpPrincipal == null) break block8;
            }
            catch (Throwable t) {
                try {
                    ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
                    ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)37, (int)36, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
                    this.deleteTempLarOnFailure(file);
                    throw new SystemException(t);
                }
                catch (Throwable throwable) {
                    currentThread.setContextClassLoader(contextClassLoader);
                    if (stagingRequestId <= 0L) throw throwable;
                    if (httpPrincipal == null) throw throwable;
                    try {
                        StagingServiceHttp.cleanUpStagingRequest(httpPrincipal, (long)stagingRequestId);
                        throw throwable;
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) throw throwable;
                        _log.warn((Object)"Unable to clean up the remote live site", (Throwable)pe);
                    }
                    throw throwable;
                }
            }
            try {
                StagingServiceHttp.cleanUpStagingRequest((HttpPrincipal)httpPrincipal, (long)stagingRequestId);
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)"Unable to clean up the remote live site", (Throwable)pe);
            }
        }
        this.deleteTempLarOnSuccess(file);
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    @Override
    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return new PortletExportImportBackgroundTaskDisplay(backgroundTask);
    }
}

