/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.messaging;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.internal.messaging.BasePublisherMessageListener;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/layouts_remote_publisher", "message.status.destination.name=liferay/message_bus/message_status"}, service={LayoutsRemotePublisherMessageListener.class})
@ProviderType
public class LayoutsRemotePublisherMessageListener
extends BasePublisherMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsRemotePublisherMessageListener.class);
    @Reference(target="(destination.name=liferay/message_bus/message_status)")
    private Destination _destination;
    @Reference
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private Staging _staging;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.initialize(componentContext);
    }

    @Deactivate
    protected void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message, MessageStatus messageStatus) throws PortalException {
        long exportImportConfigurationId = GetterUtil.getLong((Object)message.getPayload());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.fetchExportImportConfiguration(exportImportConfigurationId);
        if (exportImportConfiguration == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find export import configuration with ID " + exportImportConfigurationId));
            }
            return;
        }
        messageStatus.setPayload((Object)exportImportConfiguration);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        Map layoutIdMap = (Map)settingsMap.get("layoutIdMap");
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        String remoteAddress = MapUtil.getString((Map)settingsMap, (String)"remoteAddress");
        int remotePort = MapUtil.getInteger((Map)settingsMap, (String)"remotePort");
        String remotePathContext = MapUtil.getString((Map)settingsMap, (String)"remotePathContext");
        boolean secureConnection = MapUtil.getBoolean((Map)settingsMap, (String)"secureConnection");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        boolean remotePrivateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"remotePrivateLayout");
        this.initThreadLocals(userId, parameterMap);
        User user = this._userLocalService.getUserById(userId);
        CompanyThreadLocal.setCompanyId((Long)user.getCompanyId());
        try {
            this._staging.copyRemoteLayouts(sourceGroupId, privateLayout, layoutIdMap, exportImportConfiguration.getName(), parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, targetGroupId, remotePrivateLayout);
        }
        finally {
            this.resetThreadLocals();
        }
    }

    protected Destination getDestination() {
        return this._destination;
    }

    @Reference(target="(destination.name=liferay/layouts_remote_publisher)", unbind="-")
    protected void setDestination(Destination destination) {
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.exportimport.service)(release.schema.version=1.0.0))", unbind="-")
    protected void setRelease(Release release) {
    }
}

