/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.internal.lar.PortletDataContextImpl;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortletDataContextFactory.class})
@ProviderType
public class PortletDataContextFactoryImpl
implements PortletDataContextFactory {
    private GroupLocalService _groupLocalService;
    private LockManager _lockManager;

    public PortletDataContext clonePortletDataContext(PortletDataContext portletDataContext) {
        if (portletDataContext == null) {
            return null;
        }
        PortletDataContextImpl clonePortletDataContext = new PortletDataContextImpl(this._lockManager, false);
        clonePortletDataContext.setCompanyId(portletDataContext.getCompanyId());
        clonePortletDataContext.setCompanyGroupId(portletDataContext.getCompanyGroupId());
        clonePortletDataContext.setDataStrategy(portletDataContext.getDataStrategy());
        clonePortletDataContext.setEndDate(portletDataContext.getEndDate());
        clonePortletDataContext.setExportDataRootElement(portletDataContext.getExportDataRootElement());
        clonePortletDataContext.setGroupId(portletDataContext.getGroupId());
        clonePortletDataContext.setImportDataRootElement(portletDataContext.getImportDataRootElement());
        long[] layoutIds = portletDataContext.getLayoutIds();
        if (ArrayUtil.isNotEmpty((long[])layoutIds)) {
            clonePortletDataContext.setLayoutIds(Arrays.copyOf(layoutIds, layoutIds.length));
        }
        ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
        clonePortletDataContext.setManifestSummary((ManifestSummary)manifestSummary.clone());
        Map cloneNewPrimaryKeysMaps = clonePortletDataContext.getNewPrimaryKeysMaps();
        cloneNewPrimaryKeysMaps.putAll(portletDataContext.getNewPrimaryKeysMaps());
        clonePortletDataContext.setParameterMap(portletDataContext.getParameterMap());
        clonePortletDataContext.setPortletId(portletDataContext.getPortletId());
        clonePortletDataContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        clonePortletDataContext.setSourceCompanyId(portletDataContext.getSourceCompanyId());
        clonePortletDataContext.setSourceCompanyGroupId(portletDataContext.getSourceCompanyGroupId());
        clonePortletDataContext.setSourceGroupId(portletDataContext.getSourceGroupId());
        clonePortletDataContext.setSourceUserPersonalSiteGroupId(portletDataContext.getSourceUserPersonalSiteGroupId());
        clonePortletDataContext.setStartDate(portletDataContext.getStartDate());
        clonePortletDataContext.setUserIdStrategy(portletDataContext.getUserIdStrategy());
        clonePortletDataContext.setUserPersonalSiteGroupId(portletDataContext.getUserPersonalSiteGroupId());
        clonePortletDataContext.setZipReader(portletDataContext.getZipReader());
        clonePortletDataContext.setZipWriter(portletDataContext.getZipWriter());
        return clonePortletDataContext;
    }

    public PortletDataContext createExportPortletDataContext(long companyId, long groupId, Map<String, String[]> parameterMap, Date startDate, Date endDate, ZipWriter zipWriter) throws PortletDataException {
        this.validateDateRange(startDate, endDate);
        PortletDataContext portletDataContext = this.createPortletDataContext(companyId, groupId);
        portletDataContext.setEndDate(endDate);
        portletDataContext.setParameterMap(parameterMap);
        portletDataContext.setStartDate(startDate);
        portletDataContext.setZipWriter(zipWriter);
        return portletDataContext;
    }

    public PortletDataContext createImportPortletDataContext(long companyId, long groupId, Map<String, String[]> parameterMap, UserIdStrategy userIdStrategy, ZipReader zipReader) throws PortletDataException {
        PortletDataContext portletDataContext = this.createPortletDataContext(companyId, groupId);
        String dataStrategy = MapUtil.getString(parameterMap, (String)"DATA_STRATEGY", (String)"DATA_STRATEGY_MIRROR");
        portletDataContext.setDataStrategy(dataStrategy);
        portletDataContext.setNewLayouts(new ArrayList());
        portletDataContext.setParameterMap(parameterMap);
        portletDataContext.setUserIdStrategy(userIdStrategy);
        portletDataContext.setZipReader(zipReader);
        this.readXML(portletDataContext);
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        groupIds.put(portletDataContext.getSourceCompanyGroupId(), portletDataContext.getCompanyGroupId());
        return portletDataContext;
    }

    public PortletDataContext createPreparePortletDataContext(long companyId, long groupId, Date startDate, Date endDate) throws PortletDataException {
        return this.createPreparePortletDataContext(companyId, groupId, null, startDate, endDate);
    }

    public PortletDataContext createPreparePortletDataContext(long companyId, long groupId, String range, Date startDate, Date endDate) throws PortletDataException {
        this.validateDateRange(startDate, endDate);
        PortletDataContext portletDataContext = this.createPortletDataContext(companyId, groupId);
        portletDataContext.setEndDate(endDate);
        Map<String, String[]> parameterMap = Collections.emptyMap();
        if (range != null) {
            parameterMap = new HashMap();
            parameterMap.put("range", new String[]{range});
        }
        portletDataContext.setParameterMap(parameterMap);
        portletDataContext.setStartDate(startDate);
        return portletDataContext;
    }

    public PortletDataContext createPreparePortletDataContext(ThemeDisplay themeDisplay, Date startDate, Date endDate) throws PortletDataException {
        return this.createPreparePortletDataContext(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), startDate, endDate);
    }

    protected PortletDataContext createPortletDataContext(long companyId, long groupId) {
        PortletDataContextImpl portletDataContext;
        block7: {
            block6: {
                portletDataContext = new PortletDataContextImpl(this._lockManager);
                try {
                    Group companyGroup = this._groupLocalService.fetchCompanyGroup(companyId);
                    if (companyGroup != null) {
                        portletDataContext.setCompanyGroupId(companyGroup.getGroupId());
                    }
                }
                catch (Exception e) {
                    if (!CompanyThreadLocal.isDeleteInProcess()) break block6;
                    PortletDataException pde = new PortletDataException(14, (Throwable)e);
                    pde.setCompanyId(companyId);
                    throw new SystemException((Throwable)pde);
                }
            }
            portletDataContext.setCompanyId(companyId);
            portletDataContext.setGroupId(groupId);
            portletDataContext.setScopeGroupId(groupId);
            try {
                Group userPersonalSiteGroup = this._groupLocalService.fetchUserPersonalSiteGroup(companyId);
                if (userPersonalSiteGroup != null) {
                    portletDataContext.setUserPersonalSiteGroupId(userPersonalSiteGroup.getGroupId());
                }
            }
            catch (Exception e) {
                if (!CompanyThreadLocal.isDeleteInProcess()) break block7;
                PortletDataException pde = new PortletDataException(14, (Throwable)e);
                pde.setCompanyId(companyId);
                throw new SystemException((Throwable)pde);
            }
        }
        return portletDataContext;
    }

    protected void readXML(PortletDataContext portletDataContext) throws PortletDataException {
        String xml = portletDataContext.getZipEntryAsString("/manifest.xml");
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception e) {
            throw new PortletDataException("Unable to create portlet data context for the import process because of an invalid LAR manifest", (Throwable)e);
        }
        portletDataContext.setImportDataRootElement(rootElement);
        Element headerElement = rootElement.element("header");
        long sourceCompanyId = GetterUtil.getLong((String)headerElement.attributeValue("company-id"));
        portletDataContext.setSourceCompanyId(sourceCompanyId);
        long sourceCompanyGroupId = GetterUtil.getLong((String)headerElement.attributeValue("company-group-id"));
        portletDataContext.setSourceCompanyGroupId(sourceCompanyGroupId);
        long sourceGroupId = GetterUtil.getLong((String)headerElement.attributeValue("group-id"));
        portletDataContext.setSourceGroupId(sourceGroupId);
        long sourceUserPersonalSiteGroupId = GetterUtil.getLong((String)headerElement.attributeValue("user-personal-site-group-id"));
        portletDataContext.setSourceUserPersonalSiteGroupId(sourceUserPersonalSiteGroupId);
        Element missingReferencesElement = rootElement.element("missing-references");
        if (missingReferencesElement != null) {
            portletDataContext.setMissingReferencesElement(missingReferencesElement);
        }
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLockManager(LockManager lockManager) {
        this._lockManager = lockManager;
    }

    protected void validateDateRange(Date startDate, Date endDate) throws PortletDataException {
        if (startDate == null && endDate != null) {
            throw new PortletDataException(17);
        }
        if (startDate != null && endDate == null) {
            throw new PortletDataException(7);
        }
        if (startDate != null) {
            if (startDate.after(endDate) || startDate.equals(endDate)) {
                throw new PortletDataException(6);
            }
            Date now = new Date();
            if (startDate.after(now)) {
                throw new PortletDataException(3);
            }
            if (endDate.after(now)) {
                throw new PortletDataException(2);
            }
        }
    }
}

