/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.internal.util.ExportImportPermissionUtil;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ProviderType
public class LayoutCache {
    protected Map<Long, List<Role>> groupRolesMap = new HashMap<Long, List<Role>>();
    protected Map<Long, List<User>> groupUsersMap = new HashMap<Long, List<User>>();
    protected Map<String, Role> nameRolesMap = new HashMap<String, Role>();
    protected Map<Long, List<Role>> userRolesMap = new HashMap<Long, List<Role>>();
    protected Map<String, Role> uuidRolesMap = new HashMap<String, Role>();
    private static final Log _log = LogFactoryUtil.getLog(LayoutCache.class);

    public Role getNameRole(long companyId, String roleName) throws PortalException {
        Role role;
        block3: {
            role = this.nameRolesMap.get(roleName);
            if (role == null) {
                try {
                    role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
                    this.nameRolesMap.put(roleName, role);
                }
                catch (NoSuchRoleException nsre) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)nsre, (Throwable)nsre);
                }
            }
        }
        return role;
    }

    public Role getUuidRole(long companyId, String uuid) throws PortalException {
        Role role;
        block3: {
            role = this.uuidRolesMap.get(uuid);
            if (role == null) {
                try {
                    role = RoleLocalServiceUtil.getRoleByUuidAndCompanyId((String)uuid, (long)companyId);
                    this.uuidRolesMap.put(uuid, role);
                }
                catch (NoSuchRoleException nsre) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)nsre, (Throwable)nsre);
                }
            }
        }
        return role;
    }

    protected List<Role> getGroupRoles(long groupId, String resourceName) throws PortalException {
        List roles = this.groupRolesMap.get(groupId);
        if (roles != null) {
            return roles;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        roles = ListUtil.copy((List)ResourceActionsUtil.getRoles((long)group.getCompanyId(), (Group)group, (String)resourceName, null));
        Map teamRoleMap = RoleLocalServiceUtil.getTeamRoleMap((long)groupId);
        for (Map.Entry entry : teamRoleMap.entrySet()) {
            Team team = (Team)entry.getKey();
            Role teamRole = (Role)entry.getValue();
            teamRole.setName(ExportImportPermissionUtil.getTeamRoleName(team.getName()));
            teamRole.setDescription(team.getDescription());
            roles.add(teamRole);
        }
        this.groupRolesMap.put(groupId, roles);
        return roles;
    }

    protected List<User> getGroupUsers(long groupId) {
        List users = this.groupUsersMap.get(groupId);
        if (users == null) {
            users = UserLocalServiceUtil.getGroupUsers((long)groupId);
            this.groupUsersMap.put(groupId, users);
        }
        return users;
    }

    protected List<Role> getUserRoles(long userId) {
        List userRoles = this.userRolesMap.get(userId);
        if (userRoles == null) {
            userRoles = RoleLocalServiceUtil.getUserRoles((long)userId);
            this.userRolesMap.put(userId, userRoles);
        }
        return userRoles;
    }
}

