/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.configuration;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactoryUtil;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExportImportConfigurationSettingsMapFactory.class})
@ProviderType
public class ExportImportConfigurationSettingsMapFactoryImpl
implements ExportImportConfigurationSettingsMapFactory {
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;

    public Map<String, Serializable> buildExportLayoutSettingsMap(long userId, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Locale locale, TimeZone timeZone) {
        return this.buildPublishLayoutLocalSettingsMap(userId, groupId, 0L, privateLayout, layoutIds, parameterMap, locale, timeZone);
    }

    public Map<String, Serializable> buildExportLayoutSettingsMap(User user, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap) {
        return this.buildExportLayoutSettingsMap(user.getUserId(), groupId, privateLayout, layoutIds, parameterMap, user.getLocale(), user.getTimeZone());
    }

    public Map<String, Serializable> buildExportPortletSettingsMap(long userId, long sourcePlid, long sourceGroupId, String portletId, Map<String, String[]> parameterMap, Locale locale, TimeZone timeZone, String fileName) {
        return this.buildSettingsMap(userId, sourceGroupId, sourcePlid, 0L, 0L, portletId, null, null, null, parameterMap, "", 0, "", null, null, locale, timeZone, fileName);
    }

    public Map<String, Serializable> buildExportPortletSettingsMap(User user, long sourcePlid, long sourceGroupId, String portletId, Map<String, String[]> parameterMap, String fileName) {
        return this.buildExportPortletSettingsMap(user.getUserId(), sourcePlid, sourceGroupId, portletId, parameterMap, user.getLocale(), user.getTimeZone(), fileName);
    }

    public Map<String, Serializable> buildImportLayoutSettingsMap(long userId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Locale locale, TimeZone timeZone) {
        return this.buildSettingsMap(userId, 0L, 0L, targetGroupId, 0L, "", privateLayout, null, layoutIds, parameterMap, "", 0, "", null, null, locale, timeZone, "");
    }

    public Map<String, Serializable> buildImportLayoutSettingsMap(User user, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap) {
        return this.buildImportLayoutSettingsMap(user.getUserId(), targetGroupId, privateLayout, layoutIds, parameterMap, user.getLocale(), user.getTimeZone());
    }

    public Map<String, Serializable> buildImportPortletSettingsMap(long userId, long targetPlid, long targetGroupId, String portletId, Map<String, String[]> parameterMap, Locale locale, TimeZone timeZone) {
        return this.buildSettingsMap(userId, 0L, 0L, targetGroupId, targetPlid, portletId, null, null, null, parameterMap, "", 0, "", null, null, locale, timeZone, "");
    }

    public Map<String, Serializable> buildImportPortletSettingsMap(User user, long targetPlid, long targetGroupId, String portletId, Map<String, String[]> parameterMap) {
        return this.buildImportPortletSettingsMap(user.getUserId(), targetPlid, targetGroupId, portletId, parameterMap, user.getLocale(), user.getTimeZone());
    }

    public Map<String, Serializable> buildPublishLayoutLocalSettingsMap(long userId, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Locale locale, TimeZone timeZone) {
        return this.buildSettingsMap(userId, sourceGroupId, 0L, targetGroupId, 0L, "", privateLayout, null, layoutIds, parameterMap, "", 0, "", null, null, locale, timeZone, "");
    }

    public Map<String, Serializable> buildPublishLayoutLocalSettingsMap(User user, long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap) {
        return this.buildPublishLayoutLocalSettingsMap(user.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, user.getLocale(), user.getTimeZone());
    }

    public Map<String, Serializable> buildPublishLayoutRemoteSettingsMap(long userId, long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Locale locale, TimeZone timeZone) {
        return this.buildSettingsMap(userId, sourceGroupId, 0L, remoteGroupId, 0L, "", privateLayout, layoutIdMap, null, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remotePrivateLayout, locale, timeZone, "");
    }

    public Map<String, Serializable> buildPublishLayoutRemoteSettingsMap(User user, long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout) {
        return this.buildPublishLayoutRemoteSettingsMap(user.getUserId(), sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, user.getLocale(), user.getTimeZone());
    }

    public Map<String, Serializable> buildPublishPortletSettingsMap(long userId, long sourceGroupId, long sourcePlid, long targetGroupId, long targetPlid, String portletId, Map<String, String[]> parameterMap, Locale locale, TimeZone timeZone) {
        return this.buildSettingsMap(userId, sourceGroupId, sourcePlid, targetGroupId, targetPlid, portletId, null, null, null, parameterMap, "", 0, "", null, null, locale, timeZone, null);
    }

    public Map<String, Serializable> buildPublishPortletSettingsMap(User user, long sourceGroupId, long sourcePlid, long targetGroupId, long targetPlid, String portletId, Map<String, String[]> parameterMap) {
        return this.buildPublishPortletSettingsMap(user.getUserId(), sourceGroupId, sourcePlid, targetGroupId, targetPlid, portletId, parameterMap, user.getLocale(), user.getTimeZone());
    }

    public Map<String, Serializable> buildSettingsMap(PortletRequest portletRequest, long groupId, int type) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"privateLayout");
        Map layoutIdMap = this._exportImportHelper.getLayoutIdMap(portletRequest);
        if (type == 0) {
            long[] layoutIds = this._exportImportHelper.getLayoutIds(layoutIdMap);
            return this.buildExportLayoutSettingsMap(themeDisplay.getUserId(), groupId, privateLayout, layoutIds, portletRequest.getParameterMap(), themeDisplay.getLocale(), themeDisplay.getTimeZone());
        }
        Group stagingGroup = this._groupLocalService.getGroup(groupId);
        Group liveGroup = stagingGroup.getLiveGroup();
        Map parameterMap = ExportImportConfigurationParameterMapFactoryUtil.buildParameterMap((PortletRequest)portletRequest);
        if (liveGroup != null) {
            long[] layoutIds = this._exportImportHelper.getLayoutIds(layoutIdMap, liveGroup.getGroupId());
            return this.buildPublishLayoutLocalSettingsMap(themeDisplay.getUserId(), stagingGroup.getGroupId(), liveGroup.getGroupId(), privateLayout, layoutIds, parameterMap, themeDisplay.getLocale(), themeDisplay.getTimeZone());
        }
        UnicodeProperties groupTypeSettingsProperties = stagingGroup.getTypeSettingsProperties();
        String remoteAddress = ParamUtil.getString((PortletRequest)portletRequest, (String)"remoteAddress", (String)groupTypeSettingsProperties.getProperty("remoteAddress"));
        remoteAddress = this._http.removeProtocol(remoteAddress);
        int remotePort = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"remotePort", (int)GetterUtil.getInteger((String)groupTypeSettingsProperties.getProperty("remotePort")));
        String remotePathContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"remotePathContext", (String)groupTypeSettingsProperties.getProperty("remotePathContext"));
        boolean secureConnection = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"secureConnection", (boolean)GetterUtil.getBoolean((String)groupTypeSettingsProperties.getProperty("secureConnection")));
        long remoteGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"remoteGroupId", (long)GetterUtil.getLong((String)groupTypeSettingsProperties.getProperty("remoteGroupId")));
        boolean remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"remotePrivateLayout");
        this._groupLocalService.validateRemote(groupId, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId);
        return this.buildPublishLayoutRemoteSettingsMap(themeDisplay.getUserId(), groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, themeDisplay.getLocale(), themeDisplay.getTimeZone());
    }

    protected Map<String, Serializable> buildSettingsMap(long userId, long sourceGroupId, long sourcePlid, long targetGroupId, long targetPlid, String portletId, Boolean privateLayout, Map<Long, Boolean> layoutIdMap, long[] layoutIds, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, Boolean secureConnection, Boolean remotePrivateLayout, Locale locale, TimeZone timeZone, String fileName) {
        HashMap<String, Serializable> settingsMap = new HashMap<String, Serializable>();
        if (Validator.isNotNull((String)fileName)) {
            settingsMap.put("fileName", (Serializable)((Object)fileName));
        }
        if (MapUtil.isNotEmpty(layoutIdMap)) {
            HashMap<Long, Boolean> serializableLayoutIdMap = new HashMap<Long, Boolean>(layoutIdMap);
            settingsMap.put("layoutIdMap", serializableLayoutIdMap);
        }
        if (ArrayUtil.isNotEmpty((long[])layoutIds)) {
            settingsMap.put("layoutIds", (Serializable)layoutIds);
        }
        if (locale != null) {
            settingsMap.put("locale", locale);
        }
        if (parameterMap != null) {
            HashMap<String, String[]> serializableParameterMap = new HashMap<String, String[]>(parameterMap);
            if (layoutIds != null) {
                serializableParameterMap.remove("layoutIds");
            }
            settingsMap.put("parameterMap", serializableParameterMap);
        }
        if (Validator.isNotNull((String)portletId)) {
            settingsMap.put("portletId", (Serializable)((Object)portletId));
        }
        if (privateLayout != null) {
            settingsMap.put("privateLayout", privateLayout);
        }
        if (Validator.isNotNull((String)remoteAddress)) {
            settingsMap.put("remoteAddress", (Serializable)((Object)remoteAddress));
        }
        if (Validator.isNotNull((String)remotePathContext)) {
            settingsMap.put("remotePathContext", (Serializable)((Object)remotePathContext));
        }
        if (remotePort > 0) {
            settingsMap.put("remotePort", Integer.valueOf(remotePort));
        }
        if (remotePrivateLayout != null) {
            settingsMap.put("remotePrivateLayout", remotePrivateLayout);
        }
        if (secureConnection != null) {
            settingsMap.put("secureConnection", secureConnection);
        }
        if (sourceGroupId > 0L) {
            settingsMap.put("sourceGroupId", Long.valueOf(sourceGroupId));
        }
        if (sourcePlid > 0L) {
            settingsMap.put("sourcePlid", Long.valueOf(sourcePlid));
        }
        if (targetGroupId > 0L) {
            settingsMap.put("targetGroupId", Long.valueOf(targetGroupId));
        }
        if (targetPlid > 0L) {
            settingsMap.put("targetPlid", Long.valueOf(targetPlid));
        }
        if (timeZone != null) {
            settingsMap.put("timezone", timeZone);
        }
        settingsMap.put("userId", Long.valueOf(userId));
        return settingsMap;
    }
}

