/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.lifecycle;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lifecycle.EventAwareExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.TransientValue;
import java.io.Serializable;
import java.util.List;

@ProviderType
public class DefaultEventAwareExportImportLifecycleListener
implements ExportImportLifecycleListener {
    private final EventAwareExportImportLifecycleListener _lifecycleListener;

    public DefaultEventAwareExportImportLifecycleListener(EventAwareExportImportLifecycleListener lifecycleListener) {
        this._lifecycleListener = lifecycleListener;
    }

    public boolean isParallel() {
        return this._lifecycleListener.isParallel();
    }

    public void onExportImportLifecycleEvent(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        this._lifecycleListener.onExportImportLifecycleEvent(exportImportLifecycleEvent);
        this.callEventHandlers(exportImportLifecycleEvent);
    }

    protected void callEventHandlers(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        List attributes = exportImportLifecycleEvent.getAttributes();
        int code = exportImportLifecycleEvent.getCode();
        int processFlag = exportImportLifecycleEvent.getProcessFlag();
        if (code == 1) {
            this.onLayoutExportFailed(this.getPortletDataContextAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 3) {
            this.onLayoutExportStarted(this.getPortletDataContextAttribute(attributes));
        } else if (code == 2) {
            this.onLayoutExportSucceeded(this.getPortletDataContextAttribute(attributes));
        } else if (code == 4) {
            this.onLayoutImportFailed(this.getPortletDataContextAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 6) {
            this.onLayoutImportStarted(this.getPortletDataContextAttribute(attributes));
        } else if (code == 5) {
            if (processFlag == 31 || processFlag == 32) {
                this.onLayoutImportProcessFinished(this.getPortletDataContextAttribute(attributes));
            } else {
                this.onLayoutImportSucceeded(this.getPortletDataContextAttribute(attributes));
            }
        } else if (code == 7) {
            this.onPortletExportFailed(this.getPortletDataContextAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 9) {
            this.onPortletExportStarted(this.getPortletDataContextAttribute(attributes));
        } else if (code == 8) {
            this.onPortletExportSucceeded(this.getPortletDataContextAttribute(attributes));
        } else if (code == 10) {
            this.onPortletImportFailed(this.getPortletDataContextAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 12) {
            this.onPortletImportStarted(this.getPortletDataContextAttribute(attributes));
        } else if (code == 11) {
            if (processFlag == 35 || processFlag == 36) {
                this.onPortletImportProcessFinished(this.getPortletDataContextAttribute(attributes));
            } else {
                this.onPortletImportSucceeded(this.getPortletDataContextAttribute(attributes));
            }
        } else if (code == 13) {
            this.onLayoutLocalPublicationFailed(this.getExportImportConfigurationAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 15) {
            this.onLayoutLocalPublicationStarted(this.getExportImportConfigurationAttribute(attributes));
        } else if (code == 14) {
            this.onLayoutLocalPublicationSucceeded(this.getExportImportConfigurationAttribute(attributes));
        } else if (code == 16) {
            this.onLayoutRemotePublicationFailed(this.getExportImportConfigurationAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 18) {
            this.onLayoutRemotePublicationStarted(this.getExportImportConfigurationAttribute(attributes));
        } else if (code == 17) {
            this.onLayoutRemotePublicationSucceeded(this.getExportImportConfigurationAttribute(attributes));
        } else if (code == 19) {
            this.onPortletPublicationFailed(this.getExportImportConfigurationAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 21) {
            this.onPortletPublicationStarted(this.getExportImportConfigurationAttribute(attributes));
        } else if (code == 20) {
            this.onPortletPublicationSucceeded(this.getExportImportConfigurationAttribute(attributes));
        } else if (code == 22) {
            this.onStagedModelExportFailed(this.getPortletDataContextAttribute(attributes), this.getStagedModelAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 24) {
            this.onStagedModelExportStarted(this.getPortletDataContextAttribute(attributes), this.getStagedModelAttribute(attributes));
        } else if (code == 23) {
            this.onStagedModelExportSucceeded(this.getPortletDataContextAttribute(attributes), this.getStagedModelAttribute(attributes));
        } else if (code == 25) {
            this.onStagedModelImportFailed(this.getPortletDataContextAttribute(attributes), this.getStagedModelAttribute(attributes), this.getThrowableAttribute(attributes));
        } else if (code == 27) {
            this.onStagedModelImportStarted(this.getPortletDataContextAttribute(attributes), this.getStagedModelAttribute(attributes));
        } else if (code == 26) {
            this.onStagedModelImportSucceeded(this.getPortletDataContextAttribute(attributes), this.getStagedModelAttribute(attributes));
        }
    }

    protected <T> T getAttributeByType(List<Serializable> attributes, Class<T> clazz) {
        for (Serializable attribute : attributes) {
            if (!clazz.isInstance(attribute)) continue;
            return clazz.cast(attribute);
        }
        return null;
    }

    protected ExportImportConfiguration getExportImportConfigurationAttribute(List<Serializable> attributes) {
        return this.getAttributeByType(attributes, ExportImportConfiguration.class);
    }

    protected PortletDataContext getPortletDataContextAttribute(List<Serializable> attributes) {
        return this.getAttributeByType(attributes, PortletDataContext.class);
    }

    protected StagedModel getStagedModelAttribute(List<Serializable> attributes) {
        TransientValue transientValue = this.getAttributeByType(attributes, TransientValue.class);
        Object value = transientValue.getValue();
        if (value instanceof StagedModel) {
            return (StagedModel)value;
        }
        return null;
    }

    protected Throwable getThrowableAttribute(List<Serializable> attributes) {
        return this.getAttributeByType(attributes, Throwable.class);
    }

    protected void onLayoutExportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        this._lifecycleListener.onLayoutExportFailed(portletDataContext, throwable);
    }

    protected void onLayoutExportStarted(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onLayoutExportStarted(portletDataContext);
    }

    protected void onLayoutExportSucceeded(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onLayoutExportSucceeded(portletDataContext);
    }

    protected void onLayoutImportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        this._lifecycleListener.onLayoutImportFailed(portletDataContext, throwable);
    }

    protected void onLayoutImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onLayoutImportProcessFinished(portletDataContext);
    }

    protected void onLayoutImportStarted(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onLayoutImportStarted(portletDataContext);
    }

    protected void onLayoutImportSucceeded(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onLayoutImportSucceeded(portletDataContext);
    }

    protected void onLayoutLocalPublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
        this._lifecycleListener.onLayoutLocalPublicationFailed(exportImportConfiguration, throwable);
    }

    protected void onLayoutLocalPublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
        this._lifecycleListener.onLayoutLocalPublicationStarted(exportImportConfiguration);
    }

    protected void onLayoutLocalPublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
        this._lifecycleListener.onLayoutLocalPublicationSucceeded(exportImportConfiguration);
    }

    protected void onLayoutRemotePublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
        this._lifecycleListener.onLayoutRemotePublicationFailed(exportImportConfiguration, throwable);
    }

    protected void onLayoutRemotePublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
        this._lifecycleListener.onLayoutRemotePublicationStarted(exportImportConfiguration);
    }

    protected void onLayoutRemotePublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
        this._lifecycleListener.onLayoutRemotePublicationSucceeded(exportImportConfiguration);
    }

    protected void onPortletExportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        this._lifecycleListener.onPortletExportFailed(portletDataContext, throwable);
    }

    protected void onPortletExportStarted(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onPortletExportStarted(portletDataContext);
    }

    protected void onPortletExportSucceeded(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onPortletExportSucceeded(portletDataContext);
    }

    protected void onPortletImportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        this._lifecycleListener.onPortletImportFailed(portletDataContext, throwable);
    }

    protected void onPortletImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onPortletImportProcessFinished(portletDataContext);
    }

    protected void onPortletImportStarted(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onPortletImportStarted(portletDataContext);
    }

    protected void onPortletImportSucceeded(PortletDataContext portletDataContext) throws Exception {
        this._lifecycleListener.onPortletImportSucceeded(portletDataContext);
    }

    protected void onPortletPublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
        this._lifecycleListener.onPortletPublicationFailed(exportImportConfiguration, throwable);
    }

    protected void onPortletPublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
        this._lifecycleListener.onPortletPublicationStarted(exportImportConfiguration);
    }

    protected void onPortletPublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
        this._lifecycleListener.onPortletPublicationSucceeded(exportImportConfiguration);
    }

    protected void onStagedModelExportFailed(PortletDataContext portletDataContext, StagedModel stagedModel, Throwable throwable) throws Exception {
        this._lifecycleListener.onStagedModelExportFailed(portletDataContext, stagedModel, throwable);
    }

    protected void onStagedModelExportStarted(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        this._lifecycleListener.onStagedModelExportStarted(portletDataContext, stagedModel);
    }

    protected void onStagedModelExportSucceeded(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        this._lifecycleListener.onStagedModelExportSucceeded(portletDataContext, stagedModel);
    }

    protected void onStagedModelImportFailed(PortletDataContext portletDataContext, StagedModel stagedModel, Throwable throwable) throws Exception {
        this._lifecycleListener.onStagedModelImportFailed(portletDataContext, stagedModel, throwable);
    }

    protected void onStagedModelImportStarted(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        this._lifecycleListener.onStagedModelImportStarted(portletDataContext, stagedModel);
    }

    protected void onStagedModelImportSucceeded(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        this._lifecycleListener.onStagedModelImportSucceeded(portletDataContext, stagedModel);
    }
}

