/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.portlet.preferences.processor;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessorHelper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.function.Function;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ExportImportPortletPreferencesProcessorHelper.class})
@ProviderType
public class ExportImportPortletPreferencesProcessorHelperImpl
implements ExportImportPortletPreferencesProcessorHelper {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportPortletPreferencesProcessorHelperImpl.class);

    public void updateExportPortletPreferencesClassPKs(PortletDataContext portletDataContext, Portlet portlet, PortletPreferences portletPreferences, String key, String className, Function<String, String> exportPortletPreferencesNewValueFunction) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] primaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String primaryKey : primaryKeys = StringUtil.split((String)oldValue)) {
                if (!Validator.isNumber((String)primaryKey)) break;
                long primaryKeyLong = GetterUtil.getLong((String)primaryKey);
                String newPreferencesValue = exportPortletPreferencesNewValueFunction.apply(primaryKey);
                if (Validator.isNull((String)newPreferencesValue)) {
                    if (!_log.isWarnEnabled()) continue;
                    StringBundler sb = new StringBundler(5);
                    sb.append("Unable to export portlet preferences ");
                    sb.append("value for class ");
                    sb.append(className);
                    sb.append(" with primary key ");
                    sb.append(primaryKeyLong);
                    _log.warn((Object)sb.toString());
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)primaryKey, (String)newPreferencesValue);
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }

    public void updateImportPortletPreferencesClassPKs(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, long companyGroupId, Function<String, Long> importPortletPreferencesNewValueSupplier) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] portletPreferencesOldValues;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String portletPreferencesOldValue : portletPreferencesOldValues = StringUtil.split((String)oldValue)) {
                Long newPrimaryKey = importPortletPreferencesNewValueSupplier.apply(portletPreferencesOldValue);
                if (Validator.isNull((Long)newPrimaryKey)) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Unable to import portlet preferences value " + portletPreferencesOldValue));
                    continue;
                }
                newValue = StringUtil.replace((String)newValue, (String)portletPreferencesOldValue, (String)newPrimaryKey.toString());
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }
}

