/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lifecycle;

import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lifecycle.EventAwareExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleEvent;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ExportImportLifecycleListener.class})
public class LoggerExportImportLifecycleListener
implements EventAwareExportImportLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(LoggerExportImportLifecycleListener.class);

    public String getStagedModelLogFragment(StagedModel stagedModel) {
        StringBundler sb = new StringBundler(8);
        sb.append("{");
        sb.append("class: ");
        sb.append(ExportImportClassedModelUtil.getClassName((ClassedModel)stagedModel));
        if (stagedModel instanceof StagedGroupedModel) {
            StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)stagedModel;
            sb.append(", groupId: ");
            sb.append(stagedGroupedModel.getGroupId());
        }
        sb.append(", uuid: ");
        sb.append(stagedModel.getUuid());
        sb.append("}");
        return sb.toString();
    }

    public boolean isParallel() {
        return false;
    }

    public void onExportImportLifecycleEvent(ExportImportLifecycleEvent exportImportLifecycleEvent) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
    }

    public void onLayoutExportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout export failed for group " + portletDataContext.getGroupId()), throwable);
    }

    public void onLayoutExportStarted(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout export started for group " + portletDataContext.getGroupId()));
    }

    public void onLayoutExportSucceeded(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout export succeeded for group " + portletDataContext.getGroupId()));
    }

    public void onLayoutImportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout import failed for group " + portletDataContext.getGroupId()), throwable);
    }

    public void onLayoutImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
    }

    public void onLayoutImportStarted(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout import started for group " + portletDataContext.getGroupId()));
    }

    public void onLayoutImportSucceeded(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout import succeeded for group " + portletDataContext.getGroupId()));
    }

    public void onLayoutLocalPublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout publication failed for group " + exportImportConfiguration.getGroupId()), throwable);
    }

    public void onLayoutLocalPublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout publication started for group " + exportImportConfiguration.getGroupId()));
    }

    public void onLayoutLocalPublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout publication succeeded for group " + exportImportConfiguration.getGroupId()));
    }

    public void onLayoutRemotePublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout remote publication failed for group " + exportImportConfiguration.getGroupId()), throwable);
    }

    public void onLayoutRemotePublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout publication started for group " + exportImportConfiguration.getGroupId()));
    }

    public void onLayoutRemotePublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Layout remote publication succeeded for group " + exportImportConfiguration.getGroupId()));
    }

    public void onPortletExportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Portlet export failed for portlet " + portletDataContext.getPortletId()), throwable);
    }

    public void onPortletExportStarted(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Portlet export started for portlet " + portletDataContext.getPortletId()));
    }

    public void onPortletExportSucceeded(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Portlet export succeeded for portlet " + portletDataContext.getPortletId()));
    }

    public void onPortletImportFailed(PortletDataContext portletDataContext, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Portlet import failed for portlet " + portletDataContext.getPortletId()), throwable);
    }

    public void onPortletImportProcessFinished(PortletDataContext portletDataContext) throws Exception {
    }

    public void onPortletImportStarted(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Portlet import started for portlet " + portletDataContext.getPortletId()));
    }

    public void onPortletImportSucceeded(PortletDataContext portletDataContext) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Portlet import succeeded for portlet " + portletDataContext.getPortletId()));
    }

    public void onPortletPublicationFailed(ExportImportConfiguration exportImportConfiguration, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        _log.debug((Object)("Portlet publication failed for portlet " + portletId), throwable);
    }

    public void onPortletPublicationStarted(ExportImportConfiguration exportImportConfiguration) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        _log.debug((Object)("Portlet publication started for portlet " + portletId));
    }

    public void onPortletPublicationSucceeded(ExportImportConfiguration exportImportConfiguration) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        _log.debug((Object)("Portlet publication succeeded for portlet " + portletId));
    }

    public void onStagedModelExportFailed(PortletDataContext portletDataContext, StagedModel stagedModel, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Staged model " + this.getStagedModelLogFragment(stagedModel) + " export failed"), throwable);
    }

    public void onStagedModelExportStarted(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Staged model " + this.getStagedModelLogFragment(stagedModel) + " export started"));
    }

    public void onStagedModelExportSucceeded(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Staged model " + this.getStagedModelLogFragment(stagedModel) + " export succeeded"));
    }

    public void onStagedModelImportFailed(PortletDataContext portletDataContext, StagedModel stagedModel, Throwable throwable) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Staged model " + this.getStagedModelLogFragment(stagedModel) + " import failed"), throwable);
    }

    public void onStagedModelImportStarted(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Staged model " + this.getStagedModelLogFragment(stagedModel) + " import started"));
    }

    public void onStagedModelImportSucceeded(PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Staged model " + this.getStagedModelLogFragment(stagedModel) + " import succeeded"));
    }
}

