/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.lar.ThemeExporter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.model.adapter.StagedTheme;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class ThemeExporterImpl
implements ThemeExporter {
    private static final Log _log = LogFactoryUtil.getLog(ThemeExporterImpl.class);

    public void exportTheme(PortletDataContext portletDataContext, LayoutSet layoutSet) throws Exception {
        boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export theme settings " + exportThemeSettings));
        }
        if (!exportThemeSettings) {
            return;
        }
        Theme theme = layoutSet.getTheme();
        if (theme == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to export theme " + layoutSet.getThemeId()));
            }
            return;
        }
        StagedTheme stagedTheme = (StagedTheme)ModelAdapterUtil.adapt((Object)theme, Theme.class, StagedTheme.class);
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            Element layoutSetElement = portletDataContext.getExportDataElement((ClassedModel)layoutSet);
            portletDataContext.addReferenceElement((ClassedModel)layoutSet, layoutSetElement, (ClassedModel)stagedTheme, "dependency", true);
        }
        this._exportThemeSettings(portletDataContext, stagedTheme.getThemeId(), layoutSet.getColorSchemeId(), layoutSet.getCss());
    }

    public void exportTheme(PortletDataContext portletDataContext, LayoutSetBranch layoutSetBranch) throws Exception {
        boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export theme settings " + exportThemeSettings));
        }
        if (!exportThemeSettings) {
            return;
        }
        StagedTheme stagedTheme = (StagedTheme)ModelAdapterUtil.adapt((Object)layoutSetBranch.getTheme(), Theme.class, StagedTheme.class);
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            Element layoutSetBranchElement = portletDataContext.getExportDataElement((ClassedModel)layoutSetBranch);
            portletDataContext.addReferenceElement((ClassedModel)layoutSetBranch, layoutSetBranchElement, (ClassedModel)stagedTheme, "dependency", true);
        }
        this._exportThemeSettings(portletDataContext, stagedTheme.getThemeId(), layoutSetBranch.getColorSchemeId(), layoutSetBranch.getCss());
    }

    private void _exportThemeSettings(PortletDataContext portletDataContext, String themeId, String colorSchemeId, String css) throws Exception {
        Element exportDataRootElement = portletDataContext.getExportDataRootElement();
        Element headerElement = exportDataRootElement.element("header");
        headerElement.addAttribute("theme-id", themeId);
        headerElement.addAttribute("color-scheme-id", colorSchemeId);
        Element cssElement = headerElement.addElement("css");
        cssElement.addCDATA(css);
    }
}

