/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.lar;

import com.liferay.exportimport.internal.lar.LayoutCache;
import com.liferay.exportimport.internal.util.ExportImportPermissionUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.lar.PermissionImporter;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.NoSuchTeamException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=true, immediate=true)
public class PermissionImporterImpl
implements PermissionImporter {
    private static final Log _log = LogFactoryUtil.getLog(PermissionImporterImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    private CentralizedThreadLocal<LayoutCache> _layoutCacheThreadLocal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TeamLocalService _teamLocalService;

    public void checkRoles(long companyId, long groupId, long userId, Element portletElement) throws Exception {
        Element permissionsElement = portletElement.element("permissions");
        if (permissionsElement == null) {
            return;
        }
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            this._checkRole(companyId, groupId, userId, roleElement);
        }
    }

    public void clearCache() {
        this._layoutCacheThreadLocal.remove();
    }

    public void importPortletPermissions(long companyId, long groupId, long userId, Layout layout, Element portletElement, String portletId) throws Exception {
        Element permissionsElement = portletElement.element("permissions");
        if (layout != null && permissionsElement != null) {
            String resourceName = PortletIdCodec.decodePortletName((String)portletId);
            String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            this._importPermissions(companyId, groupId, userId, layout, resourceName, resourcePrimKey, permissionsElement);
        }
    }

    public void readPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext) + "/portlet-data-permissions.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List portletDataElements = rootElement.elements("portlet-data");
        for (Element portletDataElement : portletDataElements) {
            String resourceName = portletDataElement.attributeValue("resource-name");
            long resourcePK = GetterUtil.getLong((String)portletDataElement.attributeValue("resource-pk"));
            ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
            List permissionsElements = portletDataElement.elements("permissions");
            for (Element permissionsElement : permissionsElements) {
                String roleName = permissionsElement.attributeValue("role-name");
                String actions = permissionsElement.attributeValue("actions");
                KeyValuePair permission = new KeyValuePair(roleName, actions);
                permissions.add(permission);
            }
            portletDataContext.addPermissions(resourceName, resourcePK, permissions);
        }
    }

    @Activate
    protected void activate() {
        this._layoutCacheThreadLocal = new CentralizedThreadLocal(PermissionImporter.class.getName() + "._layoutCacheThreadLocal", LayoutCache::new);
    }

    private Role _checkRole(long companyId, long groupId, long userId, Element roleElement) throws Exception {
        String name = roleElement.attributeValue("name");
        Role role = null;
        if (ExportImportPermissionUtil.isTeamRoleName(name)) {
            name = name.substring("ROLE_TEAM_,*".length());
            String description = roleElement.attributeValue("description");
            Team team = null;
            try {
                team = this._teamLocalService.getTeam(groupId, name);
            }
            catch (NoSuchTeamException nste) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nste, (Throwable)nste);
                }
                team = this._teamLocalService.addTeam(userId, groupId, name, description, new ServiceContext());
            }
            role = this._roleLocalService.getTeamRole(companyId, team.getTeamId());
            return role;
        }
        String uuid = roleElement.attributeValue("uuid");
        LayoutCache layoutCache = (LayoutCache)this._layoutCacheThreadLocal.get();
        role = layoutCache.getUuidRole(companyId, uuid);
        if (role == null) {
            role = layoutCache.getNameRole(companyId, name);
        }
        if (role != null || MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return role;
        }
        String title = roleElement.attributeValue("title");
        Map titleMap = LocalizationUtil.getLocalizationMap((String)title);
        String description = roleElement.attributeValue("description");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((String)description);
        int type = GetterUtil.getInteger((String)roleElement.attributeValue("type"));
        String subtype = roleElement.attributeValue("subtype");
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUuid(uuid);
        role = this._roleLocalService.addRole(userId, null, 0L, name, titleMap, descriptionMap, type, subtype, serviceContext);
        return role;
    }

    private List<String> _getActions(Element element) {
        ArrayList<String> actions = new ArrayList<String>();
        List actionKeyElements = element.elements("action-key");
        for (Element actionKeyElement : actionKeyElements) {
            actions.add(actionKeyElement.getText());
        }
        return actions;
    }

    private void _importPermissions(long companyId, long groupId, long userId, Layout layout, String resourceName, String resourcePrimKey, Element permissionsElement) throws Exception {
        Map<Long, Set<String>> existingRoleIdsToActionIds = ExportImportPermissionUtil.getRoleIdsToActionIds(companyId, resourceName, resourcePrimKey);
        HashMap<Long, String[]> importedRoleIdsToActionIds = new HashMap<Long, String[]>();
        List roleElements = permissionsElement.elements("role");
        for (Element roleElement : roleElements) {
            String roleName;
            Group group;
            Role role = this._checkRole(companyId, groupId, userId, roleElement);
            if (role == null || !(group = this._groupLocalService.getGroup(groupId)).isLayoutPrototype() && !group.isLayoutSetPrototype() && layout.isPrivateLayout() && (roleName = role.getName()).equals("Guest")) continue;
            List<String> actions = this._getActions(roleElement);
            importedRoleIdsToActionIds.put(role.getRoleId(), actions.toArray(new String[actions.size()]));
        }
        Map<Long, String[]> roleIdsToActionIds = ExportImportPermissionUtil.mergeImportedPermissionsWithExistingPermissions(existingRoleIdsToActionIds, importedRoleIdsToActionIds);
        ExportImportPermissionUtil.updateResourcePermissions(companyId, groupId, resourceName, resourcePrimKey, roleIdsToActionIds);
    }
}

