/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"content.processor.type=LinksToLayouts"}, service={ExportImportContentProcessor.class})
public class LinksToLayoutsExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final Log _log = LogFactoryUtil.getLog(LinksToLayoutsExportImportContentProcessor.class);
    private static final Pattern _exportLinksToLayoutPattern = Pattern.compile("\\[([\\d]+)@(private(-group|-user)?|public)(@([\\d]+))?\\]");
    private static final Pattern _importLinksToLayoutPattern = Pattern.compile("\\[([\\d]+)@(private(-group|-user)?|public)@([\\d]+)(@([\\d]+))?\\]");
    @Reference
    private LayoutLocalService _layoutLocalService;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        return this.replaceExportLinksToLayouts(portletDataContext, stagedModel, content);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        return this.replaceImportLinksToLayouts(portletDataContext, content);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        this.validateLinksToLayoutsReferences(content);
    }

    protected String replaceExportLinksToLayouts(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = _exportLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            long layoutId = GetterUtil.getLong((String)matcher.group(1));
            String type = matcher.group(2);
            boolean privateLayout = type.startsWith("private");
            try {
                Layout layout = this._layoutLocalService.getLayout(portletDataContext.getScopeGroupId(), privateLayout, layoutId);
                String oldLinkToLayout = matcher.group(0);
                StringBundler sb = new StringBundler(3);
                sb.append(type);
                sb.append("@");
                sb.append(layout.getPlid());
                String newLinkToLayout = StringUtil.replace((String)oldLinkToLayout, (String)type, (String)sb.toString());
                oldLinksToLayout.add(oldLinkToLayout);
                newLinksToLayout.add(newLinkToLayout);
                Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)layout, "dependency", true);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled() && !_log.isWarnEnabled()) continue;
                String message = StringBundler.concat((String[])new String[]{"Unable to get layout with ID ", String.valueOf(layoutId), " in group ", String.valueOf(portletDataContext.getScopeGroupId())});
                ExportImportContentProcessorException eicpe = new ExportImportContentProcessorException(message, (Throwable)e);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)message, (Throwable)eicpe);
                    continue;
                }
                _log.warn((Object)message);
            }
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    protected String replaceImportLinksToLayouts(PortletDataContext portletDataContext, String content) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = _importLinksToLayoutPattern.matcher(content);
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        while (matcher.find()) {
            long oldLayoutId;
            long oldGroupId;
            long oldPlid = GetterUtil.getLong((String)matcher.group(4));
            Long newPlid = MapUtil.getLong((Map)layoutPlids, (long)oldPlid);
            long newGroupId = oldGroupId = GetterUtil.getLong((String)matcher.group(6));
            long newLayoutId = oldLayoutId = GetterUtil.getLong((String)matcher.group(1));
            Layout layout = this._layoutLocalService.fetchLayout(newPlid.longValue());
            if (layout != null) {
                newGroupId = layout.getGroupId();
                newLayoutId = layout.getLayoutId();
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get layout with plid " + oldPlid));
            }
            String oldLinkToLayout = matcher.group(0);
            String newLinkToLayout = StringUtil.replaceFirst((String)oldLinkToLayout, (String[])new String[]{"@" + oldPlid, String.valueOf(oldLayoutId)}, (String[])new String[]{"", String.valueOf(newLayoutId)});
            if (layout != null && layout.isPublicLayout() && layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                newLinkToLayout = StringUtil.replace((String)newLinkToLayout, (String)"private-group", (String)"public");
            }
            if (oldGroupId != 0L && oldGroupId != newGroupId) {
                newLinkToLayout = StringUtil.replaceLast((String)newLinkToLayout, (String)String.valueOf(oldGroupId), (String)String.valueOf(newGroupId));
            }
            oldLinksToLayout.add(oldLinkToLayout);
            newLinksToLayout.add(newLinkToLayout);
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    protected void validateLinksToLayoutsReferences(String content) throws PortalException {
        Matcher matcher = _exportLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            long layoutId;
            String type;
            boolean privateLayout;
            long groupId = GetterUtil.getLong((String)matcher.group(5));
            Layout layout = this._layoutLocalService.fetchLayout(groupId, privateLayout = (type = matcher.group(2)).startsWith("private"), layoutId = GetterUtil.getLong((String)matcher.group(1)));
            if (layout != null) continue;
            ExportImportContentValidationException eicve = new ExportImportContentValidationException(LinksToLayoutsExportImportContentProcessor.class.getName());
            HashMap<String, String> layoutReferenceParameters = new HashMap<String, String>();
            layoutReferenceParameters.put("groupId", String.valueOf(groupId));
            layoutReferenceParameters.put("layoutId", String.valueOf(layoutId));
            layoutReferenceParameters.put("privateLayout", String.valueOf(privateLayout));
            eicve.setLayoutReferenceParameters(layoutReferenceParameters);
            eicve.setType(3);
            throw eicve;
        }
    }
}

