/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.internal.content.processor;

import com.liferay.exportimport.configuration.ExportImportServiceConfiguration;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.exception.ExportImportContentProcessorException;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.staging.StagingGroupHelper;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.exportimport.configuration.ExportImportServiceConfiguration"}, immediate=true, property={"content.processor.type=LayoutReferences"}, service={ExportImportContentProcessor.class})
public class LayoutReferencesExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _DATA_HANDLER_COMPANY_SECURE_URL = "@data_handler_company_secure_url@";
    private static final String _DATA_HANDLER_COMPANY_URL = "@data_handler_company_url@";
    private static final String _DATA_HANDLER_GROUP_FRIENDLY_URL = "@data_handler_group_friendly_url@";
    private static final String _DATA_HANDLER_PATH_CONTEXT = "@data_handler_path_context@";
    private static final String _DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING = "@data_handler_private_group_servlet_mapping@";
    private static final String _DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL = "@data_handler_private_layout_set_secure_url@";
    private static final String _DATA_HANDLER_PRIVATE_LAYOUT_SET_URL = "@data_handler_private_layout_set_url@";
    private static final String _DATA_HANDLER_PRIVATE_USER_SERVLET_MAPPING = "@data_handler_private_user_servlet_mapping@";
    private static final String _DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL = "@data_handler_public_layout_set_secure_url@";
    private static final String _DATA_HANDLER_PUBLIC_LAYOUT_SET_URL = "@data_handler_public_layout_set_url@";
    private static final String _DATA_HANDLER_PUBLIC_SERVLET_MAPPING = "@data_handler_public_servlet_mapping@";
    private static final String _DATA_HANDLER_SITE_ADMIN_URL = "@data_handler_site_admin_url@";
    private static final char[] _LAYOUT_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '#', '?', '\"', ' '};
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.private.group.servlet.mapping") + "/";
    private static final String _PRIVATE_USER_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.private.user.servlet.mapping") + "/";
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = PropsUtil.get((String)"layout.friendly.url.public.servlet.mapping") + "/";
    private static final Log _log = LogFactoryUtil.getLog(LayoutReferencesExportImportContentProcessor.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    private ExportImportServiceConfiguration _exportImportServiceConfiguration;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private LayoutFriendlyURLLocalService _layoutFriendlyURLLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        return this.replaceExportLayoutReferences(portletDataContext, stagedModel, content);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        return this.replaceImportLayoutReferences(portletDataContext, content);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        this.validateLayoutReferences(groupId, content);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._exportImportServiceConfiguration = (ExportImportServiceConfiguration)ConfigurableUtil.createConfigurable(ExportImportServiceConfiguration.class, properties);
    }

    protected String replaceExportHostname(Group group, String url, StringBundler urlSB) throws PortalException {
        if (!this._http.hasProtocol(url)) {
            return url;
        }
        boolean secure = this._http.isSecure(url);
        int serverPort = this._portal.getPortalServerPort(secure);
        if (serverPort == -1) {
            return url;
        }
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        String publicLayoutSetVirtualHostname = publicLayoutSet.getVirtualHostname();
        String portalUrl = "";
        if (Validator.isNotNull((String)publicLayoutSetVirtualHostname) && url.startsWith(portalUrl = this._portal.getPortalURL(publicLayoutSetVirtualHostname, serverPort, secure))) {
            if (secure) {
                urlSB.append(_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL);
            } else {
                urlSB.append(_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL);
            }
            return url.substring(portalUrl.length());
        }
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        String privateLayoutSetVirtualHostname = privateLayoutSet.getVirtualHostname();
        if (Validator.isNotNull((String)privateLayoutSetVirtualHostname) && url.startsWith(portalUrl = this._portal.getPortalURL(privateLayoutSetVirtualHostname, serverPort, secure))) {
            if (secure) {
                urlSB.append(_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL);
            } else {
                urlSB.append(_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL);
            }
            return url.substring(portalUrl.length());
        }
        Company company = this._companyLocalService.getCompany(group.getCompanyId());
        String companyVirtualHostname = company.getVirtualHostname();
        if (Validator.isNotNull((String)companyVirtualHostname) && url.startsWith(portalUrl = this._portal.getPortalURL(companyVirtualHostname, serverPort, secure))) {
            if (secure) {
                urlSB.append(_DATA_HANDLER_COMPANY_SECURE_URL);
            } else {
                urlSB.append(_DATA_HANDLER_COMPANY_URL);
            }
            return url.substring(portalUrl.length());
        }
        portalUrl = this._portal.getPortalURL("localhost", serverPort, secure);
        if (url.startsWith(portalUrl)) {
            return url.substring(portalUrl.length());
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String replaceExportLayoutReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        StringBundler hostNameSB = new StringBundler(2);
        content = this.replaceExportHostname(group, content, hostNameSB);
        if (hostNameSB.index() > 0) {
            hostNameSB.append(content);
            content = hostNameSB.toString();
        }
        StringBuilder sb = new StringBuilder(content);
        String[] patterns = new String[]{"href=", "[["};
        int beginPos = -1;
        int endPos = content.length();
        int offset = 0;
        while (true) {
            if (beginPos > -1) {
                endPos = beginPos - 1;
            }
            if ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) == -1) return sb.toString();
            if (content.startsWith("href=", beginPos)) {
                offset = 5;
                char c = content.charAt(beginPos + offset);
                if (c == '\'' || c == '\"') {
                    ++offset;
                }
            } else if (content.charAt(beginPos) == '[') {
                offset = 2;
            }
            if ((endPos = StringUtil.indexOfAny((String)content, (char[])_LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos)) == -1) continue;
            String url = content.substring(beginPos + offset, endPos);
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            StringBundler urlSB = new StringBundler(6);
            try {
                if (!(url = this.replaceExportHostname(group, url, urlSB)).startsWith("/")) continue;
                String pathContext = this._portal.getPathContext();
                if (pathContext.length() > 1) {
                    if (!url.startsWith(pathContext)) continue;
                    urlSB.append(_DATA_HANDLER_PATH_CONTEXT);
                    url = url.substring(pathContext.length());
                    return url;
                }
            }
            catch (Exception e) {
                if (e instanceof NoSuchLayoutException && !this._exportImportServiceConfiguration.validateLayoutReferences()) continue;
                StringBundler exceptionSB = new StringBundler(6);
                exceptionSB.append("Unable to process layout URL ");
                exceptionSB.append(url);
                exceptionSB.append(" for staged model ");
                exceptionSB.append(stagedModel.getModelClassName());
                exceptionSB.append(" with primary key ");
                exceptionSB.append((Object)stagedModel.getPrimaryKeyObj());
                ExportImportContentProcessorException eicpe = new ExportImportContentProcessorException(exceptionSB.toString(), (Throwable)e);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)exceptionSB.toString(), (Throwable)eicpe);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)exceptionSB.toString());
                continue;
            }
            finally {
                if (urlSB.length() > 0) {
                    urlSB.append(url);
                    url = urlSB.toString();
                }
                sb.replace(beginPos + offset, endPos, url);
                continue;
            }
            break;
        }
    }

    protected String replaceImportLayoutReferences(PortletDataContext portletDataContext, String content) throws Exception {
        int groupFriendlyUrlPos;
        String companyPortalURL = "";
        String privateLayoutSetPortalURL = "";
        String publicLayoutSetPortalURL = "";
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        Company company = this._companyLocalService.getCompany(group.getCompanyId());
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        int serverPort = this._portal.getPortalServerPort(false);
        if (serverPort != -1) {
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companyPortalURL = this._portal.getPortalURL(company.getVirtualHostname(), serverPort, false);
            }
            privateLayoutSetPortalURL = Validator.isNotNull((String)privateLayoutSet.getVirtualHostname()) ? this._portal.getPortalURL(privateLayoutSet.getVirtualHostname(), serverPort, false) : companyPortalURL;
            publicLayoutSetPortalURL = Validator.isNotNull((String)publicLayoutSet.getVirtualHostname()) ? this._portal.getPortalURL(publicLayoutSet.getVirtualHostname(), serverPort, false) : companyPortalURL;
        }
        int secureSecurePort = this._portal.getPortalServerPort(true);
        String companySecurePortalURL = "";
        String privateLayoutSetSecurePortalURL = "";
        String publicLayoutSetSecurePortalURL = "";
        if (secureSecurePort != -1) {
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companySecurePortalURL = this._portal.getPortalURL(company.getVirtualHostname(), secureSecurePort, true);
            }
            if (Validator.isNotNull((String)privateLayoutSet.getVirtualHostname())) {
                privateLayoutSetSecurePortalURL = this._portal.getPortalURL(privateLayoutSet.getVirtualHostname(), secureSecurePort, true);
            }
            if (Validator.isNotNull((String)publicLayoutSet.getVirtualHostname())) {
                publicLayoutSetSecurePortalURL = this._portal.getPortalURL(publicLayoutSet.getVirtualHostname(), secureSecurePort, true);
            }
        }
        StringBundler sb = new StringBundler(3);
        sb.append("/~");
        sb.append("/control_panel");
        sb.append(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_COMPANY_SECURE_URL, (String)companySecurePortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_COMPANY_URL, (String)companyPortalURL);
        while ((groupFriendlyUrlPos = content.indexOf(_DATA_HANDLER_GROUP_FRIENDLY_URL)) != -1) {
            int groupUuidPos = groupFriendlyUrlPos + _DATA_HANDLER_GROUP_FRIENDLY_URL.length();
            int endIndex = -1;
            if (content.charAt(groupUuidPos) == '@') {
                endIndex = content.indexOf("@", groupUuidPos + 1);
            }
            if (endIndex < groupUuidPos + 1) {
                content = StringUtil.replaceFirst((String)content, (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)"", (int)groupFriendlyUrlPos);
                continue;
            }
            String groupUuid = content.substring(groupUuidPos + 1, endIndex);
            Group groupFriendlyUrlGroup = this._groupLocalService.fetchGroupByUuidAndCompanyId(groupUuid, portletDataContext.getCompanyId());
            if (groupFriendlyUrlGroup == null) {
                groupFriendlyUrlGroup = this._groupLocalService.fetchFriendlyURLGroup(portletDataContext.getCompanyId(), groupUuid);
            }
            if (groupFriendlyUrlGroup == null) {
                content = StringUtil.replaceFirst((String)content, (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)group.getFriendlyURL(), (int)groupFriendlyUrlPos);
                content = StringUtil.replaceFirst((String)content, (String)("@" + groupUuid + "@"), (String)"", (int)groupFriendlyUrlPos);
                continue;
            }
            content = StringUtil.replaceFirst((String)content, (String)_DATA_HANDLER_GROUP_FRIENDLY_URL, (String)"", (int)groupFriendlyUrlPos);
            content = StringUtil.replaceFirst((String)content, (String)("@" + groupUuid + "@"), (String)groupFriendlyUrlGroup.getFriendlyURL(), (int)groupFriendlyUrlPos);
        }
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PATH_CONTEXT, (String)this._portal.getPathContext());
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_GROUP_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL, (String)privateLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL, (String)privateLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PRIVATE_USER_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL, (String)publicLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL, (String)publicLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_PUBLIC_SERVLET_MAPPING, (String)PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)_DATA_HANDLER_SITE_ADMIN_URL, (String)sb.toString());
        return content;
    }

    protected void validateLayoutReferences(long groupId, String content) throws PortalException {
        if (!this._exportImportServiceConfiguration.validateLayoutReferences()) {
            return;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        String[] patterns = new String[]{"href=", "[["};
        int beginPos = -1;
        int endPos = content.length();
        int offset = 0;
        while (true) {
            Group urlGroup;
            String urlWithoutLocale;
            StringBundler urlSB;
            if (beginPos > -1) {
                endPos = beginPos - 1;
            }
            if ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) == -1) break;
            if (content.startsWith("href=", beginPos)) {
                offset = 5;
                char c = content.charAt(beginPos + offset);
                if (c == '\'' || c == '\"') {
                    ++offset;
                }
            } else if (content.charAt(beginPos) == '[') {
                offset = 2;
            }
            if ((endPos = StringUtil.indexOfAny((String)content, (char[])_LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos)) == -1) continue;
            String url = content.substring(beginPos + offset, endPos);
            if ((endPos = url.indexOf("/-/")) != -1) {
                url = url.substring(0, endPos);
            }
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            if (!(url = this.replaceExportHostname(group, url, urlSB = new StringBundler(1))).startsWith("/")) continue;
            String pathContext = this._portal.getPathContext();
            if (pathContext.length() > 1) {
                if (!url.startsWith(pathContext)) continue;
                url = url.substring(pathContext.length());
            }
            if (!url.startsWith("/")) continue;
            int pos = url.indexOf("/", 1);
            String localePath = "";
            Locale locale = null;
            if (pos != -1) {
                localePath = url.substring(0, pos);
                locale = LocaleUtil.fromLanguageId((String)localePath.substring(1), (boolean)true, (boolean)false);
            }
            if (locale != null && ((urlWithoutLocale = url.substring(localePath.length())).startsWith(_PRIVATE_GROUP_SERVLET_MAPPING) || urlWithoutLocale.startsWith(_PRIVATE_USER_SERVLET_MAPPING) || urlWithoutLocale.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING))) {
                url = urlWithoutLocale;
            }
            boolean privateLayout = false;
            if (url.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING)) {
                url = url.substring(_PRIVATE_GROUP_SERVLET_MAPPING.length() - 1);
                privateLayout = true;
            } else if (url.startsWith(_PRIVATE_USER_SERVLET_MAPPING)) {
                url = url.substring(_PRIVATE_USER_SERVLET_MAPPING.length() - 1);
                privateLayout = true;
            } else if (url.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING)) {
                url = url.substring(_PUBLIC_GROUP_SERVLET_MAPPING.length() - 1);
            } else {
                String urlSBString = urlSB.toString();
                LayoutSet layoutSet = null;
                if (urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PUBLIC_LAYOUT_SET_URL)) {
                    layoutSet = group.getPublicLayoutSet();
                } else if (urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_SECURE_URL) || urlSBString.contains(_DATA_HANDLER_PRIVATE_LAYOUT_SET_URL)) {
                    layoutSet = group.getPrivateLayoutSet();
                }
                if (layoutSet == null) continue;
                privateLayout = layoutSet.isPrivateLayout();
            }
            Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, url);
            if (layout != null) continue;
            String siteAdminURL = "/control_panel" + PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL;
            if (url.endsWith("/~" + siteAdminURL)) {
                url = url.substring(url.indexOf(siteAdminURL));
            }
            pos = url.indexOf("/", 1);
            String groupFriendlyURL = url;
            if (pos != -1) {
                groupFriendlyURL = url.substring(0, pos);
            }
            if ((urlGroup = this._groupLocalService.fetchFriendlyURLGroup(group.getCompanyId(), groupFriendlyURL)) == null) {
                ExportImportContentValidationException eicve = new ExportImportContentValidationException(LayoutReferencesExportImportContentProcessor.class.getName());
                eicve.setGroupFriendlyURL(groupFriendlyURL);
                eicve.setLayoutURL(url);
                eicve.setType(2);
                throw eicve;
            }
            if (pos == -1) continue;
            url = url.substring(pos);
            try {
                this._layoutLocalService.getFriendlyURLLayout(urlGroup.getGroupId(), privateLayout, url);
            }
            catch (NoSuchLayoutException nsle) {
                ExportImportContentValidationException eicve = new ExportImportContentValidationException(LayoutReferencesExportImportContentProcessor.class.getName(), (Throwable)nsle);
                eicve.setLayoutURL(url);
                eicve.setType(4);
                throw eicve;
            }
        }
    }
}

