/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.lifecycle;

import aQute.bnd.annotation.ProviderType;

import com.liferay.exportimport.kernel.lifecycle.EventAwareExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListener;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleListenerFactory;
import com.liferay.exportimport.kernel.lifecycle.ProcessAwareExportImportLifecycleListener;

import org.osgi.service.component.annotations.Component;

/**
 * @author Daniel Kocsis
 */
@Component(
	immediate = true, service = ExportImportLifecycleListenerFactory.class
)
@ProviderType
public class DefaultExportImportLifecycleListernerFactory
	implements ExportImportLifecycleListenerFactory {

	@Override
	public ExportImportLifecycleListener create(
		EventAwareExportImportLifecycleListener lifecycleListener) {

		return new DefaultEventAwareExportImportLifecycleListener(
			lifecycleListener);
	}

	@Override
	public ExportImportLifecycleListener create(
		ProcessAwareExportImportLifecycleListener lifecycleListener) {

		return new DefaultProcessAwareExportImportLifecycleListener(
			lifecycleListener);
	}

}