/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.xstream.converter;

import com.liferay.exportimport.kernel.xstream.BaseXStreamConverter;
import com.liferay.exportimport.kernel.xstream.XStreamHierarchicalStreamReader;
import com.liferay.exportimport.kernel.xstream.XStreamHierarchicalStreamWriter;
import com.liferay.exportimport.kernel.xstream.XStreamMarshallingContext;
import com.liferay.exportimport.kernel.xstream.XStreamUnmarshallingContext;

import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;

import java.sql.Timestamp;

import java.util.List;

/**
 * @author Rodrigo Paulino
 */
public class TimestampConverter extends BaseXStreamConverter {

	public TimestampConverter() {
		_converter = new SqlTimestampConverter();
	}

	@Override
	public boolean canConvert(Class<?> clazz) {
		Class<?> superClass = clazz.getSuperclass();

		if (clazz.equals(Timestamp.class) ||
			((superClass != null) && superClass.equals(Timestamp.class))) {

			return true;
		}

		return false;
	}

	@Override
	public void marshal(
			Object object, XStreamHierarchicalStreamWriter writer,
			XStreamMarshallingContext xStreamMarshallingContext)
		throws Exception {

		writer.setValue(_converter.toString(object));
	}

	@Override
	public Object unmarshal(
			XStreamHierarchicalStreamReader xStreamHierarchicalStreamReader,
			XStreamUnmarshallingContext xStreamUnmarshallingContext)
		throws Exception {

		return _converter.fromString(
			xStreamHierarchicalStreamReader.getValue());
	}

	@Override
	protected List<String> getFields() {
		return null;
	}

	private final SqlTimestampConverter _converter;

}