/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.xstream;

import aQute.bnd.annotation.ProviderType;

import com.liferay.exportimport.kernel.xstream.XStreamConverter;
import com.liferay.exportimport.kernel.xstream.XStreamUnmarshallingContext;

import com.thoughtworks.xstream.converters.UnmarshallingContext;

/**
 * @author Daniel Kocsis
 */
@ProviderType
public class XStreamUnmarshallingContextAdapter
	implements XStreamUnmarshallingContext {

	public XStreamUnmarshallingContextAdapter(
		UnmarshallingContext unmarshallingContext) {

		_unmarshallingContext = unmarshallingContext;
	}

	@Override
	public void addCompletionCallback(Runnable work, int priority) {
		_unmarshallingContext.addCompletionCallback(work, priority);
	}

	@Override
	public Object convertAnother(Object object, Class<?> clazz) {
		return _unmarshallingContext.convertAnother(object, clazz);
	}

	@Override
	public Object convertAnother(
		Object object, Class<?> clazz, XStreamConverter xStreamConverter) {

		return _unmarshallingContext.convertAnother(
			object, clazz, new ConverterAdapter(xStreamConverter));
	}

	@Override
	public Object currentObject() {
		return _unmarshallingContext.currentObject();
	}

	@Override
	public Object getRequiredType() {
		return _unmarshallingContext.getRequiredType();
	}

	private final UnmarshallingContext _unmarshallingContext;

}