/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.xstream;

import aQute.bnd.annotation.ProviderType;

import com.liferay.portal.kernel.model.StagedModel;

import com.thoughtworks.xstream.security.TypePermission;

/**
 * @author Mate Thurzo
 */
@ProviderType
public class XStreamStagedModelTypeHierarchyPermission
	implements TypePermission {

	public static final TypePermission STAGED_MODELS =
		new XStreamStagedModelTypeHierarchyPermission();

	@Override
	public boolean allows(Class type) {
		if (type == null) {
			return false;
		}

		return StagedModel.class.isAssignableFrom(type);
	}

}