/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.xstream;

import aQute.bnd.annotation.ProviderType;

import com.liferay.exportimport.kernel.xstream.XStreamHierarchicalStreamReader;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import java.util.Iterator;

/**
 * @author Daniel Kocsis
 */
@ProviderType
public class XStreamHierarchicalStreamReaderAdapter
	implements XStreamHierarchicalStreamReader {

	public XStreamHierarchicalStreamReaderAdapter(
		HierarchicalStreamReader hierarchicalStreamReader) {

		_hierarchicalStreamReader = hierarchicalStreamReader;
	}

	@Override
	public void close() {
		_hierarchicalStreamReader.close();
	}

	@Override
	public String getAttribute(int index) {
		return _hierarchicalStreamReader.getAttribute(index);
	}

	@Override
	public String getAttribute(String name) {
		return _hierarchicalStreamReader.getAttribute(name);
	}

	@Override
	public int getAttributeCount() {
		return _hierarchicalStreamReader.getAttributeCount();
	}

	@Override
	public String getAttributeName(int index) {
		return _hierarchicalStreamReader.getAttributeName(index);
	}

	@Override
	public Iterator<String> getAttributeNames() {
		return _hierarchicalStreamReader.getAttributeNames();
	}

	@Override
	public String getNodeName() {
		return _hierarchicalStreamReader.getNodeName();
	}

	@Override
	public String getValue() {
		return _hierarchicalStreamReader.getValue();
	}

	@Override
	public boolean hasMoreChildren() {
		return _hierarchicalStreamReader.hasMoreChildren();
	}

	@Override
	public void moveDown() {
		_hierarchicalStreamReader.moveDown();
	}

	@Override
	public void moveUp() {
		_hierarchicalStreamReader.moveUp();
	}

	@Override
	public XStreamHierarchicalStreamReader underlyingReader() {
		return new XStreamHierarchicalStreamReaderAdapter(
			_hierarchicalStreamReader.underlyingReader());
	}

	private final HierarchicalStreamReader _hierarchicalStreamReader;

}