/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.xstream;

import aQute.bnd.annotation.ProviderType;

import com.liferay.exportimport.kernel.xstream.XStreamConverter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * @author Daniel Kocsis
 */
@ProviderType
public class ConverterAdapter implements Converter {

	public ConverterAdapter(XStreamConverter xStreamConverter) {
		_xStreamConverter = xStreamConverter;
	}

	@Override
	public boolean canConvert(@SuppressWarnings("rawtypes") Class clazz) {
		return _xStreamConverter.canConvert(clazz);
	}

	@Override
	public void marshal(
		Object object, HierarchicalStreamWriter hierarchicalStreamWriter,
		MarshallingContext marshallingContext) {

		try {
			_xStreamConverter.marshal(
				object,
				new XStreamHierarchicalStreamWriterAdapter(
					hierarchicalStreamWriter),
				new XStreamMarshallingContextAdapter(marshallingContext));
		}
		catch (Exception e) {
			_log.error("Unable to marshal object", e);
		}
	}

	@Override
	public Object unmarshal(
		HierarchicalStreamReader hierarchicalStreamReader,
		UnmarshallingContext unmarshallingContext) {

		try {
			return _xStreamConverter.unmarshal(
				new XStreamHierarchicalStreamReaderAdapter(
					hierarchicalStreamReader),
				new XStreamUnmarshallingContextAdapter(unmarshallingContext));
		}
		catch (Exception e) {
			_log.error("Unable to un-marshal object", e);

			return null;
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		ConverterAdapter.class);

	private final XStreamConverter _xStreamConverter;

}