/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.upgrade.v1_0_0;

import com.liferay.exportimport.kernel.background.task.BackgroundTaskExecutorNames;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;

/**
 * @author Daniel Kocsis
 */
public class UpgradeBackgroundTaskExecutorClassNames extends UpgradeProcess {

	protected void deleteBackgroundTasks() throws Exception {
		try (LoggingTimer loggingTimer = new LoggingTimer()) {
			runSQL(
				"delete from BackgroundTask where taskExecutorClassName = '" +
					"com.liferay.portal.lar.backgroundtask." +
						"StagingIndexingBackgroundTaskExecutor'");
		}
	}

	@Override
	protected void doUpgrade() throws Exception {
		String[][] renameTaskExecutorClassNamesArray =
			getRenameTaskExecutorClassNames();

		for (String[] renameTaskExecutorClassName :
				renameTaskExecutorClassNamesArray) {

			StringBundler sb = new StringBundler(5);

			sb.append("update BackgroundTask set taskExecutorClassName = '");
			sb.append(renameTaskExecutorClassName[1]);
			sb.append("' where taskExecutorClassName = '");
			sb.append(renameTaskExecutorClassName[0]);
			sb.append("'");

			runSQL(sb.toString());
		}

		deleteBackgroundTasks();
	}

	protected String[][] getRenameTaskExecutorClassNames() {
		try (LoggingTimer loggingTimer = new LoggingTimer()) {
			return new String[][] {
				new String[] {
					"com.liferay.portal.lar.backgroundtask." +
						"LayoutExportBackgroundTaskExecutor",
					BackgroundTaskExecutorNames.
						LAYOUT_EXPORT_BACKGROUND_TASK_EXECUTOR
				},
				new String[] {
					"com.liferay.portal.lar.backgroundtask." +
						"LayoutImportBackgroundTaskExecutor",
					BackgroundTaskExecutorNames.
						LAYOUT_IMPORT_BACKGROUND_TASK_EXECUTOR
				},
				new String[] {
					"com.liferay.portal.lar.backgroundtask." +
						"LayoutRemoteStagingBackgroundTaskExecutor",
					BackgroundTaskExecutorNames.
						LAYOUT_REMOTE_STAGING_BACKGROUND_TASK_EXECUTOR
				},
				new String[] {
					"com.liferay.portal.lar.backgroundtask." +
						"LayoutStagingBackgroundTaskExecutor",
					BackgroundTaskExecutorNames.
						LAYOUT_STAGING_BACKGROUND_TASK_EXECUTOR
				},
				new String[] {
					"com.liferay.portal.lar.backgroundtask." +
						"PortletExportBackgroundTaskExecutor",
					BackgroundTaskExecutorNames.
						PORTLET_EXPORT_BACKGROUND_TASK_EXECUTOR
				},
				new String[] {
					"com.liferay.portal.lar.backgroundtask." +
						"PortletImportBackgroundTaskExecutor",
					BackgroundTaskExecutorNames.
						PORTLET_IMPORT_BACKGROUND_TASK_EXECUTOR
				},
				new String[] {
					"com.liferay.portal.lar.backgroundtask." +
						"PortletStagingBackgroundTaskExecutor",
					BackgroundTaskExecutorNames.
						PORTLET_STAGING_BACKGROUND_TASK_EXECUTOR
				}
			};
		}
	}

}