/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.exportimport.internal.lar;

import aQute.bnd.annotation.ProviderType;

import com.liferay.exportimport.kernel.exception.ExportImportRuntimeException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Daniel Kocsis
 */
@ProviderType
public class ExportImportProcessCallbackUtil {

	/**
	 * @deprecated As of Judson (7.1.x)
	 */
	@Deprecated
	public static List<Callable<?>> popCallbackList() {
		return Collections.<Callable<?>>emptyList();
	}

	public static List<Callable<?>> popCallbackList(String processId) {
		List<List<Callable<?>>> callbackListList = _callbackListListMap.get(
			processId);

		if (callbackListList == null) {
			return Collections.<Callable<?>>emptyList();
		}

		return callbackListList.remove(callbackListList.size() - 1);
	}

	/**
	 * @deprecated As of Judson (7.1.x)
	 */
	@Deprecated
	public static void pushCallbackList() {
	}

	public static void pushCallbackList(String processId) {
		List<List<Callable<?>>> callbackListList = _callbackListListMap.get(
			processId);

		if (callbackListList == null) {
			callbackListList = new ArrayList<>();

			_callbackListListMap.put(processId, callbackListList);
		}

		callbackListList.add(Collections.<Callable<?>>emptyList());
	}

	/**
	 * @deprecated As of Judson (7.1.x)
	 */
	@Deprecated
	public static void registerCallback(Callable<?> callable) {
	}

	public static void registerCallback(
		String processId, Callable<?> callable) {

		List<List<Callable<?>>> callbackListList = _callbackListListMap.get(
			processId);

		if (ListUtil.isEmpty(callbackListList)) {

			// Not within a process boundary, ignore the callback

			if (_log.isWarnEnabled()) {
				_log.warn(
					"Calling export import process callback immediately, " +
						"because there is no active process with ID " +
							processId);
			}

			try {
				callable.call();
			}
			catch (Exception e) {
				ExportImportRuntimeException eire =
					new ExportImportRuntimeException(
						e.getLocalizedMessage(), e);

				Class<?> clazz = callable.getClass();

				eire.setClassName(clazz.getName());

				throw eire;
			}

			return;
		}

		int index = callbackListList.size() - 1;

		List<Callable<?>> callableList = callbackListList.get(index);

		if (callableList == Collections.<Callable<?>>emptyList()) {
			callableList = new ArrayList<>();

			callbackListList.set(index, callableList);
		}

		callableList.add(callable);
	}

	private static final Log _log = LogFactoryUtil.getLog(
		ExportImportProcessCallbackUtil.class);

	private static final Map<String, List<List<Callable<?>>>>
		_callbackListListMap = new ConcurrentHashMap();

}