/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.background.task;

import com.liferay.exportimport.background.task.BaseStagingBackgroundTaskExecutor;
import com.liferay.exportimport.background.task.LayoutStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportLocalServiceUtil;
import com.liferay.exportimport.kernel.service.StagingLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class LayoutStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(LayoutStagingBackgroundTaskExecutor.class);

    public LayoutStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskExecutor clone() {
        LayoutStagingBackgroundTaskExecutor layoutStagingBackgroundTaskExecutor = new LayoutStagingBackgroundTaskExecutor();
        layoutStagingBackgroundTaskExecutor.setBackgroundTaskStatusMessageTranslator(this.getBackgroundTaskStatusMessageTranslator());
        layoutStagingBackgroundTaskExecutor.setIsolationLevel(this.getIsolationLevel());
        return layoutStagingBackgroundTaskExecutor;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.getExportImportConfiguration(backgroundTask);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        this.clearBackgroundTaskStatus(backgroundTask);
        File file = null;
        MissingReferences missingReferences = null;
        try {
            Group stagingGroup;
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)true);
            Group targetGroup = GroupLocalServiceUtil.fetchGroup((long)targetGroupId);
            if (targetGroup == null) {
                throw new NoSuchGroupException("Target group does not exists with the primary key " + targetGroupId);
            }
            Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
            if (sourceGroup.hasStagingGroup() && (stagingGroup = sourceGroup.getStagingGroup()).getGroupId() == targetGroupId) {
                ExportImportThreadLocal.setInitialLayoutStagingInProcess((boolean)true);
                TrashEntryLocalServiceUtil.deleteEntries((long)sourceGroupId, (boolean)true);
            }
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)15, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
            boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            this.initThreadLocals(sourceGroupId, privateLayout);
            file = ExportImportLocalServiceUtil.exportLayoutsAsFile((ExportImportConfiguration)exportImportConfiguration);
            this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
            missingReferences = (MissingReferences)TransactionInvokerUtil.invoke((TransactionConfig)transactionConfig, (Callable)new LayoutStagingImportCallable(backgroundTask.getBackgroundTaskId(), exportImportConfiguration, file, sourceGroupId, targetGroupId, userId));
            ExportImportThreadLocal.setInitialLayoutStagingInProcess((boolean)false);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)14, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration});
        }
        catch (Throwable t) {
            ExportImportThreadLocal.setInitialLayoutStagingInProcess((boolean)false);
            ExportImportThreadLocal.setLayoutStagingInProcess((boolean)false);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent((int)13, (int)32, (String)String.valueOf(exportImportConfiguration.getExportImportConfigurationId()), (Serializable[])new Serializable[]{exportImportConfiguration, t});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)t, t);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to publish layout: " + t.getMessage()));
            }
            Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
            if (sourceGroup.hasStagingGroup()) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setUserId(userId);
                StagingLocalServiceUtil.disableStaging((Group)sourceGroup, (ServiceContext)serviceContext);
                List queuedBackgroundTasks = BackgroundTaskManagerUtil.getBackgroundTasks((long)sourceGroupId, (String)LayoutStagingBackgroundTaskExecutor.class.getName(), (int)4);
                for (BackgroundTask queuedBackgroundTask : queuedBackgroundTasks) {
                    BackgroundTaskManagerUtil.amendBackgroundTask((long)queuedBackgroundTask.getBackgroundTaskId(), null, (int)5, (ServiceContext)new ServiceContext());
                }
            }
            this.deleteTempLarOnFailure(file);
            throw new SystemException(t);
        }
        this.deleteTempLarOnSuccess(file);
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    protected void initLayoutSetBranches(long userId, long sourceGroupId, long targetGroupId) throws PortalException {
        Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
        if (!sourceGroup.hasStagingGroup()) {
            return;
        }
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)false, (boolean)true);
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)true, (boolean)true);
        UnicodeProperties typeSettingsProperties = sourceGroup.getTypeSettingsProperties();
        boolean branchingPrivate = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate"));
        boolean branchingPublic = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(userId);
        StagingLocalServiceUtil.checkDefaultLayoutSetBranches((long)userId, (Group)sourceGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (boolean)false, (ServiceContext)serviceContext);
    }

    private class LayoutStagingImportCallable
    implements Callable<MissingReferences> {
        private final long _backgroundTaskId;
        private final ExportImportConfiguration _exportImportConfiguration;
        private final File _file;
        private final long _sourceGroupId;
        private final long _targetGroupId;
        private final long _userId;

        public LayoutStagingImportCallable(long backgroundTaskId, ExportImportConfiguration exportImportConfiguration, File file, long sourceGroupId, long targetGroupId, long userId) {
            this._backgroundTaskId = backgroundTaskId;
            this._exportImportConfiguration = exportImportConfiguration;
            this._file = file;
            this._sourceGroupId = sourceGroupId;
            this._targetGroupId = targetGroupId;
            this._userId = userId;
        }

        @Override
        public MissingReferences call() throws PortalException {
            ExportImportLocalServiceUtil.importLayoutsDataDeletions((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            MissingReferences missingReferences = ExportImportLocalServiceUtil.validateImportLayoutsFile((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            LayoutStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTaskId, "validated");
            ExportImportLocalServiceUtil.importLayouts((ExportImportConfiguration)this._exportImportConfiguration, (File)this._file);
            LayoutStagingBackgroundTaskExecutor.this.initLayoutSetBranches(this._userId, this._sourceGroupId, this._targetGroupId);
            return missingReferences;
        }
    }
}

