/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.exportimport.internal.staged.model.repository;

import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.model.adapter.StagedExpandoTable;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.model.adapter.util.ModelAdapterUtil;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.expando.model.adapter.StagedExpandoTable"}, service={StagedModelRepository.class})
public class StagedExpandoTableStagedModelRepository
implements StagedModelRepository<StagedExpandoTable> {
    private static final Log _log = LogFactoryUtil.getLog(StagedExpandoTableStagedModelRepository.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private Portal _portal;

    public StagedExpandoTable addStagedModel(PortletDataContext portletDataContext, StagedExpandoTable stagedExpandoTable) throws PortalException {
        ExpandoTable expandoTable = this._expandoTableLocalService.addTable(portletDataContext.getCompanyId(), stagedExpandoTable.getClassName(), stagedExpandoTable.getName());
        return (StagedExpandoTable)ModelAdapterUtil.adapt((Object)expandoTable, ExpandoTable.class, StagedExpandoTable.class);
    }

    public void deleteStagedModel(StagedExpandoTable stagedExpandoTable) throws PortalException {
        this._expandoTableLocalService.deleteTable((ExpandoTable)stagedExpandoTable);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        List expandoTables = this._expandoTableLocalService.getExpandoTables(-1, -1);
        for (ExpandoTable expandoTable : expandoTables) {
            if (expandoTable.getCompanyId() != portletDataContext.getCompanyId()) continue;
            this._expandoTableLocalService.deleteTable(expandoTable);
        }
    }

    public StagedExpandoTable fetchMissingReference(String uuid, long groupId) {
        return null;
    }

    public StagedExpandoTable fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return null;
    }

    public List<StagedExpandoTable> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        DynamicQuery dynamicQuery = this._expandoTableLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        String className = this._parseClassName(uuid);
        dynamicQuery.add(classNameIdProperty.eq((Object)this._portal.getClassNameId(className)));
        Property nameProperty = PropertyFactoryUtil.forName((String)"name");
        String name = this._parseName(uuid);
        dynamicQuery.add(nameProperty.eq((Object)name));
        List expandoTables = this._expandoTableLocalService.dynamicQuery(dynamicQuery);
        if (ListUtil.isNotEmpty((List)expandoTables)) {
            return ModelAdapterUtil.adapt((List)expandoTables, ExpandoTable.class, StagedExpandoTable.class);
        }
        return Collections.emptyList();
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = StagedExpandoTableStagedModelRepository.this._exportImportHelper.getModelDeletionCount(portletDataContext, stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        exportActionableDynamicQuery.setBaseLocalService((BaseLocalService)this._expandoTableLocalService);
        Class expandoTableLocalServiceClass = this._expandoTableLocalService.getClass();
        exportActionableDynamicQuery.setClassLoader(expandoTableLocalServiceClass.getClassLoader());
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setModelClass(ExpandoTable.class);
        exportActionableDynamicQuery.setPerformActionMethod(expandoTable -> {
            ClassName className = this._classNameLocalService.fetchClassName(expandoTable.getClassNameId());
            if (className == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No class name exists for class name ID " + expandoTable.getClassNameId()));
                }
                return;
            }
            StagedExpandoTable stagedExpandoTable = (StagedExpandoTable)ModelAdapterUtil.adapt((Object)expandoTable, ExpandoTable.class, StagedExpandoTable.class);
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedExpandoTable);
        });
        exportActionableDynamicQuery.setPrimaryKeyPropertyName("tableId");
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(StagedExpandoTable.class));
        return exportActionableDynamicQuery;
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, StagedExpandoTable stagedModel) throws PortletDataException {
    }

    public StagedExpandoTable saveStagedModel(StagedExpandoTable stagedExpandoTable) throws PortalException {
        ExpandoTable expandoTable = this._expandoTableLocalService.updateExpandoTable((ExpandoTable)stagedExpandoTable);
        return (StagedExpandoTable)ModelAdapterUtil.adapt((Object)expandoTable, ExpandoTable.class, StagedExpandoTable.class);
    }

    public StagedExpandoTable updateStagedModel(PortletDataContext portletDataContext, StagedExpandoTable stagedExpandoTable) throws PortalException {
        throw new UnsupportedOperationException();
    }

    private String _parseClassName(String uuid) {
        return uuid.substring(0, uuid.indexOf("#"));
    }

    private String _parseName(String uuid) {
        return uuid.substring(uuid.indexOf("#") + 1);
    }
}

